/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import org.opensourcephysics.stp.percolation.PercolationLattice;

public class HoshenKopelman {
    public static final int OCCUPIED = 1;
    public static final int EMPTY = 0;
    int[] single_step = new int[2];
    int L;
    int ncluster;
    int[][] rsite;
    int[] np;
    static final int ASSIGN_MODE = 0;
    static final int PROPER_MODE = 1;
    int mode = 0;

    public HoshenKopelman(PercolationLattice percolationLattice, int n) {
        this.rsite = percolationLattice.rsite;
        this.np = new int[this.rsite.length * this.rsite.length];
        this.L = n;
        this.single_step[0] = 1;
        this.single_step[1] = 1;
    }

    public String getMode() {
        if (this.mode == 0) {
            return "Assigning cluster numbers to occupited sites";
        }
        if (this.mode == 1) {
            return "Assigning proper labels to cluster array.";
        }
        return "Algorithm finished.";
    }

    public boolean isComplete() {
        return this.mode != 0 && this.mode != 1;
    }

    public void compute() {
        int n;
        this.ncluster = 0;
        int n2 = 1;
        while (n2 <= this.L) {
            n = 1;
            while (n <= this.L) {
                this.assign(n, n2);
                ++n;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.L) {
            n = 1;
            while (n <= this.L) {
                this.properLabel(n, n2);
                ++n;
            }
            ++n2;
        }
    }

    public int[] singleStep() {
        if (this.mode == 0) {
            this.assign(this.single_step[0], this.single_step[1]);
            this.increaseIndices();
            return this.single_step;
        }
        if (this.mode == 1) {
            this.properLabel(this.single_step[0], this.single_step[1]);
            this.increaseIndices();
            return this.single_step;
        }
        return null;
    }

    private void increaseIndices() {
        if (this.single_step[0] == this.L) {
            this.single_step[0] = 1;
            this.single_step[1] = this.single_step[1] + 1;
            if (this.single_step[1] == this.L + 1) {
                this.single_step[1] = 1;
                ++this.mode;
            }
        } else {
            this.single_step[0] = this.single_step[0] + 1;
        }
    }

    private void properLabel(int n, int n2) {
        if (this.rsite[n][n2] != 0) {
            this.rsite[n][n2] = this.proper(this.rsite[n][n2]);
        }
    }

    private void neighbor(int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n - 1;
        if (this.rsite[n][n3] * this.rsite[n4][n2] > 0) {
            this.labelMin(n, n2, n4, n3);
        } else {
            this.rsite[n][n2] = this.rsite[n][n3] > 0 ? this.rsite[n][n3] : this.rsite[n4][n2];
        }
    }

    private void assign(int n, int n2) {
        if (this.rsite[n][n2] == 1) {
            int n3 = n2 - 1;
            int n4 = n - 1;
            if (this.rsite[n][n3] + this.rsite[n4][n2] == 0) {
                this.rsite[n][n2] = ++this.ncluster;
                this.np[this.ncluster] = this.ncluster;
            } else {
                this.neighbor(n, n2);
            }
        }
    }

    private int proper(int n) {
        if (this.np[n] == n) {
            return n;
        }
        return this.proper(this.np[n]);
    }

    private void labelMin(int n, int n2, int n3, int n4) {
        if (this.rsite[n3][n2] == this.rsite[n][n4]) {
            this.rsite[n][n2] = this.rsite[n3][n2];
        } else {
            int n5;
            int n6 = this.proper(this.rsite[n3][n2]);
            int n7 = this.proper(this.rsite[n][n4]);
            int n8 = Math.max(n6, n7);
            this.rsite[n][n2] = n5 = Math.min(n6, n7);
            if (n5 != n8) {
                this.np[n8] = n5;
            }
        }
    }
}

