/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Random;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class PercolationLattice
implements Measurable {
    public int L;
    int[] currentSite = new int[2];
    Color selectedColor;
    static Color OCCUPIED_COLOR = Color.red;
    static Color EMPTY_COLOR = Color.white;
    int NONE;
    int selectedCluster = this.NONE = -99;
    public int[][] rsite;
    boolean displayClusterNumbers = true;

    public void initialize(int n, double d, Random random) {
        this.L = n;
        this.rsite = new int[n + 1][n + 1];
        this.fill(random, n, d);
        this.selectedCluster = this.NONE;
    }

    public void setDisplayCLusterNumbers(boolean bl) {
        this.displayClusterNumbers = bl;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.rsite == null) {
            return;
        }
        int n = (int)drawingPanel.getXPixPerUnit();
        int n2 = (int)drawingPanel.getYPixPerUnit();
        int n3 = 1;
        while (n3 <= this.L) {
            int n4 = 1;
            while (n4 <= this.L) {
                int n5 = this.rsite[n4][n3];
                if (n5 == this.selectedCluster) {
                    graphics.setColor(this.selectedColor);
                } else if (n5 == 0) {
                    graphics.setColor(EMPTY_COLOR);
                } else {
                    graphics.setColor(OCCUPIED_COLOR);
                }
                int n6 = drawingPanel.xToPix(n4);
                int n7 = drawingPanel.yToPix(n3 + 1);
                if (this.currentSite != null && this.currentSite[0] == n4 && this.currentSite[1] == n3) {
                    graphics.setColor(Color.yellow);
                }
                graphics.fillRect(n6, n7, n, n2);
                if (this.displayClusterNumbers && n5 != 0) {
                    graphics.setColor(Color.black);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    String string = String.valueOf(n5);
                    int n8 = fontMetrics.stringWidth(string);
                    int n9 = fontMetrics.getHeight();
                    graphics.drawString(string, n6 + n / 2 - n8 / 2, n7 + n2 / 2 + n9 / 2);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public static void fill(Random random, int[][] nArray, int n, double d) {
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 1;
            while (n3 <= n) {
                double d2 = random.nextDouble();
                nArray[n3][n2] = d2 < d ? 1 : 0;
                ++n3;
            }
            ++n2;
        }
    }

    public void fill(Random random, int n, double d) {
        int n2 = 1;
        while (n2 <= n) {
            int n3 = 1;
            while (n3 <= n) {
                double d2 = random.nextDouble();
                this.rsite[n3][n2] = d2 < d ? 1 : 0;
                ++n3;
            }
            ++n2;
        }
    }

    public double getXMin() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getXMax() {
        return this.L + 2;
    }

    public double getYMax() {
        return this.L + 2;
    }

    public boolean isMeasured() {
        return this.rsite != null;
    }
}

