/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import java.awt.Color;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.LatticeFrame;

public class RGPercolationApp
extends AbstractCalculation {
    LatticeFrame[] blockedLattices;
    int n = 0;

    public void calculate() {
        int n = this.n;
        int n2 = this.control.getInt("L");
        this.n = 1 + (int)(Math.log(n2) / Math.log(2.0) + 0.001);
        if (n != this.n) {
            if (n > 0) {
                int n3 = 0;
                while (n3 < n) {
                    this.blockedLattices[n3].setVisible(false);
                    this.blockedLattices[n3].dispose();
                    ++n3;
                }
            }
            this.blockedLattices = new LatticeFrame[this.n];
        }
        double d = this.control.getDouble("p");
        if (this.n != n) {
            this.blockedLattices[0] = new LatticeFrame("Original Lattice");
        }
        this.newLattice(n2, d, this.blockedLattices[0]);
        int n4 = n2 / 2;
        this.setLatticeColors(this.blockedLattices[0]);
        this.blockedLattices[0].setVisible(true);
        int n5 = 1;
        while (n5 < this.n) {
            if (this.n != n) {
                this.blockedLattices[n5] = new LatticeFrame(String.valueOf(n4) + "x" + n4 + " Coarse Grained Lattice");
                this.setLatticeColors(this.blockedLattices[n5]);
            }
            this.block(this.blockedLattices[n5 - 1], this.blockedLattices[n5], n4);
            this.blockedLattices[n5].setVisible(true);
            n4 /= 2;
            ++n5;
        }
    }

    public void reset() {
        this.control.setValue("L", 64);
        this.control.setValue("p", 0.5927);
    }

    public void newLattice(int n, double d, LatticeFrame latticeFrame) {
        latticeFrame.resizeLattice(n, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                if (Math.random() < d) {
                    latticeFrame.setValue(n2, n3, 1);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void block(LatticeFrame latticeFrame, LatticeFrame latticeFrame2, int n) {
        latticeFrame2.resizeLattice(n, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = latticeFrame.getValue(2 * n2, 2 * n3) * latticeFrame.getValue(2 * n2, 2 * n3 + 1);
                int n5 = latticeFrame.getValue(2 * n2 + 1, 2 * n3) * latticeFrame.getValue(2 * n2 + 1, 2 * n3 + 1);
                if (n4 == 1 || n5 == 1) {
                    latticeFrame2.setValue(n2, n3, 1);
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setLatticeColors(LatticeFrame latticeFrame) {
        latticeFrame.setIndexedColor(0, Color.WHITE);
        latticeFrame.setIndexedColor(1, Color.BLUE);
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new RGPercolationApp(), stringArray);
    }
}

