/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.productprocess;

import java.text.NumberFormat;
import java.util.Random;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.HistogramFrame;

public class ProductProcessApp
extends AbstractSimulation {
    HistogramFrame histogramFrame = new HistogramFrame("log(Product)", "Occurences", "Histogram");
    Random random = new Random();
    NumberFormat numberFormat = NumberFormat.getInstance();
    double probability;
    double x;
    double y;
    double product;
    double time;
    double dt;
    double sum = 0.0;
    double sum2 = 0.0;
    int numberOfMultiplication;
    int numberOfRuns = 0;

    public ProductProcessApp() {
        this.numberFormat.setMaximumFractionDigits(4);
    }

    public void initialize() {
        this.numberOfMultiplication = this.control.getInt("N");
        this.probability = this.control.getDouble("probability");
        this.x = this.control.getDouble("x1");
        this.y = this.control.getDouble("x2");
        this.product = 1.0;
        double d = this.x;
        if (this.y > this.x) {
            d = this.y;
        }
        d = (double)this.numberOfMultiplication * Math.log(d);
        int n = this.numberOfMultiplication;
        double d2 = d / (double)n;
        this.histogramFrame.setAutoscaleX(true);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.setBinWidth(d2);
        this.random.setSeed(System.currentTimeMillis());
        this.product = 1.0;
        this.sum = 0.0;
        this.sum2 = 0.0;
        this.numberOfRuns = 0;
    }

    public void start() {
        this.probability = this.control.getDouble("probability");
    }

    public void stop() {
        this.output();
    }

    public void reset() {
        this.probability = 0.5;
        this.numberOfMultiplication = 4;
        this.x = 2.0;
        this.y = 0.5;
        this.control.setValue("N", this.numberOfMultiplication);
        this.control.setValue("probability", this.probability);
        this.control.setValue("x1", this.x);
        this.control.setValue("x2", this.y);
        this.product = 1.0;
        this.control.clearMessages();
        this.sum = 0.0;
        this.sum2 = 0.0;
        this.numberOfRuns = 0;
        this.enableStepsPerDisplay(true);
    }

    public void output() {
        double d = this.sum / (double)this.numberOfRuns;
        double d2 = this.sum2 / (double)this.numberOfRuns;
        double d3 = Math.sqrt(d2 - d * d);
        this.control.clearMessages();
        this.control.println("# of trials = " + this.numberOfRuns);
        this.control.println("<product> = " + this.numberFormat.format(d));
        this.control.println("<product*product> = " + this.numberFormat.format(d2));
        this.control.println("sigma = " + this.numberFormat.format(d3));
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new ProductProcessApp(), stringArray);
    }

    protected void doStep() {
        this.probability = this.control.getDouble("probability");
        this.product = 1.0;
        int n = 0;
        while (n < this.numberOfMultiplication) {
            this.product = this.random.nextDouble() < this.probability ? (this.product *= this.x) : (this.product *= this.y);
            ++n;
        }
        this.sum += this.product;
        this.sum2 += this.product * this.product;
        ++this.numberOfRuns;
        this.histogramFrame.append(Math.log(this.product));
    }
}

