/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.qmc;

public class QMC {
    public int[] x;
    public int[] y;
    public int[] z;
    public int[] occupation;
    public int[] occupationAccum;
    public int[] state;
    public double[] energy;
    public double[] densityOfStates;
    public int dimension;
    public int maxEnergy;
    public double p;
    public double p2;
    public double dE;
    public int kmax;
    public int np;
    public int arraySize;
    public int occupiedIndexMax;
    public double beta;
    public int mcs;
    public int accept;
    public double energyAccum;
    public double energySqAccum;

    public void initial(int n, int n2, double d, int n3, int n4, double d2) {
        this.dimension = n;
        this.kmax = n2;
        this.p = d;
        this.np = n3;
        this.dE = d2;
        this.p2 = d / 2.0;
        this.maxEnergy = (int)Math.pow(n2, d);
        this.densityOfStates = new double[(int)(((double)this.maxEnergy + d2) / d2)];
        this.arraySize = this.findArraySize();
        this.x = new int[this.arraySize];
        this.y = new int[this.arraySize];
        this.z = new int[this.arraySize];
        this.occupation = new int[this.arraySize];
        this.energy = new double[this.arraySize];
        this.state = new int[n3];
        this.orderLevels();
        if (n4 == 1) {
            int n5 = 0;
            while (n5 < n3) {
                this.occupation[n5] = 1;
                this.state[n5] = n5;
                ++n5;
            }
        } else {
            this.occupation[0] = n3;
            int n6 = 0;
            while (n6 < n3) {
                this.state[n6] = 0;
                ++n6;
            }
        }
        this.mcs = 0;
        this.occupationAccum = new int[this.arraySize];
        this.occupiedIndexMax = n3;
        this.energySqAccum = 0.0;
        this.energyAccum = 0.0;
    }

    public void resetData() {
        this.occupationAccum = new int[this.arraySize];
        this.mcs = 0;
        this.energySqAccum = 0.0;
        this.energyAccum = 0.0;
    }

    public void stepFD() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.np) {
            double d;
            int n3 = (int)(Math.random() * (double)this.np);
            n = Math.random() > 0.5 && this.state[n3] < this.arraySize - 2 || this.state[n3] == 0 ? this.state[n3] + 1 : this.state[n3] - 1;
            if (this.occupation[n] == 0 && ((d = this.energy[n] - this.energy[this.state[n3]]) < 0.0 || Math.exp(-d * this.beta) >= Math.random())) {
                this.occupation[this.state[n3]] = 0;
                this.occupation[n] = 1;
                this.state[n3] = n;
                ++this.accept;
                if (n > this.occupiedIndexMax) {
                    this.occupiedIndexMax = n;
                }
            }
            ++n2;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 <= this.occupiedIndexMax) {
            int n5 = n4;
            this.occupationAccum[n5] = this.occupationAccum[n5] + this.occupation[n4];
            d += this.energy[n4] * (double)this.occupation[n4];
            ++n4;
        }
        this.energyAccum += d;
        this.energySqAccum += d * d;
        ++this.mcs;
    }

    public void stepBE() {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.np) {
            double d;
            boolean bl = false;
            n = (int)(Math.random() * (double)this.np);
            if (Math.random() > 0.5 && this.state[n] < this.arraySize - 2 || this.state[n] == 0) {
                n2 = this.state[n] + 1;
                if (n == this.np - 1 || this.state[n + 1] >= n2) {
                    bl = true;
                }
            } else {
                n2 = this.state[n] - 1;
                if (n == 0 || this.state[n - 1] <= n2) {
                    bl = true;
                }
            }
            if (bl && ((d = this.energy[n2] - this.energy[this.state[n]]) < 0.0 || Math.exp(-d * this.beta) >= Math.random())) {
                int n4 = this.state[n];
                this.occupation[n4] = this.occupation[n4] - 1;
                int n5 = n2;
                this.occupation[n5] = this.occupation[n5] + 1;
                this.state[n] = n2;
                ++this.accept;
                if (n2 > this.occupiedIndexMax) {
                    this.occupiedIndexMax = n2;
                }
            }
            ++n3;
        }
        double d = 0.0;
        n = 0;
        while (n <= this.occupiedIndexMax) {
            int n6 = n;
            this.occupationAccum[n6] = this.occupationAccum[n6] + this.occupation[n];
            d += this.energy[n] * (double)this.occupation[n];
            ++n;
        }
        this.energyAccum += d;
        this.energySqAccum += d * d;
        ++this.mcs;
    }

    public void stepMB() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.np) {
            int n3 = (int)(Math.random() * (double)this.np);
            n = Math.random() > 0.5 && this.state[n3] < this.arraySize - 2 || this.state[n3] == 0 ? this.state[n3] + 1 : this.state[n3] - 1;
            double d = this.energy[n] - this.energy[this.state[n3]];
            if (d < 0.0 || Math.exp(-d * this.beta) >= Math.random()) {
                int n4 = this.state[n3];
                this.occupation[n4] = this.occupation[n4] - 1;
                int n5 = n;
                this.occupation[n5] = this.occupation[n5] + 1;
                this.state[n3] = n;
                ++this.accept;
                if (n > this.occupiedIndexMax) {
                    this.occupiedIndexMax = n;
                }
            }
            ++n2;
        }
        double d = 0.0;
        int n6 = 0;
        while (n6 <= this.occupiedIndexMax) {
            int n7 = n6;
            this.occupationAccum[n7] = this.occupationAccum[n7] + this.occupation[n6];
            d += this.energy[n6] * (double)this.occupation[n6];
            ++n6;
        }
        this.energyAccum += d;
        this.energySqAccum += d * d;
        ++this.mcs;
    }

    public int findArraySize() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.kmax * this.kmax;
        switch (this.dimension) {
            case 1: {
                n3 = 2 * this.kmax;
            }
            case 2: {
                n2 = -this.kmax;
                while (n2 <= this.kmax) {
                    n = -this.kmax;
                    while (n <= this.kmax) {
                        if (n2 * n2 + n * n <= n4) {
                            ++n3;
                        }
                        ++n;
                    }
                    ++n2;
                }
                break;
            }
        }
        n2 = -this.kmax;
        while (n2 <= this.kmax) {
            n = -this.kmax;
            while (n <= this.kmax) {
                int n5 = -this.kmax;
                while (n5 <= this.kmax) {
                    if (n2 * n2 + n * n + n5 * n5 <= n4) {
                        ++n3;
                    }
                    ++n5;
                }
                ++n;
            }
            ++n2;
        }
        return n3 + 1;
    }

    public void orderLevels() {
        int n = 0;
        int n2 = this.kmax * this.kmax;
        this.densityOfStates[0] = 1.0;
        switch (this.dimension) {
            case 1: {
                int n3 = 1;
                while (n3 <= this.kmax) {
                    if (Math.random() < 0.5) {
                        this.energy[++n] = Math.pow(n3 * n3, this.p2);
                        this.x[n] = n3;
                        this.energy[++n] = this.energy[n - 1];
                        this.x[n] = -n3;
                        int n4 = (int)(this.energy[n] / this.dE);
                        this.densityOfStates[n4] = this.densityOfStates[n4] + 2.0;
                    } else {
                        this.energy[++n] = Math.pow(n3 * n3, this.p2);
                        this.x[n] = -n3;
                        this.energy[++n] = this.energy[n - 1];
                        this.x[n] = n3;
                        int n5 = (int)(this.energy[n] / this.dE);
                        this.densityOfStates[n5] = this.densityOfStates[n5] + 2.0;
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                int n6 = -this.kmax;
                while (n6 <= this.kmax) {
                    int n7 = -this.kmax;
                    while (n7 <= this.kmax) {
                        if (n6 * n6 + n7 * n7 <= n2 && (n6 != 0 || n7 != 0)) {
                            this.insert(++n, n6 * n6 + n7 * n7, n6, n7, 0);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                break;
            }
            default: {
                int n8 = -this.kmax;
                while (n8 <= this.kmax) {
                    int n9 = -this.kmax;
                    while (n9 <= this.kmax) {
                        int n10 = -this.kmax;
                        while (n10 <= this.kmax) {
                            if (n8 * n8 + n9 * n9 + n10 * n10 <= n2 && (n8 != 0 || n9 != 0 || n10 != 0)) {
                                this.insert(++n, n8 * n8 + n9 * n9 + n10 * n10, n8, n9, n10);
                            }
                            ++n10;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                break block0;
            }
        }
    }

    public void insert(int n, int n2, int n3, int n4, int n5) {
        double d = Math.pow(n2, this.p2);
        int n6 = this.binarySearch(n, d);
        int n7 = n;
        while (n7 > n6) {
            this.energy[n7] = this.energy[n7 - 1];
            this.x[n7] = this.x[n7 - 1];
            this.y[n7] = this.y[n7 - 1];
            this.z[n7] = this.z[n7 - 1];
            --n7;
        }
        this.energy[n6] = d;
        int n8 = (int)(d / this.dE);
        this.densityOfStates[n8] = this.densityOfStates[n8] + 1.0;
        this.x[n6] = n3;
        this.y[n6] = n4;
        this.z[n6] = n5;
    }

    public int binarySearch(int n, double d) {
        int n2 = 0;
        int n3 = n;
        int n4 = (n2 + n3) / 2;
        while (n3 - n2 > 1) {
            if (d < this.energy[n4]) {
                n3 = n4;
            } else {
                n2 = n4;
            }
            n4 = (n2 + n3) / 2;
        }
        return n3;
    }
}

