/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.saw;

import org.opensourcephysics.stp.randomwalk.saw.OneWalker;

public class Flat {
    double xAccum;
    double xSquaredAccum;
    double yAccum;
    double ySquaredAccum;
    double norm;
    int numberOfWalkers;
    OneWalker[] walker;
    int[] remove;
    int maxWalkers;

    public void initialize() {
        this.xAccum = 0.0;
        this.yAccum = 0.0;
        this.xSquaredAccum = 0.0;
        this.ySquaredAccum = 0.0;
        this.norm = 0.0;
        this.maxWalkers = this.numberOfWalkers * 5;
        this.walker = new OneWalker[this.maxWalkers];
        this.remove = new int[this.maxWalkers];
        int n = 0;
        while (n < this.numberOfWalkers) {
            this.walker[n] = new OneWalker();
            this.walker[n].newWalker(this);
            ++n;
        }
    }

    public void step() {
        this.xAccum = 0.0;
        this.yAccum = 0.0;
        this.xSquaredAccum = 0.0;
        this.ySquaredAccum = 0.0;
        this.norm = 0.0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.numberOfWalkers) {
            this.walker[n2].step(this);
            ++n2;
        }
        n2 = this.numberOfWalkers;
        int n3 = 0;
        while (n3 < n2) {
            double d = (double)n2 * this.walker[n3].weight / this.norm;
            if (d > 1.0) {
                int n4 = (int)d;
                if (this.walker[n3].m < n4) {
                    n4 = this.walker[n3].m;
                }
                double d2 = this.walker[n3].weight / (double)n4;
                int n5 = 0;
                while (n5 < n4) {
                    if (this.numberOfWalkers < this.maxWalkers) {
                        this.walker[this.numberOfWalkers] = new OneWalker();
                        this.walker[this.numberOfWalkers].copyWalker(this.walker[n3], d2);
                        ++this.numberOfWalkers;
                    }
                    ++n5;
                }
            } else if (Math.random() < 1.0 - d) {
                this.remove[n] = n3;
                ++n;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            --this.numberOfWalkers;
            this.walker[this.remove[n3]] = this.walker[this.numberOfWalkers];
            ++n3;
        }
    }
}

