/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.secondvirial;

import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Integral;

public class SecondVirialApp
extends AbstractCalculation
implements Function {
    PlotFrame pf = new PlotFrame("T", "B_2", "Second Virial Coefficient");
    double Tmin;
    double Tmax;
    double T;
    int numberOfPoints = 400;

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new SecondVirialApp(), stringArray);
    }

    public void reset() {
        this.control.setValue("Tmin", 0.5);
        this.control.setValue("Tmax", 5);
        this.pf.clearData();
    }

    public void initialize() {
        this.Tmin = this.control.getDouble("Tmin");
        this.Tmax = this.control.getDouble("Tmax");
        this.pf.clearData();
    }

    public void calculate() {
        double d = 1.0E-6;
        double d2 = 10000.0;
        double d3 = 1.0E-4;
        this.initialize();
        double d4 = (this.Tmax - this.Tmin) / (double)this.numberOfPoints;
        double d5 = this.Tmin;
        while (d5 < this.Tmax) {
            this.T = d5;
            double d6 = Integral.simpson(this, d, d2, 20, d3);
            this.pf.append(0, this.T, d6);
            d5 += d4;
        }
    }

    public double evaluate(double d) {
        double d2 = d * d;
        double d3 = 1.0 / d2;
        double d4 = d3 * d3 * d3;
        double d5 = Math.exp(-(1.0 / this.T) * 4.0 * (d4 * d4 - d4));
        return Math.PI * 2 * (1.0 - d5);
    }
}

