/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.sensitive;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class LJgas
implements Drawable {
    double[] x;
    double[] y;
    double[] vx;
    double[] vy;
    double[] ax;
    double[] ay;
    int numberOfParticles = 11;
    double cellLength = 11.0;
    double x0;
    double x1;
    int steps = 0;
    double dt = 0.01;
    double radius = 0.5;
    double cut2 = 9.0;
    double t = 0.0;
    double timeDirection = 1.0;

    public void setArrays() {
        int n = this.numberOfParticles;
        this.x = new double[n];
        this.y = new double[n];
        this.vx = new double[n];
        this.vy = new double[n];
        this.ax = new double[n];
        this.ay = new double[n];
    }

    public void initialize() {
        this.steps = 0;
        this.t = 0.0;
        this.dt = 0.01;
        this.numberOfParticles = 11;
        this.cellLength = 11.0;
        this.timeDirection = 1.0;
        this.setArrays();
        this.setPositions();
        this.setVelocities();
        this.accel();
    }

    public void zeroAverages() {
        this.steps = 0;
    }

    public void step() {
        double d = 0.5 * this.dt * this.dt;
        double d2 = 0.5 * this.dt;
        int n = 0;
        while (n < this.numberOfParticles) {
            int n2 = n;
            this.x[n2] = this.x[n2] + (this.vx[n] * this.dt + this.ax[n] * d);
            int n3 = n;
            this.y[n3] = this.y[n3] + (this.vy[n] * this.dt + this.ay[n] * d);
            this.x[n] = this.image(this.x[n]);
            this.y[n] = this.image(this.y[n]);
            int n4 = n;
            this.vx[n4] = this.vx[n4] + this.ax[n] * d2;
            int n5 = n;
            this.vy[n5] = this.vy[n5] + this.ay[n] * d2;
            ++n;
        }
        this.accel();
        n = 0;
        while (n < this.numberOfParticles) {
            int n6 = n;
            this.vx[n6] = this.vx[n6] + this.ax[n] * d2;
            int n7 = n;
            this.vy[n7] = this.vy[n7] + this.ay[n] * d2;
            ++n;
        }
        ++this.steps;
        this.t += this.timeDirection * this.dt;
    }

    public void perturb(double d) {
        this.vx[6] = this.vx[6] * d;
    }

    public void reverse() {
        int n = 0;
        while (n < this.numberOfParticles) {
            this.vx[n] = -this.vx[n];
            this.vy[n] = -this.vy[n];
            ++n;
        }
        this.timeDirection *= -1.0;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (this.x == null) {
            return;
        }
        int n3 = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n4 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < this.numberOfParticles) {
            n2 = drawingPanel.xToPix(this.x[n5]) - n3;
            n = drawingPanel.yToPix(this.y[n5]) - n4;
            graphics.fillOval(n2, n, 2 * n3, 2 * n4);
            ++n5;
        }
        graphics.setColor(Color.black);
        n5 = drawingPanel.xToPix(0.0);
        n2 = drawingPanel.yToPix(this.cellLength);
        n = drawingPanel.xToPix(this.cellLength) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.cellLength);
        graphics.drawRect(n5, n2, n, n6);
    }

    private void setPositions() {
        double d = this.cellLength / 2.0;
        double d2 = this.cellLength / (double)this.numberOfParticles;
        int n = 0;
        while (n < this.numberOfParticles) {
            this.x[n] = d;
            this.y[n] = ((double)n + 0.5) * d2;
            ++n;
        }
    }

    private void setVelocities() {
        int n = 0;
        while (n < this.numberOfParticles) {
            this.vx[n] = 1.0;
            this.vy[n] = 0.0;
            ++n;
        }
    }

    private void accel() {
        int n = 0;
        while (n < this.numberOfParticles) {
            this.ax[n] = 0.0;
            this.ay[n] = 0.0;
            ++n;
        }
        n = 0;
        while (n < this.numberOfParticles - 1) {
            int n2 = n + 1;
            while (n2 < this.numberOfParticles) {
                double d;
                double d2 = this.pbc(this.x[n] - this.x[n2]);
                double d3 = d2 * d2 + (d = this.pbc(this.y[n] - this.y[n2])) * d;
                if (d3 < this.cut2) {
                    double d4 = 1.0 / d3;
                    double d5 = d4 * d4 * d4;
                    double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                    double d7 = d6 * d2;
                    double d8 = d6 * d;
                    int n3 = n;
                    this.ax[n3] = this.ax[n3] + d7;
                    int n4 = n;
                    this.ay[n4] = this.ay[n4] + d8;
                    int n5 = n2;
                    this.ax[n5] = this.ax[n5] - d7;
                    int n6 = n2;
                    this.ay[n6] = this.ay[n6] - d8;
                }
                ++n2;
            }
            ++n;
        }
    }

    private double pbc(double d) {
        if (d > 0.5 * this.cellLength) {
            d -= this.cellLength;
        } else if (d < -0.5 * this.cellLength) {
            d += this.cellLength;
        }
        return d;
    }

    private double image(double d) {
        if (d > this.cellLength) {
            d -= this.cellLength;
        } else if (d < 0.0) {
            d += this.cellLength;
        }
        return d;
    }
}

