/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.sensitive;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.stp.sensitive.LJgas;

public class LJgasApp
extends AbstractSimulation {
    LJgas gas;
    DisplayFrame displayFrame = new DisplayFrame("");
    NumberFormat numberformat = NumberFormat.getInstance();

    public LJgasApp() {
        this.gas = new LJgas();
        this.displayFrame.addDrawable(this.gas);
        this.displayFrame.setPreferredMinMax(-0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength, -0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength);
        this.numberformat.setMaximumIntegerDigits(5);
        this.numberformat.setMinimumIntegerDigits(1);
        this.numberformat.setMinimumFractionDigits(1);
    }

    public void initialize() {
        this.gas.cellLength = 11.0;
        this.gas.initialize();
    }

    public void doStep() {
        int n = 0;
        while (n < 20) {
            this.gas.step();
            ++n;
        }
        this.displayFrame.setMessage("time = " + this.numberformat.format(this.gas.t));
        this.displayFrame.render();
    }

    public void reset() {
        this.gas.initialize();
        this.control.setValue("perturbation strength", 1.00001);
        this.displayFrame.setPreferredMinMax(-0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength, -0.2 * this.gas.cellLength, 1.2 * this.gas.cellLength);
        this.displayFrame.render();
    }

    public void perturb() {
        double d = this.control.getDouble("perturbation strength");
        this.gas.perturb(d);
        this.gas.zeroAverages();
    }

    public void reverse() {
        this.gas.reverse();
        this.gas.zeroAverages();
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new LJgasApp(), stringArray);
        simulationControl.addButton("perturb", "Perturb");
        simulationControl.addButton("reverse", "Reverse");
    }
}

