/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.thermalcontact;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;

public class ParticleBoard
implements Measurable {
    public int Na;
    public int Nb;
    public double Lx;
    public double Ly;
    public double Bx = 0.0;
    public double By = 0.0;
    public double[] pos_x;
    public double[] pos_y;
    public double diam;
    public int opacity = 200;

    public ParticleBoard(int n, int n2, double d, double d2, double d3) {
        this.Na = n;
        this.Nb = n2;
        this.Lx = d;
        this.Ly = d2;
        this.diam = d3;
        this.pos_x = new double[this.Na + this.Nb];
        this.pos_y = new double[this.Na + this.Nb];
    }

    public void setParticle(int n, double d, double d2) {
        this.pos_x[n] = d;
        this.pos_y[n] = d2;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.xToPix(this.diam / 2.0) - drawingPanel.xToPix(0.0);
        int n2 = -(drawingPanel.yToPix(this.diam / 2.0) - drawingPanel.yToPix(0.0));
        int n3 = drawingPanel.xToPix(this.Lx) - drawingPanel.xToPix(0.0);
        int n4 = -(drawingPanel.yToPix(this.Ly) - drawingPanel.yToPix(0.0));
        graphics.setColor(new Color(160, 160, 160, 128));
        graphics.fillRect(drawingPanel.xToPix(this.Bx), drawingPanel.yToPix(this.By) - n4, n3, n4);
        graphics.setColor(new Color(255, 255, 0, this.opacity));
        int n5 = 0;
        while (n5 < this.Na) {
            graphics.fillOval(drawingPanel.xToPix(this.Bx + this.pos_x[n5] - this.diam / 2.0), drawingPanel.yToPix(this.By + this.pos_y[n5] + this.diam / 2.0), 2 * n, 2 * n2);
            ++n5;
        }
        graphics.setColor(new Color(40, 40, 0, 255));
        n5 = 0;
        while (n5 < this.Na) {
            graphics.drawOval(drawingPanel.xToPix(this.Bx + this.pos_x[n5] - this.diam / 2.0), drawingPanel.yToPix(this.By + this.pos_y[n5] + this.diam / 2.0), 2 * n, 2 * n2);
            ++n5;
        }
        graphics.setColor(new Color(128, 128, 255, this.opacity));
        n5 = this.Na;
        while (n5 < this.Na + this.Nb) {
            graphics.fillOval(drawingPanel.xToPix(this.Bx + this.pos_x[n5] - this.diam / 2.0), drawingPanel.yToPix(this.By + this.pos_y[n5] + this.diam / 2.0), 2 * n, 2 * n2);
            ++n5;
        }
        graphics.setColor(new Color(40, 40, 255, 255));
        n5 = this.Na;
        while (n5 < this.Na + this.Nb) {
            graphics.drawOval(drawingPanel.xToPix(this.Bx + this.pos_x[n5] - this.diam / 2.0), drawingPanel.yToPix(this.By + this.pos_y[n5] + this.diam / 2.0), 2 * n, 2 * n2);
            ++n5;
        }
    }

    public double getXMin() {
        return this.Bx - this.diam / 2.0;
    }

    public double getXMax() {
        return this.Bx + this.Lx + this.diam / 2.0;
    }

    public double getYMin() {
        return this.By - this.diam / 2.0;
    }

    public double getYMax() {
        return this.By + this.Ly + this.diam / 2.0;
    }

    public boolean isMeasured() {
        return true;
    }
}

