/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.util;

public class DoubleArray {
    private int length = 0;
    private double[] data = new double[128];

    public static double[] concat(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
        System.arraycopy(dArray2, 0, dArray3, dArray.length, dArray2.length);
        return dArray3;
    }

    public static int maxIndex(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        int n2 = 1;
        while (n2 < dArray.length) {
            if (dArray[n2] > d) {
                d = dArray[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static int minIndex(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        int n2 = 1;
        while (n2 < dArray.length) {
            if (dArray[n2] < d) {
                d = dArray[n2];
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static double max(double[] dArray) {
        return dArray[DoubleArray.maxIndex(dArray)];
    }

    public static double min(double[] dArray) {
        return dArray[DoubleArray.minIndex(dArray)];
    }

    public int length() {
        return this.length;
    }

    public void append(double d) {
        if (this.length >= this.data.length) {
            this.increaseCapacity();
        }
        this.data[this.length++] = d;
    }

    public double get(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n];
    }

    private void increaseCapacity() {
        double[] dArray = new double[2 * this.length];
        System.arraycopy(this.data, 0, dArray, 0, this.length);
        this.data = dArray;
    }
}

