/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.util;

public class IntArray {
    private int length = 0;
    private int[] data = new int[32];

    public int length() {
        return this.length;
    }

    public void append(int n) {
        if (this.length >= this.data.length) {
            this.increaseCapacity();
        }
        this.data[this.length++] = n;
    }

    public int unappend() {
        if (this.length == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[--this.length];
    }

    public int get(int n) {
        if (n >= this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public void set(int n, int n2) {
        if (n > this.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data[n] = n2;
    }

    public int[] getArray() {
        int[] nArray = new int[this.length];
        System.arraycopy(this.data, 0, nArray, 0, this.length);
        return nArray;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.length) {
            if (this.data[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void increaseCapacity() {
        int[] nArray = new int[2 * this.length];
        System.arraycopy(this.data, 0, nArray, 0, this.length);
        this.data = nArray;
    }
}

