/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.util;

import java.awt.Color;
import java.util.Random;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.numerics.Function;

public class Util {
    public static Color randomColor() {
        return new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
    }

    public static int pbc(int n, int n2) {
        if (n >= n2) {
            return n - n2;
        }
        if (n < 0) {
            return n2 + n;
        }
        return n;
    }

    public static void fill(Random random, int[][] nArray, double d, int n, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = 0;
            while (n4 < nArray[0].length) {
                double d2 = random.nextDouble();
                nArray[n3][n4] = d2 < d ? n : n2;
                ++n4;
            }
            ++n3;
        }
    }

    public static void fill(Random random, int[][] nArray, double d) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = 0;
            while (n2 < nArray[0].length) {
                double d2 = random.nextDouble();
                nArray[n][n2] = d2 < d ? 1 : 0;
                ++n2;
            }
            ++n;
        }
    }

    public static Function computeLinearRegression(Dataset dataset) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double[] dArray = dataset.getXPoints();
        double[] dArray2 = dataset.getYPoints();
        int n = 0;
        while (n < dArray.length) {
            d5 = dArray[n];
            d6 = dArray2[n];
            d += d5 * d6;
            d2 += d5;
            d3 += d6;
            d4 += d5 * d5;
            ++n;
        }
        n = dArray.length;
        double d7 = (d4 /= (double)n) - (d2 /= (double)n) * d2;
        final double d8 = ((d /= (double)n) - d2 * (d3 /= (double)n)) / d7;
        final double d9 = d3 - d8 * d2;
        return new Function(){

            public double evaluate(double d) {
                return d8 * d + d9;
            }
        };
    }
}

