/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.widom;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Widom
implements Drawable {
    public double[] x;
    public double[] y;
    public int N;
    public double Lx;
    public double Ly;
    public double xc;
    public double yc;
    public double rho;
    public int steps;
    public double virialAccumulator;
    public double energyAccumulator;
    public double energySquaredAccumulator;
    public double virial;
    public double energy;
    public String initialConfiguration;
    public double radius;
    public double chemPotAccumulator;
    public double temperature;
    public double beta;
    public double ds;
    public double accept;

    public Widom() {
        this.rho = (double)this.N / (this.Lx * this.Ly);
        this.steps = 0;
        this.radius = 0.5;
    }

    public void initialize() {
        this.chemPotAccumulator = 0.0;
        this.rho = (double)this.N / (this.Lx * this.Ly);
        this.resetAverages();
        this.x = new double[this.N];
        this.y = new double[this.N];
        this.setRandomPositions();
        this.beta = 1.0 / this.temperature;
        this.computeTotals();
    }

    public void setRandomPositions() {
        int n = 0;
        while (n < this.N) {
            this.x[n] = this.Lx * Math.random();
            this.y[n] = this.Ly * Math.random();
            ++n;
        }
    }

    public double getMeanEnergy() {
        return this.energyAccumulator / (double)(this.N * this.steps);
    }

    public double getMeanPressure() {
        return 0.5 * this.virialAccumulator / ((double)this.steps * this.Lx * this.Ly);
    }

    public double getMeanChemicalPotential() {
        return -this.temperature * Math.log(this.chemPotAccumulator / (double)(this.steps * this.N));
    }

    public double getHeatCapacity() {
        double d = this.energyAccumulator / (double)this.steps;
        double d2 = this.energySquaredAccumulator / (double)this.steps;
        return this.beta * this.beta * (d2 - d * d) / (double)this.N;
    }

    public void resetAverages() {
        this.steps = 0;
        this.virialAccumulator = 0.0;
        this.energyAccumulator = 0.0;
        this.energySquaredAccumulator = 0.0;
        this.chemPotAccumulator = 0.0;
        this.accept = 0.0;
    }

    public void computeTotals() {
        this.energy = 0.0;
        this.virial = 0.0;
        int n = 0;
        while (n < this.N - 1) {
            int n2 = n + 1;
            while (n2 < this.N) {
                double d = this.pbcSeparation(this.x[n] - this.x[n2], this.Lx);
                double d2 = this.pbcSeparation(this.y[n] - this.y[n2], this.Ly);
                double d3 = d * d + d2 * d2;
                double d4 = 1.0 / d3;
                double d5 = d4 * d4 * d4;
                this.energy += 4.0 * d5 * (d5 - 1.0);
                double d6 = 48.0 * d5 * (d5 - 0.5) * d4;
                double d7 = d6 * d;
                double d8 = d6 * d2;
                this.virial += d * d7 + d2 * d8;
                ++n2;
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private double pbcSeparation(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > 0.5 * var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < -0.5 * var3_2)
            }
        }
        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    private double pbcPosition(double var1_1, double var3_2) {
        block2: {
            if (!(var1_1 > 0.0)) ** GOTO lbl7
            while (var1_1 > var3_2) {
                var1_1 -= var3_2;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 += var3_2;
lbl7:
                // 2 sources

                ** while (var1_1 < 0.0)
            }
        }
        return var1_1;
    }

    public void step() {
        double[] dArray = new double[]{0.0, 0.0};
        int n = 0;
        while (n < this.N) {
            double d;
            double d2;
            int n2 = (int)(Math.random() * (double)this.N);
            dArray = this.computeChange(n2, d2 = this.x[n2] + this.ds * (Math.random() - 0.5), d = this.y[n2] + this.ds * (Math.random() - 0.5));
            double d3 = dArray[0];
            if (d3 < 0.0 || Math.exp(-d3 * this.beta) > Math.random()) {
                this.x[n2] = d2;
                this.y[n2] = d;
                this.energy += d3;
                this.virial += dArray[1];
                this.accept += 1.0;
            }
            this.computeChemicalPotential();
            ++n;
        }
        ++this.steps;
        this.energyAccumulator += this.energy;
        this.virialAccumulator += this.virial;
        this.energySquaredAccumulator += this.energy * this.energy;
    }

    public double[] computeChange(int n, double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0};
        int n2 = 0;
        while (n2 < this.N) {
            if (n2 != n) {
                double d3 = this.pbcSeparation(this.x[n] - this.x[n2], this.Lx);
                double d4 = this.pbcSeparation(this.y[n] - this.y[n2], this.Ly);
                double d5 = d3 * d3 + d4 * d4;
                double d6 = 1.0 / d5;
                double d7 = d6 * d6 * d6;
                dArray[0] = dArray[0] - 4.0 * d7 * (d7 - 1.0);
                double d8 = 48.0 * d7 * (d7 - 0.5) * d6;
                double d9 = d8 * d3;
                double d10 = d8 * d4;
                dArray[1] = dArray[1] - (d3 * d9 + d4 * d10);
                d3 = this.pbcSeparation(d - this.x[n2], this.Lx);
                d4 = this.pbcSeparation(d2 - this.y[n2], this.Ly);
                d5 = d3 * d3 + d4 * d4;
                d6 = 1.0 / d5;
                d7 = d6 * d6 * d6;
                dArray[0] = dArray[0] + 4.0 * d7 * (d7 - 1.0);
                d8 = 48.0 * d7 * (d7 - 0.5) * d6;
                d9 = d8 * d3;
                d10 = d8 * d4;
                dArray[1] = dArray[1] + (d3 * d9 + d4 * d10);
            }
            ++n2;
        }
        return dArray;
    }

    public void computeChemicalPotential() {
        this.xc = this.Lx * Math.random();
        this.yc = this.Ly * Math.random();
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            double d2 = this.pbcSeparation(this.xc - this.x[n], this.Lx);
            double d3 = this.pbcSeparation(this.yc - this.y[n], this.Ly);
            double d4 = d2 * d2 + d3 * d3;
            double d5 = 1.0 / d4;
            double d6 = d5 * d5 * d5;
            d += 4.0 * d6 * (d6 - 1.0);
            ++n;
        }
        this.chemPotAccumulator += Math.exp(-this.beta * d);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.x == null) {
            return;
        }
        int n = Math.abs(drawingPanel.xToPix(this.radius) - drawingPanel.xToPix(0.0));
        int n2 = Math.abs(drawingPanel.yToPix(this.radius) - drawingPanel.yToPix(0.0));
        graphics.setColor(Color.green);
        int n3 = drawingPanel.xToPix(this.xc) - n;
        int n4 = drawingPanel.yToPix(this.yc) - n2;
        graphics.fillOval(n3, n4, 2 * n, 2 * n2);
        graphics.setColor(Color.red);
        int n5 = 0;
        while (n5 < this.N) {
            n3 = drawingPanel.xToPix(this.x[n5]) - n;
            n4 = drawingPanel.yToPix(this.y[n5]) - n2;
            graphics.fillOval(n3, n4, 2 * n, 2 * n2);
            ++n5;
        }
        graphics.setColor(Color.black);
        n3 = drawingPanel.xToPix(0.0);
        n4 = drawingPanel.yToPix(this.Ly);
        n5 = drawingPanel.xToPix(this.Lx) - drawingPanel.xToPix(0.0);
        int n6 = drawingPanel.yToPix(0.0) - drawingPanel.yToPix(this.Ly);
        graphics.drawRect(n3, n4, n5, n6);
    }
}

