/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.xymodel;

import java.text.DecimalFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.xymodel.XYModel;

public class XYAnimationApp
extends AbstractSimulation {
    XYModel xy = new XYModel();
    DisplayFrame displayFrame = new DisplayFrame("lattice");
    PlotFrame correlationPlot = new PlotFrame("r", "<s(r)s(0)>", "Spin-spin correlation function");
    boolean resetFlag = true;
    DecimalFormat numberFormatTwoDigits = (DecimalFormat)DecimalFormat.getInstance();
    DecimalFormat numberFormatFourDigits = (DecimalFormat)DecimalFormat.getInstance();
    int N;
    boolean showVortices = false;

    public XYAnimationApp() {
        this.numberFormatTwoDigits.setMaximumFractionDigits(2);
        this.numberFormatTwoDigits.setMinimumFractionDigits(2);
        this.numberFormatTwoDigits.setGroupingSize(100);
        this.numberFormatFourDigits.setMaximumFractionDigits(4);
        this.numberFormatFourDigits.setMinimumFractionDigits(4);
        this.numberFormatFourDigits.setGroupingSize(100);
        this.xy = new XYModel();
    }

    public void initialize() {
        int n = this.control.getInt("linear dimension of lattice");
        this.N = n * n;
        double d = this.control.getDouble("temperature");
        this.xy.setTemperature(d);
        double d2 = this.control.getDouble("Maximum angle change");
        long l = Math.abs((int)System.currentTimeMillis());
        this.xy.initialConfiguration = this.control.getString("initial configuration");
        this.xy.setSeed(l);
        this.xy.setLinearDimension(n);
        this.xy.initialize();
        this.displayFrame.clearData();
        this.displayFrame.addDrawable(this.xy);
        this.displayFrame.repaint();
        this.xy.setDThetaMax(d2);
    }

    public void stop() {
        this.output();
    }

    public void output() {
        this.control.clearMessages();
        this.control.println("number of MC steps = " + this.xy.getTime());
        this.control.println("temperature = " + this.numberFormatTwoDigits.format(this.xy.getTemperature()));
        this.control.println("acceptance probability = " + this.numberFormatTwoDigits.format(this.xy.getAcceptanceProbability()));
        this.control.println("<E/N> = " + this.numberFormatFourDigits.format(this.xy.getMeanEnergy() / (double)this.N));
        this.control.println("<M_x/N> = " + this.numberFormatFourDigits.format(this.xy.getMeanMagnetizationX() / (double)this.N));
        this.control.println("<M_y/N> = " + this.numberFormatFourDigits.format(this.xy.getMeanMagnetizationY() / (double)this.N));
        this.control.println("vorticity = " + this.numberFormatFourDigits.format(this.xy.getVorticity()));
        this.control.println("specific heat = " + this.numberFormatTwoDigits.format(this.xy.getHeatCapacity() / (double)this.N));
        this.control.println("susceptibility = " + this.numberFormatTwoDigits.format(this.xy.getSusceptibility() / (double)this.N));
        this.displayFrame.repaint();
    }

    public void reset() {
        this.control.clearMessages();
        this.control.setValue("linear dimension of lattice", 20);
        this.control.setAdjustableValue("temperature", 0.89);
        this.control.setValue("Maximum angle change", 6.28);
        OSPCombo oSPCombo = new OSPCombo(new String[]{"random", "ordered"}, 0);
        this.control.setValue("initial configuration", oSPCombo);
        this.resetFlag = true;
        this.enableStepsPerDisplay(true);
    }

    public void showVortex() {
        this.showVortices = !this.showVortices;
        this.xy.showVortex(this.showVortices);
        this.displayFrame.repaint();
    }

    public void hideVortex() {
        this.xy.showVortex(false);
        this.displayFrame.repaint();
    }

    public void xeroAverages() {
        this.xy.clearData();
        double d = this.control.getDouble("temperature");
        this.xy.setTemperature(d);
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new XYAnimationApp(), stringArray);
        simulationControl.addButton("showVortex", "Show/Hide Vortices");
        simulationControl.addButton("xeroAverages", "Xero Averages");
    }

    protected void doStep() {
        this.xy.step();
        this.xy.correlationFunction();
        this.correlationPlot.clearData();
        int n = 0;
        while (n < this.xy.L / 2) {
            this.correlationPlot.append(0, n, this.xy.correlation[n] / this.xy.norm[n]);
            ++n;
        }
        this.correlationPlot.setMessage("mcs = " + this.xy.getTime());
    }
}

