/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TristateCheckBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAutoloadManager
extends JDialog {
    SearchPathDialog searchPathDialog;
    String searchPathChooserDir = System.getProperty("user.home");
    Collection<String> searchPaths = new TreeSet<String>();
    JPanel functionPanel;
    JPanel instructionPanel;
    Box functionBox;
    Font lightFont;
    Font heavyFont;
    JButton closeButton;
    JButton searchPathsButton;
    JTextArea instructionArea;
    Dimension defaultSize = new Dimension(450, 400);
    Map<String, Map<String, ArrayList<String[]>>> autoloadData;
    int inset0 = 6;
    int inset1 = 20;
    int inset2 = 40;
    boolean refreshing = false;
    protected boolean initialized = false;

    protected AbstractAutoloadManager(JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dimension = new Dimension(this.defaultSize);
        double d = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d);
        this.setSize(dimension);
    }

    public void setAutoloadData(Map<String, Map<String, ArrayList<String[]>>> map) {
        this.autoloadData = map;
        this.refreshFunctionList();
    }

    public void setInstructions(String string) {
        this.instructionArea.setText(string);
        if (string != null) {
            this.getContentPane().add((Component)this.instructionPanel, "North");
        } else {
            this.getContentPane().remove(this.instructionPanel);
        }
    }

    public void addSearchPath(String string) {
        this.searchPaths.add(XML.forwardSlash(string));
    }

    public Collection<String> getSearchPaths() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.searchPaths);
        return treeSet;
    }

    protected void createGUI() {
        this.heavyFont = new JLabel().getFont().deriveFont(1);
        this.lightFont = this.heavyFont.deriveFont(0);
        this.instructionArea = new JTextArea();
        this.instructionArea.setEditable(false);
        this.instructionArea.setLineWrap(true);
        this.instructionArea.setWrapStyleWord(true);
        Border border = BorderFactory.createEtchedBorder();
        Border border2 = BorderFactory.createEmptyBorder(2, 4, 2, 4);
        this.instructionArea.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.instructionArea.setForeground(Color.blue);
        this.instructionPanel = new JPanel(new BorderLayout());
        this.instructionPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.instructionPanel.add((Component)this.instructionArea, "Center");
        this.functionPanel = new JPanel(new BorderLayout());
        this.functionBox = Box.createVerticalBox();
        this.functionBox.setBackground(Color.white);
        this.functionBox.setOpaque(true);
        this.refreshFunctionList();
        JScrollPane jScrollPane = new JScrollPane(this.functionBox);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.functionPanel.add((Component)jScrollPane, "Center");
        this.functionPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this.closeButton = new JButton();
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractAutoloadManager.this.setVisible(false);
            }
        });
        this.searchPathsButton = new JButton();
        this.searchPathsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractAutoloadManager.this.searchPathDialog == null) {
                    AbstractAutoloadManager.this.searchPathDialog = new SearchPathDialog();
                    AbstractAutoloadManager.this.searchPathDialog.setLocationRelativeTo(AbstractAutoloadManager.this);
                }
                FontSizer.setFonts(AbstractAutoloadManager.this.searchPathDialog, FontSizer.getLevel());
                AbstractAutoloadManager.this.searchPathDialog.refreshGUI();
                AbstractAutoloadManager.this.searchPathDialog.refreshFileList();
                AbstractAutoloadManager.this.searchPathDialog.setVisible(true);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(this.searchPathsButton);
        jPanel.add(this.closeButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.setContentPane(jPanel2);
        jPanel2.add((Component)this.functionPanel, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("AutoloadManager.Title"));
        this.closeButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.searchPathsButton.setText(String.valueOf(ToolsRes.getString("AutoloadManager.Button.SearchPaths")) + "...");
        this.refreshFunctionList();
    }

    protected void refreshFunctionList() {
        this.refreshing = true;
        this.functionBox.removeAll();
        if (this.autoloadData == null) {
            return;
        }
        String string = String.valueOf(ToolsRes.getString("AutoloadManager.Directory")) + ": ";
        for (String string2 : this.autoloadData.keySet()) {
            Box box = Box.createVerticalBox();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(String.valueOf(string) + XML.forwardSlash(string2));
            Font font = FontSizer.getResizedFont(this.heavyFont, FontSizer.getLevel());
            titledBorder.setTitleFont(font);
            Border border = BorderFactory.createEmptyBorder(6, 0, 6, 0);
            box.setBorder(BorderFactory.createCompoundBorder(border, titledBorder));
            this.functionBox.add(box);
            Map<String, ArrayList<String[]>> map = this.autoloadData.get(string2);
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            for (String string3 : map.keySet()) {
                treeMap.put(string3.toLowerCase(), string3);
            }
            for (String string3 : treeMap.keySet()) {
                int n = box.getComponentCount() == 0 ? 0 : 10;
                String string4 = (String)treeMap.get(string3);
                File file = new File(string2, string4);
                String string5 = XML.forwardSlash(file.getAbsolutePath());
                boolean bl = this.getFileSelectionState(string5) != TristateCheckBox.NOT_SELECTED;
                AutoloadFileCheckbox autoloadFileCheckbox = new AutoloadFileCheckbox(string2, string4);
                autoloadFileCheckbox.setBorder(BorderFactory.createEmptyBorder(n, this.inset1, 2, 0));
                autoloadFileCheckbox.setFont(this.heavyFont);
                Box box2 = Box.createHorizontalBox();
                box2.add(autoloadFileCheckbox);
                box2.add(Box.createHorizontalGlue());
                box.add(box2);
                Border border2 = BorderFactory.createEmptyBorder(0, 0, 0, 40);
                ArrayList<String[]> arrayList = map.get(string4);
                if (arrayList.isEmpty()) {
                    String[] stringArray = this.getEmptyMessage(this.inset2, bl);
                    box.add((Component)stringArray);
                }
                for (String[] stringArray : arrayList) {
                    Object object;
                    JLabel jLabel = null;
                    if (stringArray.length > 3) {
                        object = "[" + stringArray[3] + "]";
                        jLabel = new JLabel((String)object);
                        jLabel.setBorder(border2);
                        jLabel.setFont(this.lightFont);
                    }
                    object = new AutoloadFunctionCheckbox(string2, string4, stringArray);
                    ((JComponent)object).setFont(this.lightFont);
                    ((AbstractButton)object).setEnabled(bl);
                    box2 = Box.createHorizontalBox();
                    box2.add((Component)object);
                    box2.add(Box.createHorizontalGlue());
                    if (jLabel != null) {
                        box2.add(jLabel);
                    }
                    box2.setBorder(BorderFactory.createEmptyBorder(0, this.inset2, 0, 0));
                    box.add(box2);
                }
            }
            if (box.getComponentCount() != 0) continue;
            box.add(this.getEmptyMessage(this.inset1, true));
        }
        if (this.functionBox.getComponentCount() == 0) {
            this.functionBox.add(this.getEmptyMessage(this.inset0, true));
        }
        FontSizer.setFonts(this.functionBox, FontSizer.getLevel());
        this.refreshing = false;
    }

    public void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.instructionArea, n);
    }

    protected abstract void setFunctionSelected(String var1, String[] var2, boolean var3);

    protected abstract boolean isFunctionSelected(String var1, String[] var2);

    protected abstract void setFileSelected(String var1, boolean var2);

    protected abstract TristateCheckBox.State getFileSelectionState(String var1);

    protected abstract void refreshAutoloadData();

    private Box getEmptyMessage(int n, boolean bl) {
        JLabel jLabel = new JLabel(ToolsRes.getString("AutoloadManager.Label.NoFunctionsFound"));
        jLabel.setFont(this.lightFont);
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, n, 4, 0));
        jLabel.setEnabled(bl);
        Box box = Box.createHorizontalBox();
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private class AutoloadFileCheckbox
    extends TristateCheckBox {
        String directory;
        String fileName;
        boolean selected;

        private AutoloadFileCheckbox(String string, String string2) {
            this.directory = string;
            this.fileName = string2;
            File file = new File(this.directory, this.fileName);
            final String string3 = XML.forwardSlash(file.getAbsolutePath());
            this.setState(AbstractAutoloadManager.this.getFileSelectionState(string3));
            this.setText(this.fileName);
            this.setIconTextGap(10);
            this.setOpaque(false);
            this.setToolTipText(ToolsRes.getString("AutoloadManager.FileCheckbox.Tooltip"));
            this.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (((AutoloadFileCheckbox)AutoloadFileCheckbox.this).AbstractAutoloadManager.this.refreshing) {
                        return;
                    }
                    if (AutoloadFileCheckbox.this.getState() == TristateCheckBox.PART_SELECTED) {
                        ((AutoloadFileCheckbox)AutoloadFileCheckbox.this).AbstractAutoloadManager.this.refreshing = true;
                        AutoloadFileCheckbox.this.doClick(0);
                        ((AutoloadFileCheckbox)AutoloadFileCheckbox.this).AbstractAutoloadManager.this.refreshing = false;
                        return;
                    }
                    if (AutoloadFileCheckbox.this.selected == AutoloadFileCheckbox.this.isSelected()) {
                        return;
                    }
                    AutoloadFileCheckbox.this.selected = AutoloadFileCheckbox.this.isSelected();
                    AbstractAutoloadManager.this.setFileSelected(string3, AutoloadFileCheckbox.this.selected);
                }
            });
        }

        public void setState(TristateCheckBox.State state) {
            super.setState(state);
            if (this.fileName == null) {
                return;
            }
            this.selected = state == null ? true : state != TristateCheckBox.NOT_SELECTED;
        }
    }

    private class AutoloadFunctionCheckbox
    extends JCheckBox {
        String directory;
        String fileName;
        String[] function;

        private AutoloadFunctionCheckbox(String string, String string2, String[] stringArray) {
            this.directory = string;
            this.fileName = string2;
            this.function = stringArray;
            File file = new File(this.directory, this.fileName);
            final String string3 = XML.forwardSlash(file.getAbsolutePath());
            this.setSelected(AbstractAutoloadManager.this.isFunctionSelected(string3, this.function));
            this.setText(String.valueOf(stringArray[0]) + " = " + stringArray[1]);
            this.setIconTextGap(10);
            this.setOpaque(false);
            this.setToolTipText(ToolsRes.getString("AutoloadManager.FunctionCheckbox.Tooltip"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractAutoloadManager.this.setFunctionSelected(string3, AutoloadFunctionCheckbox.this.function, AutoloadFunctionCheckbox.this.isSelected());
                }
            });
        }
    }

    protected class SearchPathDialog
    extends JDialog {
        HashSet<File> addedFiles;
        TreeSet<String> directoryPaths;
        JButton okButton;
        JButton addButton;
        JButton removeButton;
        JList directoryList;
        DefaultListModel directoryListModel;

        SearchPathDialog() {
            super((Dialog)AbstractAutoloadManager.this, true);
            this.addedFiles = new HashSet();
            this.directoryPaths = new TreeSet();
            this.createGUI();
            for (String string : AbstractAutoloadManager.this.searchPaths) {
                File file = new File(string);
                this.addedFiles.add(file);
            }
            this.refreshFileList();
        }

        private void createGUI() {
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            this.directoryListModel = new DefaultListModel();
            this.directoryList = new JList(this.directoryListModel);
            this.directoryList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    String string = (String)SearchPathDialog.this.directoryList.getSelectedValue();
                    SearchPathDialog.this.removeButton.setEnabled(string != null);
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.directoryList);
            jScrollPane.setPreferredSize(new Dimension(300, 150));
            jPanel.add((Component)jScrollPane, "Center");
            JPanel jPanel2 = new JPanel();
            this.addButton = new JButton();
            this.addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = SearchPathDialog.this.chooseSearchDirectory(SearchPathDialog.this);
                    if (file == null) {
                        return;
                    }
                    SearchPathDialog.this.addedFiles.add(file);
                    String string = XML.forwardSlash(file.getAbsolutePath());
                    AbstractAutoloadManager.this.addSearchPath(string);
                    SearchPathDialog.this.refreshFileList();
                    AbstractAutoloadManager.this.refreshAutoloadData();
                }
            });
            this.removeButton = new JButton();
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)SearchPathDialog.this.directoryList.getSelectedValue();
                    if (string != null) {
                        Iterator<File> iterator = SearchPathDialog.this.addedFiles.iterator();
                        while (iterator.hasNext()) {
                            File file = iterator.next();
                            String string2 = XML.forwardSlash(file.getAbsolutePath());
                            if (!string.equals(string2)) continue;
                            iterator.remove();
                            ((SearchPathDialog)SearchPathDialog.this).AbstractAutoloadManager.this.searchPaths.remove(string2);
                            break;
                        }
                        SearchPathDialog.this.refreshFileList();
                        AbstractAutoloadManager.this.refreshAutoloadData();
                    }
                }
            });
            this.okButton = new JButton();
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SearchPathDialog.this.setVisible(false);
                }
            });
            jPanel2.add(this.addButton);
            jPanel2.add(this.removeButton);
            jPanel2.add(this.okButton);
            jPanel.add((Component)jPanel2, "South");
            this.pack();
        }

        private File chooseSearchDirectory(Component component) {
            JFileChooser jFileChooser = new JFileChooser(AbstractAutoloadManager.this.searchPathChooserDir);
            if (OSPRuntime.isMac()) {
                jFileChooser.setFileSelectionMode(2);
            } else {
                jFileChooser.setFileSelectionMode(1);
            }
            FileFilter fileFilter = new FileFilter(){

                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    return file.isDirectory();
                }

                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
                }
            };
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(fileFilter);
            String string = ToolsRes.getString("LibraryManager.Button.Add");
            jFileChooser.setDialogTitle(string);
            FontSizer.setFonts(jFileChooser, FontSizer.getLevel());
            int n = jFileChooser.showDialog(component, string);
            if (n == 0) {
                AbstractAutoloadManager.this.searchPathChooserDir = jFileChooser.getCurrentDirectory().getAbsolutePath();
                return jFileChooser.getSelectedFile();
            }
            return null;
        }

        void refreshGUI() {
            this.setTitle(ToolsRes.getString("AutoloadManager.Button.SearchPaths"));
            this.okButton.setText(ToolsRes.getString("Button.OK"));
            this.addButton.setText(String.valueOf(ToolsRes.getString("LibraryManager.Button.Add")) + "...");
            this.removeButton.setText(ToolsRes.getString("LibraryManager.Button.Remove"));
            String string = (String)this.directoryList.getSelectedValue();
            this.removeButton.setEnabled(string != null);
        }

        void refreshFileList() {
            this.directoryListModel.clear();
            this.directoryPaths.clear();
            for (File object : this.addedFiles) {
                this.directoryPaths.add(XML.forwardSlash(object.getAbsolutePath()));
            }
            for (String string : this.directoryPaths) {
                this.directoryListModel.addElement(string);
            }
        }
    }
}

