/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.XuggleRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Diagnostics {
    public static final String TRACKER_INSTALLER_URL = "http://www.compadre.org/osp/items/detail.cfm?ID=7365";
    static final String JAVA_3D_URL = "http://java3d.java.net/binary-builds.html";
    static final String NEWLINE = System.getProperty("line.separator", "\n");
    static String requester;
    static Component dialogOwner;

    public static void aboutJava() {
        String string = System.getProperty("java.version", "unknown version");
        String string2 = System.getProperty("java.runtime.name");
        String string3 = System.getProperty("java.runtime.version");
        String string4 = System.getProperty("java.vm.name");
        String string5 = System.getProperty("java.vm.version");
        String string6 = System.getProperty("java.home");
        String string7 = OSPRuntime.getVMBitness() == 64 ? " (64-bit)" : " (32-bit)";
        String string8 = String.valueOf(ToolsRes.getString("Diagnostics.Java.About.Version")) + " " + string + string7 + NEWLINE + string2 + " (build " + string3 + ")" + NEWLINE + string4 + " (build " + string5 + ")" + NEWLINE + "JRE path " + string6 + NEWLINE + NEWLINE + "Available Processors: " + Runtime.getRuntime().availableProcessors() + NEWLINE + "Total Memory: " + Runtime.getRuntime().totalMemory() / 1000000L + " MB" + NEWLINE + "Free Memory: " + Runtime.getRuntime().freeMemory() / 1000000L + " MB" + NEWLINE;
        JOptionPane.showMessageDialog(dialogOwner, string8, ToolsRes.getString("Diagnostics.Java.About.Title"), 1);
    }

    public static void setDialogOwner(Component component) {
        dialogOwner = component;
    }

    public static void aboutQTJava(String string) {
        requester = string;
        Diagnostics.aboutQTJava();
    }

    public static void aboutQTJava() {
        Object object;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (OSPRuntime.isLinux()) {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.QTJava.Linux"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
            return;
        }
        String string = null;
        String string2 = null;
        File file = null;
        try {
            object6 = Class.forName("quicktime.util.QTBuild");
            object5 = ((Class)object6).getMethod("info", null);
            string = (String)((Method)object5).invoke(null, null);
            object6 = Class.forName("org.opensourcephysics.media.quicktime.QT");
            object5 = ((Class)object6).getMethod("start", null);
            ((Method)object5).invoke(null, null);
            object6 = Class.forName("quicktime.QTSession");
            object5 = ((Class)object6).getMethod("getMajorVersion", null);
            string2 = "" + ((Method)object5).invoke(null, null);
            object5 = ((Class)object6).getMethod("getMinorVersion", null);
            string2 = String.valueOf(string2) + "." + ((Method)object5).invoke(null, null);
            file = Diagnostics.getJarFile(object6);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        if (file == null) {
            object6 = System.getProperty("java.ext.dirs");
            object5 = System.getProperty("path.separator");
            object4 = new ArrayList();
            int n = ((String)object6).indexOf((String)object5);
            while (n > -1) {
                ((ArrayList)object4).add((String)((String)object6).substring(0, n));
                object6 = ((String)object6).substring(n + 1);
                n = ((String)object6).indexOf((String)object5);
            }
            if (!"".equals(object6)) {
                ((ArrayList)object4).add(object6);
            }
            object3 = System.getProperty("file.separator", "/");
            Iterator object22 = ((ArrayList)object4).iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                file = new File(String.valueOf(object) + (String)object3 + "QTJava.zip");
                if (file.exists()) break;
            }
            if (!file.exists()) {
                file = null;
            }
        }
        object6 = System.getenv("QTJAVA_WARNING");
        Object object2 = object5 = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getAbsolutePath();
        if (string2 != null && string != null) {
            object4 = String.valueOf(ToolsRes.getString("Diagnostics.QuickTime.About.Version")) + " " + string2;
            object4 = String.valueOf(object4) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.Version") + " ";
            object4 = String.valueOf(object4) + string.substring(string.indexOf(":") + 1, string.indexOf("]"));
            if (file != null) {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                object3 = new Date(file.lastModified());
                object4 = String.valueOf(object4) + " (" + dateFormat.format((Date)object3) + ")";
            }
            object4 = String.valueOf(object4) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
            object4 = String.valueOf(object4) + " " + (String)object5;
            JOptionPane.showMessageDialog(dialogOwner, object4, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 1);
        } else if (file != null) {
            if (OSPRuntime.getVMBitness() == 64) {
                object4 = ExtensionsManager.getManager().getPublicJREs(32);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message1"));
                arrayList.add(String.valueOf(ToolsRes.getString("Diagnostics.QTJava.About.WrongBitness.Message2")) + "\n");
                arrayList.add(" ");
                boolean bl = false;
                if (OSPRuntime.isWindows() && object4.isEmpty()) {
                    if ("Tracker".equals(requester)) {
                        arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.No32BitVM.Message1"));
                        arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.No32BitVM.Message2"));
                    } else {
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message1"));
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message2"));
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message3"));
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message4"));
                    }
                } else if ("Tracker".equals(requester)) {
                    bl = true;
                    arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message1"));
                    arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message2"));
                } else {
                    arrayList.add(ToolsRes.getString("Diagnostics.QTJava.About.SwitchVM.Message3"));
                }
                object = Box.createVerticalBox();
                ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                for (String string3 : arrayList) {
                    ((Container)object).add(new JLabel(string3));
                }
                if (dialogOwner != null && bl) {
                    ((Container)object).add(new JLabel("  "));
                    String string4 = ToolsRes.getString("Diagnostics.QTJava.About.ShowPrefs.Question");
                    ((Container)object).add(new JLabel(string4));
                    int n = JOptionPane.showConfirmDialog(dialogOwner, object, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 0, 1);
                    if (n == 0) {
                        try {
                            Class<?> clazz = Class.forName("org.opensourcephysics.cabrillo.tracker.TFrame");
                            if (dialogOwner.getClass().equals(clazz)) {
                                Method method = clazz.getMethod("showPrefsDialog", String.class);
                                method.invoke((Object)dialogOwner, "runtime");
                            }
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    JOptionPane.showMessageDialog(dialogOwner, object, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
                }
                return;
            }
            object4 = ToolsRes.getString("Diagnostics.QTJava.Error.Message");
            if (object6 == null) {
                object4 = String.valueOf(object4) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.About.JarPath");
                object4 = String.valueOf(object4) + " " + (String)object5;
            } else {
                object4 = String.valueOf(object4) + "\n\nError: " + object6;
            }
            JOptionPane.showMessageDialog(dialogOwner, object4, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        } else if ("Tracker".equals(requester) && OSPRuntime.isMac()) {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.OSX.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.OSX.Message2") + NEWLINE + NEWLINE + ToolsRes.getString("Diagnostics.DownloadTrackerInstaller.Message") + NEWLINE + TRACKER_INSTALLER_URL, ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.QTJava.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.QTJava.NotFound.Message2"), ToolsRes.getString("Diagnostics.QTJava.About.Title"), 2);
        }
    }

    public static File getJarFile(Class<?> clazz) throws Exception {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        File file = null;
        if (codeSource.getLocation() != null) {
            file = new File(codeSource.getLocation().toURI());
        } else {
            String string = clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".class").getPath();
            String string2 = string.substring(string.indexOf(":") + 1, string.indexOf("!"));
            string2 = URLDecoder.decode(string2, "UTF-8");
            file = new File(string2);
        }
        return file;
    }

    public static void aboutJava3D() {
        Object object;
        Object object2;
        if (OSPRuntime.isMac() && !OSPRuntime.hasJava3D()) {
            return;
        }
        Map map = null;
        try {
            object2 = Class.forName("javax.media.j3d.VirtualUniverse");
            object = ((Class)object2).getMethod("getProperties", null);
            map = (Map)((Method)object).invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object2 = System.getProperty("java.ext.dirs");
        object = System.getProperty("path.separator");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = ((String)object2).indexOf((String)object);
        while (n > -1) {
            arrayList.add(((String)object2).substring(0, n));
            object2 = ((String)object2).substring(n + 1);
            n = ((String)object2).indexOf((String)object);
        }
        if (!"".equals(object2)) {
            arrayList.add(object2);
        }
        File file = null;
        String string = System.getProperty("file.separator", "/");
        for (String string2 : arrayList) {
            file = new File(String.valueOf(string2) + string + "j3dcore.jar");
            if (file.exists()) continue;
            file = null;
        }
        if (map != null) {
            String string2 = (String)map.get("j3d.version");
            String string3 = (String)map.get("j3d.vendor");
            String string4 = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getPath();
            String string5 = String.valueOf(ToolsRes.getString("Diagnostics.Java3D.About.Version")) + " " + string2 + NEWLINE + (String)string3 + NEWLINE + ToolsRes.getString("Diagnostics.Java3D.About.JarPath") + " " + string4;
            JOptionPane.showMessageDialog(dialogOwner, string5, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 1);
        } else if (file != null) {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.Java3D.Error.Message"), ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.Java3D.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.Download.Message") + NEWLINE + JAVA_3D_URL, ToolsRes.getString("Diagnostics.Java3D.About.Title"), 2);
        }
    }

    public static void aboutJOGL() {
        Object object;
        String string;
        Object object2;
        Object object3;
        String string2 = null;
        try {
            object3 = Class.forName("javax.media.opengl.glu.GLU");
            object2 = ((Class)object3).getField("versionString");
            string2 = (String)((Field)object2).get(null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object3 = System.getProperty("java.ext.dirs");
        object2 = System.getProperty("path.separator");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = ((String)object3).indexOf((String)object2);
        while (n > -1) {
            arrayList.add(((String)object3).substring(0, n));
            object3 = ((String)object3).substring(n + 1);
            n = ((String)object3).indexOf((String)object2);
        }
        if (!"".equals(object3)) {
            arrayList.add(object3);
        }
        File file = null;
        String string3 = System.getProperty("file.separator", "/");
        for (String string4 : arrayList) {
            file = new File(String.valueOf(string4) + string3 + "jogl.jar");
            if (file.exists()) continue;
            file = null;
        }
        String string4 = string = file == null ? ToolsRes.getString("Diagnostics.About.Unknown") : file.getPath();
        if (string2 != null) {
            object = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.About.Version")) + " " + string2 + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + string;
            JOptionPane.showMessageDialog(dialogOwner, object, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 1);
        } else if (file != null) {
            object = String.valueOf(ToolsRes.getString("Diagnostics.JOGL.Error.Message")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.About.JarPath") + " " + string;
            JOptionPane.showMessageDialog(dialogOwner, object, ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        } else {
            JOptionPane.showMessageDialog(dialogOwner, String.valueOf(ToolsRes.getString("Diagnostics.JOGL.NotFound.Message1")) + NEWLINE + ToolsRes.getString("Diagnostics.JOGL.NotFound.Message2"), ToolsRes.getString("Diagnostics.JOGL.About.Title"), 2);
        }
    }

    public static void aboutLaunchJar() {
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jarFile = OSPRuntime.getLaunchJar();
            try {
                if (jarFile != null) {
                    String string = String.valueOf(ToolsRes.getString("Diagnostics.Jar.About.Message.JarFile")) + " \"" + XML.getName(OSPRuntime.getLaunchJarPath()) + "\". ";
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        String string2 = jarEntry.getName().toLowerCase();
                        if (!string2.endsWith(".dsa") || !string2.startsWith("meta-inf")) continue;
                        string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.Signed");
                        JOptionPane.showMessageDialog(dialogOwner, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                        return;
                    }
                    string = String.valueOf(string) + ToolsRes.getString("Diagnostics.Jar.About.Message.NotSigned");
                    JOptionPane.showMessageDialog(dialogOwner, string, ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(dialogOwner, ToolsRes.getString("Diagnostics.Jar.About.Message.NoJarFile"), ToolsRes.getString("Diagnostics.Jar.About.Title"), 1);
        }
    }

    public static void aboutOS() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = String.valueOf(ToolsRes.getString("Diagnostics.OS.About.Name")) + " " + string + NEWLINE;
        string3 = String.valueOf(string3) + ToolsRes.getString("Diagnostics.OS.About.Version") + " " + string2 + NEWLINE;
        Enumeration<?> enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            String string4;
            String string5 = (String)enumeration.nextElement();
            if (!string5.startsWith("os.") || (string4 = System.getProperty(string5)).equals(string) || string4.equals(string2)) continue;
            string3 = String.valueOf(string3) + string5 + ":  " + string4 + NEWLINE;
        }
        JOptionPane.showMessageDialog(dialogOwner, string3, ToolsRes.getString("Diagnostics.OS.About.Title"), 1);
    }

    public static void main(String[] stringArray) {
        Diagnostics.aboutJava();
    }
}

