/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ThreadViewerTableModel;

public class DiagnosticsForThreads
extends JPanel {
    private ThreadViewerTableModel tableModel = new ThreadViewerTableModel();

    public DiagnosticsForThreads() {
        JTable jTable = new JTable(this.tableModel);
        jTable.setAutoResizeMode(3);
        FontSizer.setFonts(jTable, FontSizer.getLevel());
        Font font = jTable.getFont();
        jTable.setRowHeight(font.getSize() + 4);
        jTable.getTableHeader().setFont(font);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        int n2 = 0;
        while (n2 < n - 1) {
            TableColumn tableColumn = tableColumnModel.getColumn(n2);
            tableColumn.sizeWidthToFit();
            tableColumn.setPreferredWidth(tableColumn.getWidth() + 5);
            tableColumn.setMaxWidth(tableColumn.getWidth() + 5);
            ++n2;
        }
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
    }

    public void dispose() {
        this.tableModel.stopRequest();
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public static void aboutThreads() {
        JDialog jDialog = new JDialog();
        DiagnosticsForThreads diagnosticsForThreads = new DiagnosticsForThreads();
        jDialog.setContentPane(diagnosticsForThreads);
        int n = FontSizer.getLevel();
        int n2 = (int)(600.0 * (1.0 + (double)n * 0.2));
        int n3 = (int)(300.0 * (1.0 + (double)n * 0.2));
        jDialog.setSize(n2, n3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - jDialog.getBounds().width) / 2;
        int n5 = (dimension.height - jDialog.getBounds().height) / 2;
        jDialog.setLocation(n4, n5);
        jDialog.setTitle("Threads");
        jDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        JFrame jFrame = new JFrame();
        DiagnosticsForThreads diagnosticsForThreads = new DiagnosticsForThreads();
        jFrame.setContentPane(diagnosticsForThreads);
        jFrame.setSize(500, 300);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(1);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

