/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.XuggleRes;

public class DiagnosticsForXuggle {
    public static final String XUGGLE_INSTALLER_URL = "http://www.compadre.org/osp/items/detail.cfm?ID=11606";
    public static final String REQUEST_TRACKER = "Tracker";
    static String newline;
    static String[] xuggleJarNames;
    static int vmBitness;
    static String codeBase;
    static String xuggleHome;
    static String javaExtDirectory;
    static File[] codeBaseJars;
    static File[] xuggleHomeJars;
    static File[] javaExtensionJars;
    static String pathEnvironment;
    static String pathValue;
    static String requester;
    static Component dialogOwner;

    static {
        Serializable serializable;
        Object object;
        newline = System.getProperty("line.separator", "\n");
        xuggleJarNames = new String[]{"xuggle-xuggler.jar", "logback-core.jar", "logback-classic.jar", "slf4j-api.jar"};
        try {
            object = "org.opensourcephysics.media.xuggle.XuggleIO";
            serializable = Class.forName((String)object);
            Method method = ((Class)serializable).getMethod("registerWithVideoIO", new Class[0]);
            method.invoke(null, null);
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        vmBitness = OSPRuntime.getVMBitness();
        try {
            object = DiagnosticsForXuggle.class.getProtectionDomain().getCodeSource().getLocation();
            serializable = new File(((URL)object).toURI());
            codeBase = ((File)serializable).getParent();
        }
        catch (Exception exception) {}
        xuggleHome = System.getenv("XUGGLE_HOME");
        xuggleHomeJars = new File[xuggleJarNames.length];
        javaExtensionJars = new File[xuggleJarNames.length];
        codeBaseJars = new File[xuggleJarNames.length];
    }

    private DiagnosticsForXuggle() {
    }

    public static void setDialogOwner(Component component) {
        dialogOwner = component;
    }

    public static void aboutXuggle() {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        int n;
        File[] fileArray;
        Object object4;
        Object object5;
        int n2 = DiagnosticsForXuggle.getStatusCode();
        if (OSPLog.getLevelValue() <= Level.CONFIG.intValue()) {
            OSPLog.config("XUGGLE_HOME = " + xuggleHome);
            OSPLog.config("Code base = " + codeBase);
            object5 = System.getProperty("java.home");
            object4 = "(" + vmBitness + "-bit): ";
            OSPLog.config("Java VM " + (String)object4 + (String)object5);
            fileArray = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(xuggleHome) + "/share/java/jars");
            n = fileArray[0] != null ? 1 : 0;
            int n3 = 1;
            while (n3 < fileArray.length) {
                n = n != 0 && fileArray[n3] != null ? 1 : 0;
                ++n3;
            }
            object3 = new SimpleDateFormat();
            object2 = new String[xuggleJarNames.length];
            int n4 = 0;
            while (n4 < ((Object)object2).length) {
                object2[n4] = fileArray[n4] == null ? "" : " modified " + ((Format)object3).format(fileArray[n4].lastModified());
                ++n4;
            }
            stringArray = new String[xuggleJarNames.length];
            int n5 = 0;
            while (n5 < stringArray.length) {
                stringArray[n5] = fileArray[n5] == null ? "" : " (file size " + fileArray[n5].length() / 1024L + "kB) ";
                ++n5;
            }
            object = "Xuggle home files: ";
            int n6 = 0;
            while (n6 < stringArray.length) {
                if (n6 > 0) {
                    object = String.valueOf(object) + ", ";
                }
                object = String.valueOf(object) + xuggleJarNames[n6] + " " + stringArray[n6] + fileArray[n6] + (String)object2[n6];
                ++n6;
            }
            OSPLog.config((String)object);
            fileArray = DiagnosticsForXuggle.getXuggleJarFiles(codeBase);
            n6 = 0;
            while (n6 < ((Object)object2).length) {
                object2[n6] = fileArray[n6] == null ? "" : " modified " + ((Format)object3).format(fileArray[n6].lastModified());
                ++n6;
            }
            n6 = 0;
            while (n6 < stringArray.length) {
                stringArray[n6] = fileArray[n6] == null ? "" : " (file size " + fileArray[n6].length() / 1024L + "kB) ";
                ++n6;
            }
            object = "Code base files: ";
            n6 = 0;
            while (n6 < stringArray.length) {
                if (n6 > 0) {
                    object = String.valueOf(object) + ", ";
                }
                object = String.valueOf(object) + xuggleJarNames[n6] + " " + stringArray[n6] + fileArray[n6] + (String)object2[n6];
                ++n6;
            }
            OSPLog.config((String)object);
            fileArray = DiagnosticsForXuggle.getJavaExtensionJars();
            n6 = 0;
            while (n6 < ((Object)object2).length) {
                object2[n6] = fileArray[n6] == null ? "" : " modified " + ((Format)object3).format(fileArray[n6].lastModified());
                ++n6;
            }
            n6 = 0;
            while (n6 < stringArray.length) {
                stringArray[n6] = fileArray[n6] == null ? "" : " (file size " + fileArray[n6].length() / 1024L + "kB) ";
                ++n6;
            }
            object = "Java extension files: ";
            n6 = 0;
            while (n6 < stringArray.length) {
                if (n6 > 0) {
                    object = String.valueOf(object) + ", ";
                }
                object = String.valueOf(object) + xuggleJarNames[n6] + " " + stringArray[n6] + fileArray[n6] + (String)object2[n6];
                ++n6;
            }
            OSPLog.config((String)object);
            OSPLog.config(String.valueOf(pathEnvironment) + " = " + pathValue);
        }
        if (n2 == 0) {
            object5 = newline;
            object4 = " " + XuggleRes.getString("Xuggle.Dialog.Unknown");
            fileArray = "com.xuggle.xuggler.IContainer";
            try {
                Class<?> clazz = Class.forName((String)fileArray);
                object3 = clazz.getProtectionDomain().getCodeSource().getLocation();
                object2 = new File(((URL)object3).toURI());
                object4 = " " + ((File)object2).getAbsolutePath();
                stringArray = DateFormat.getDateInstance(3);
                object = new Date(((File)object2).lastModified());
                object5 = " (" + stringArray.format((Date)object) + ")";
            }
            catch (Exception exception) {}
            String string = DiagnosticsForXuggle.getXuggleVersion();
            object3 = String.valueOf(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Version")) + " " + string + (String)object5 + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Home") + " " + xuggleHome + newline + XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.Path") + (String)object4;
            if (VideoIO.guessXuggleVersion() == 5.4) {
                object2 = XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message1");
                if (requester.equals(REQUEST_TRACKER)) {
                    object2 = String.valueOf(object2) + "\n" + XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3");
                }
                object3 = String.valueOf(object3) + "\n\n" + (String)object2;
            }
            JOptionPane.showMessageDialog(dialogOwner, object3, XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Title"), 1);
        } else {
            object5 = DiagnosticsForXuggle.getDiagnosticMessage(n2, requester);
            object4 = Box.createVerticalBox();
            ((JComponent)object4).setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            object2 = object5;
            int n7 = ((String[])object5).length;
            n = 0;
            while (n < n7) {
                fileArray = object2[n];
                ((Container)object4).add(new JLabel((String)fileArray));
                ++n;
            }
            boolean bl = false;
            if (n2 == 7 && REQUEST_TRACKER.equals(requester) && dialogOwner != null) {
                if (OSPRuntime.isWindows()) {
                    TreeSet<String> treeSet = ExtensionsManager.getManager().getPublicJREs(32);
                    bl = !treeSet.isEmpty();
                } else if (OSPRuntime.isMac()) {
                    bl = true;
                }
            }
            if (bl) {
                ((Container)object4).add(new JLabel("  "));
                String string = XuggleRes.getString("Xuggle.Dialog.AboutXuggle.ShowPrefs.Question");
                ((Container)object4).add(new JLabel(string));
                n7 = JOptionPane.showConfirmDialog(dialogOwner, object4, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 0, 1);
                if (n7 == 0) {
                    try {
                        object2 = Class.forName("org.opensourcephysics.cabrillo.tracker.TFrame");
                        if (dialogOwner.getClass().equals(object2)) {
                            stringArray = ((Class)object2).getMethod("showPrefsDialog", String.class);
                            stringArray.invoke((Object)dialogOwner, "runtime");
                        }
                    }
                    catch (Exception exception) {}
                }
            } else {
                JOptionPane.showMessageDialog(dialogOwner, object4, XuggleRes.getString("Xuggle.Dialog.BadXuggle.Title"), 2);
            }
        }
    }

    public static void aboutXuggle(String string) {
        requester = string;
        DiagnosticsForXuggle.aboutXuggle();
    }

    public static File[] getXuggleJarFiles(String string) {
        File[] fileArray = new File[xuggleJarNames.length];
        int n = 0;
        while (n < fileArray.length) {
            String string2 = xuggleJarNames[n];
            File file = new File(string, string2);
            fileArray[n] = file.exists() ? file : null;
            ++n;
        }
        return fileArray;
    }

    public static String[] getXuggleJarNames() {
        String[] stringArray = new String[xuggleJarNames.length];
        System.arraycopy(xuggleJarNames, 0, stringArray, 0, xuggleJarNames.length);
        return stringArray;
    }

    public static File[] getJavaExtensionJars() {
        String string;
        File[] fileArray = new File[xuggleJarNames.length];
        String string2 = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        int n = string2.indexOf(string = System.getProperty("path.separator"));
        if (n == -1) {
            javaExtDirectory = string2;
            fileArray = DiagnosticsForXuggle.getXuggleJarFiles(string2);
            if (fileArray[0] != null) {
                return fileArray;
            }
        } else {
            String string3 = string2;
            javaExtDirectory = null;
            while (fileArray[0] == null && n > -1) {
                string3 = string2.substring(0, n);
                if (javaExtDirectory == null) {
                    javaExtDirectory = string3;
                }
                string2 = string2.substring(n + 1);
                fileArray = DiagnosticsForXuggle.getXuggleJarFiles(string3);
                if (fileArray[0] != null) {
                    javaExtDirectory = string3;
                    return fileArray;
                }
                n = string2.indexOf(string);
            }
        }
        return fileArray;
    }

    public static int getStatusCode() {
        boolean bl;
        codeBaseJars = DiagnosticsForXuggle.getXuggleJarFiles(codeBase);
        javaExtensionJars = DiagnosticsForXuggle.getJavaExtensionJars();
        pathEnvironment = OSPRuntime.isWindows() ? "Path" : (OSPRuntime.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH");
        pathValue = System.getenv(pathEnvironment);
        if (VideoIO.getVideoType("Xuggle", null) != null) {
            return 0;
        }
        boolean bl2 = javaExtensionJars[0] != null;
        int n = 1;
        while (n < javaExtensionJars.length) {
            bl2 = bl2 && javaExtensionJars[n] != null;
            ++n;
        }
        n = codeBaseJars[0] != null ? 1 : 0;
        int n2 = 1;
        while (n2 < codeBaseJars.length) {
            n = n != 0 && codeBaseJars[n2] != null ? 1 : 0;
            ++n2;
        }
        if (xuggleHome == null) {
            return bl2 ? 2 : (n != 0 ? 2 : 1);
        }
        xuggleHomeJars = DiagnosticsForXuggle.getXuggleJarFiles(String.valueOf(xuggleHome) + "/share/java/jars");
        n2 = xuggleHomeJars[0] != null ? 1 : 0;
        int n3 = 1;
        while (n3 < xuggleHomeJars.length) {
            n2 = n2 != 0 && xuggleHomeJars[n3] != null ? 1 : 0;
            ++n3;
        }
        if (n2 == 0) {
            return 3;
        }
        if (!bl2 && n == 0) {
            return 5;
        }
        File file = bl2 ? javaExtensionJars[0] : codeBaseJars[0];
        long l = xuggleHomeJars[0].length();
        boolean bl3 = bl = l != file.length();
        if (bl) {
            return 6;
        }
        if (l < 1000000L) {
            String string = OSPRuntime.isWindows() ? "/bin" : "/lib";
            String string2 = XML.forwardSlash(String.valueOf(xuggleHome) + string);
            if (XML.forwardSlash(pathValue).indexOf(string2) == -1) {
                return 4;
            }
            if (vmBitness == 64 && OSPRuntime.isWindows()) {
                return 7;
            }
        }
        if (vmBitness == 32 && OSPRuntime.isMac()) {
            return 7;
        }
        return -1;
    }

    public static String[] getDiagnosticMessage(int n, String string) {
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        switch (n) {
            case 1: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggle.Message1"));
                arrayList.add(" ");
                if (REQUEST_TRACKER.equals(string)) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    arrayList.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 2: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message1"));
                if (REQUEST_TRACKER.equals(string)) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    arrayList.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 3: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message1"));
                if (REQUEST_TRACKER.equals(string)) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    arrayList.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.IncompleteXuggle.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_INSTALLER_URL);
                break;
            }
            case 4: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message1"));
                arrayList.add("\"" + pathEnvironment + "\" " + XuggleRes.getString("Xuggle.Dialog.MissingEnvironmentVariable.Message2"));
                break;
            }
            case 5: {
                String string2 = "";
                int n2 = 0;
                while (n2 < xuggleJarNames.length) {
                    if (javaExtensionJars[n2] == null) {
                        if (string2.length() > 1) {
                            string2 = String.valueOf(string2) + ", ";
                        }
                        string2 = String.valueOf(string2) + xuggleJarNames[n2];
                    }
                    ++n2;
                }
                String string3 = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Missing.Message"));
                arrayList.add(" ");
                arrayList.add(string2);
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                arrayList.add(" ");
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + string3);
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 6: {
                String string4 = "";
                int n3 = 0;
                while (n3 < xuggleJarNames.length) {
                    if (javaExtensionJars[n3] == null) {
                        if (string4.length() > 1) {
                            string4 = String.valueOf(string4) + ", ";
                        }
                        string4 = String.valueOf(string4) + xuggleJarNames[n3];
                    }
                    ++n3;
                }
                String string5 = String.valueOf(XML.forwardSlash(xuggleHome)) + "/share/java/jars";
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.NotWorking.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.Mismatched.Message"));
                arrayList.add(" ");
                arrayList.add(string4);
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NeedJars.CopyToCodeBase.Message2"));
                arrayList.add(" ");
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.SourceDirectory.Message")) + " " + string5);
                arrayList.add(String.valueOf(XuggleRes.getString("Xuggle.Dialog.TargetDirectory.Message")) + " " + codeBase);
                break;
            }
            case 7: {
                if (OSPRuntime.isMac()) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message1"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message2"));
                    if (!REQUEST_TRACKER.equals(string)) break;
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message3"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMMac.Message4"));
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.WrongVMWindows.Message2"));
                arrayList.add(" ");
                TreeSet<String> treeSet = ExtensionsManager.getManager().getPublicJREs(32);
                if (treeSet.isEmpty()) {
                    if (REQUEST_TRACKER.equals(string)) {
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVMTracker.Message1"));
                        arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVMTracker.Message2"));
                        break;
                    }
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message1"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message2"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message3"));
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoVM.Message4"));
                    break;
                }
                if (!REQUEST_TRACKER.equals(string)) break;
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message1"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.SetVM.Message2"));
                break;
            }
            default: {
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.BadXuggle.Message"));
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.UnknownProblem.Message"));
                if (REQUEST_TRACKER.equals(string)) {
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.ReplaceXuggle.Message3"));
                    arrayList.add(" ");
                    arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.TrackerInstallerPath.Message"));
                    arrayList.add("http://www.compadre.org/osp/items/detail.cfm?ID=7365");
                    break;
                }
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.NoXuggleHome.Message2"));
                arrayList.add(" ");
                arrayList.add(XuggleRes.getString("Xuggle.Dialog.AboutXuggle.Message.InstallerPath"));
                arrayList.add(XUGGLE_INSTALLER_URL);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getXuggleVersion() {
        String string = XuggleRes.getString("Xuggle.Dialog.Unknown");
        int n = DiagnosticsForXuggle.getStatusCode();
        if (n == 0) {
            try {
                String string2 = "com.xuggle.xuggler.Version";
                Class<?> clazz = Class.forName(string2);
                Method method = clazz.getMethod("getVersionString", new Class[0]);
                string = (String)method.invoke(null, null);
            }
            catch (Exception exception) {
            }
            catch (Error error) {}
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(DiagnosticsForXuggle.getXuggleVersion());
        DiagnosticsForXuggle.aboutXuggle();
    }
}

