/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.LibraryResource;

public class LibraryCollection
extends LibraryResource {
    private ArrayList<LibraryResource> resources = new ArrayList();

    public LibraryCollection(String string) {
        super(string);
    }

    public String getType() {
        return "Collection";
    }

    public boolean setType(String string) {
        return false;
    }

    public boolean setTarget(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (string.equals(this.target)) {
            return false;
        }
        this.target = string;
        return true;
    }

    public void addResource(LibraryResource libraryResource) {
        if (libraryResource == null) {
            return;
        }
        if (!this.resources.contains(libraryResource)) {
            this.resources.add(libraryResource);
            libraryResource.parent = this;
        }
    }

    public void insertResource(LibraryResource libraryResource, int n) {
        if (!this.resources.contains(libraryResource)) {
            this.resources.add(n, libraryResource);
        }
    }

    public void removeResource(LibraryResource libraryResource) {
        this.resources.remove(libraryResource);
    }

    public LibraryResource[] getResources() {
        return this.resources.toArray(new LibraryResource[this.resources.size()]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            XML.getLoader(LibraryResource.class).saveObject(xMLControl, object);
            LibraryCollection libraryCollection = (LibraryCollection)object;
            if (!libraryCollection.resources.isEmpty()) {
                xMLControl.setValue("resources", libraryCollection.getResources());
            }
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            return new LibraryCollection(string);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            XML.getLoader(LibraryResource.class).loadObject(xMLControl, object);
            LibraryCollection libraryCollection = (LibraryCollection)object;
            libraryCollection.resources.clear();
            LibraryResource[] libraryResourceArray = (LibraryResource[])xMLControl.getObject("resources");
            if (libraryResourceArray != null) {
                LibraryResource[] libraryResourceArray2 = libraryResourceArray;
                int n = libraryResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryResource libraryResource = libraryResourceArray2[n2];
                    libraryCollection.addResource(libraryResource);
                    ++n2;
                }
            }
            return libraryCollection;
        }
    }
}

