/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Library;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

public class LibraryManager
extends JDialog {
    LibraryBrowser browser;
    Library library;
    JTabbedPane tabbedPane;
    JPanel collectionsPanel;
    JPanel importsPanel;
    JPanel searchPanel;
    JPanel cachePanel;
    JPanel recentPanel;
    JList collectionList;
    JList guestList;
    JTextField nameField;
    JTextField pathField;
    ActionListener nameAction;
    ActionListener pathAction;
    JButton okButton;
    JButton setCacheButton;
    JButton moveUpButton;
    JButton moveDownButton;
    JButton addButton;
    JButton removeButton;
    JButton allButton;
    JButton noneButton;
    JButton clearCacheButton;
    JToolBar libraryButtonbar;
    Box nameBox;
    Box pathBox;
    Box libraryEditBox;
    Box searchBox;
    Box cacheBox;
    JLabel nameLabel;
    JLabel pathLabel;
    Font sharedFont;
    TitledBorder collectionsTitleBorder;
    TitledBorder importsTitleBorder;
    TitledBorder searchTitleBorder;
    TitledBorder cacheTitleBorder;
    ArrayList<SearchCheckBox> checkboxes = new ArrayList();
    Dimension defaultSize = new Dimension(500, 300);
    Border listButtonBorder;

    protected LibraryManager(LibraryBrowser libraryBrowser, JFrame jFrame) {
        super((Frame)jFrame, true);
        this.browser = libraryBrowser;
        this.library = libraryBrowser.library;
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dimension = new Dimension(this.defaultSize);
        double d = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d);
        this.setSize(dimension);
    }

    protected LibraryManager(LibraryBrowser libraryBrowser, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.browser = libraryBrowser;
        this.library = libraryBrowser.library;
        this.setDefaultCloseOperation(1);
        this.createGUI();
        Dimension dimension = new Dimension(this.defaultSize);
        double d = 1.0 + (double)FontSizer.getLevel() * 0.25;
        dimension.width = (int)((double)dimension.width * d);
        dimension.height = (int)((double)dimension.height * d);
        this.setSize(dimension);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.refreshSearchTab();
            this.refreshCacheTab();
        } else {
            this.library.noSearchSet.clear();
            for (SearchCheckBox searchCheckBox : this.checkboxes) {
                if (searchCheckBox.isSelected()) continue;
                this.library.noSearchSet.add(searchCheckBox.urlPath);
            }
        }
        super.setVisible(bl);
    }

    protected void createGUI() {
        JButton jButton = new JButton("by");
        jButton.setBorder(LibraryBrowser.buttonBorder);
        int n = jButton.getPreferredSize().height;
        this.sharedFont = jButton.getFont();
        AbstractListModel abstractListModel = new AbstractListModel(){

            public int getSize() {
                return LibraryManager.this.library.pathList.size();
            }

            public Object getElementAt(int n) {
                String string = LibraryManager.this.library.pathList.get(n);
                return LibraryManager.this.library.pathToNameMap.get(string);
            }
        };
        this.collectionList = new JList(abstractListModel);
        this.collectionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LibraryManager.this.refreshGUI();
            }
        });
        this.collectionList.setFixedCellHeight(n);
        this.collectionList.setFont(this.sharedFont);
        this.collectionList.setSelectionMode(0);
        AbstractListModel abstractListModel2 = new AbstractListModel(){

            public int getSize() {
                return LibraryManager.this.library.importedPathList.size();
            }

            public Object getElementAt(int n) {
                String string = LibraryManager.this.library.importedPathList.get(n);
                return LibraryManager.this.library.importedPathToLibraryMap.get(string).getName();
            }
        };
        this.guestList = new JList(abstractListModel2);
        this.guestList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LibraryManager.this.refreshGUI();
            }
        });
        this.guestList.setFont(this.sharedFont);
        this.guestList.setFixedCellHeight(n);
        this.guestList.setSelectionMode(0);
        this.nameAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LibraryManager.this.pathField.getText();
                String string2 = LibraryManager.this.library.pathToNameMap.get(string);
                String string3 = LibraryManager.this.nameField.getText().trim();
                if (string3 == null || string3.equals("") || string3.equals(string2)) {
                    return;
                }
                LibraryManager.this.library.renameCollection(string, string3);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.collectionList.repaint();
                LibraryManager.this.refreshGUI();
            }
        };
        this.nameField = new LibraryTreePanel.EntryField();
        this.nameField.addActionListener(this.nameAction);
        this.nameField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LibraryManager.this.nameField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                LibraryManager.this.nameAction.actionPerformed(null);
            }
        });
        this.nameField.setBackground(Color.white);
        this.nameLabel = new JLabel();
        this.nameLabel.setFont(this.sharedFont);
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.nameLabel.setHorizontalAlignment(11);
        this.pathField = new LibraryTreePanel.EntryField();
        this.pathField.setEditable(false);
        this.pathField.setBackground(Color.white);
        this.pathLabel = new JLabel();
        this.pathLabel.setFont(this.sharedFont);
        this.pathLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.pathLabel.setHorizontalAlignment(11);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryManager.this.setVisible(false);
            }
        });
        this.moveUpButton = new JButton();
        this.moveUpButton.setOpaque(false);
        this.moveUpButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList jList = bl ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> arrayList = bl ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int n = jList.getSelectedIndex();
                String string = arrayList.get(n);
                arrayList.remove(string);
                arrayList.add(n - 1, string);
                jList.setSelectedIndex(n - 1);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.moveDownButton = new JButton();
        this.moveDownButton.setOpaque(false);
        this.moveDownButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList jList = bl ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> arrayList = bl ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int n = jList.getSelectedIndex();
                String string = arrayList.get(n);
                arrayList.remove(string);
                arrayList.add(n + 1, string);
                jList.setSelectedIndex(n + 1);
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.addButton = new JButton();
        this.addButton.setOpaque(false);
        this.addButton.setBorder(LibraryBrowser.buttonBorder);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                boolean bl;
                String string;
                boolean bl2 = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                String string2 = bl2 ? ToolsRes.getString("LibraryBrowser.Dialog.AddLibrary.Message") : ToolsRes.getString("LibraryBrowser.Dialog.AddCollection.Message");
                Object object2 = JOptionPane.showInputDialog(LibraryManager.this.browser, string2, string = bl2 ? ToolsRes.getString("LibraryBrowser.Dialog.AddLibrary.Title") : ToolsRes.getString("LibraryBrowser.Dialog.AddCollection.Title"), 3, null, null, null);
                if (object2 == null || object2.equals("")) {
                    return;
                }
                String string3 = object2.toString();
                string3 = XML.forwardSlash(string3);
                string3 = ResourceLoader.getNonURIPath(string3);
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.collectionsPanel) {
                    bl = false;
                    if (!string3.startsWith("http") && new File(string3).isDirectory()) {
                        bl = true;
                    } else {
                        object = new XMLControlElement(string3);
                        if (!object.failedToRead() && object.getObjectClass() == LibraryCollection.class) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        LibraryManager.this.browser.addToCollections(string3);
                        object = LibraryManager.this.collectionList.getModel();
                        LibraryManager.this.collectionList.setModel(object);
                        LibraryManager.this.refreshGUI();
                        LibraryManager.this.collectionList.repaint();
                        LibraryManager.this.collectionList.setSelectedIndex(LibraryManager.this.library.pathList.size() - 1);
                        LibraryManager.this.browser.refreshCollectionsMenu();
                        return;
                    }
                }
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel) {
                    bl = false;
                    object = new XMLControlElement(string3);
                    if (!object.failedToRead() && object.getObjectClass() == Library.class) {
                        bl = true;
                    }
                    if (bl) {
                        Library library = new Library();
                        library.browser = LibraryManager.this.browser;
                        object.loadObject(library);
                        if (LibraryManager.this.library.importLibrary(string3, library)) {
                            ListModel listModel = LibraryManager.this.guestList.getModel();
                            LibraryManager.this.guestList.setModel(listModel);
                            LibraryManager.this.refreshGUI();
                            LibraryManager.this.guestList.repaint();
                            LibraryManager.this.guestList.setSelectedIndex(LibraryManager.this.library.importedPathList.size() - 1);
                            LibraryManager.this.browser.refreshCollectionsMenu();
                        }
                        return;
                    }
                }
                String string4 = ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Message");
                JOptionPane.showMessageDialog(LibraryManager.this, String.valueOf(string4) + ":\n" + string3, ToolsRes.getString("LibraryBrowser.Dialog.CollectionNotFound.Title"), 2);
            }
        });
        this.removeButton = new JButton();
        this.removeButton.setOpaque(false);
        this.removeButton.setBorder(LibraryBrowser.buttonBorder);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel;
                JList jList = bl ? LibraryManager.this.guestList : LibraryManager.this.collectionList;
                ArrayList<String> arrayList = bl ? LibraryManager.this.library.importedPathList : LibraryManager.this.library.pathList;
                int n = jList.getSelectedIndex();
                String string = arrayList.get(n);
                arrayList.remove(string);
                if (bl) {
                    LibraryManager.this.library.importedPathToLibraryMap.remove(string);
                } else {
                    LibraryManager.this.library.pathToNameMap.remove(string);
                }
                jList.repaint();
                if (n >= arrayList.size()) {
                    jList.setSelectedIndex(arrayList.size() - 1);
                }
                LibraryManager.this.browser.refreshCollectionsMenu();
                LibraryManager.this.refreshGUI();
                LibraryManager.this.browser.refreshGUI();
            }
        });
        this.allButton = new JButton();
        this.allButton.setOpaque(false);
        this.allButton.setBorder(LibraryBrowser.buttonBorder);
        this.allButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (SearchCheckBox searchCheckBox : LibraryManager.this.checkboxes) {
                    searchCheckBox.setSelected(true);
                }
            }
        });
        this.noneButton = new JButton();
        this.noneButton.setOpaque(false);
        this.noneButton.setBorder(LibraryBrowser.buttonBorder);
        this.noneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (SearchCheckBox searchCheckBox : LibraryManager.this.checkboxes) {
                    searchCheckBox.setSelected(false);
                }
            }
        });
        this.clearCacheButton = new JButton();
        this.clearCacheButton.setOpaque(false);
        this.clearCacheButton.setBorder(LibraryBrowser.buttonBorder);
        this.clearCacheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.getOSPCache();
                ResourceLoader.clearOSPCache(file, false);
                LibraryManager.this.refreshCacheTab();
                LibraryManager.this.tabbedPane.repaint();
            }
        });
        this.setCacheButton = new JButton();
        this.setCacheButton.setOpaque(false);
        this.setCacheButton.setBorder(LibraryBrowser.buttonBorder);
        this.setCacheButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = ResourceLoader.chooseOSPCache(LibraryManager.this.browser);
                ResourceLoader.setOSPCache(file);
                LibraryManager.this.refreshCacheTab();
            }
        });
        Border border = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        Border border2 = BorderFactory.createEtchedBorder();
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border2, border);
        this.libraryButtonbar = new JToolBar();
        this.libraryButtonbar.setFloatable(false);
        this.libraryButtonbar.setBorder(compoundBorder);
        this.libraryButtonbar.add(this.moveUpButton);
        this.libraryButtonbar.add(this.moveDownButton);
        this.libraryButtonbar.add(this.addButton);
        this.libraryButtonbar.add(this.removeButton);
        this.nameBox = Box.createHorizontalBox();
        this.nameBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 4));
        this.nameBox.add(this.nameLabel);
        this.nameBox.add(this.nameField);
        this.pathBox = Box.createHorizontalBox();
        this.pathBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 4));
        this.pathBox.add(this.pathLabel);
        this.pathBox.add(this.pathField);
        this.libraryEditBox = Box.createVerticalBox();
        this.libraryEditBox.add(this.nameBox);
        this.libraryEditBox.add(this.pathBox);
        this.collectionsPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.collectionList);
        jScrollPane.setViewportBorder(border2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.collectionsTitleBorder = BorderFactory.createTitledBorder("");
        jScrollPane.setBorder(this.collectionsTitleBorder);
        this.collectionsPanel.add((Component)jScrollPane, "Center");
        this.collectionsPanel.add((Component)this.libraryEditBox, "South");
        this.collectionsPanel.add((Component)this.libraryButtonbar, "North");
        this.importsPanel = new JPanel(new BorderLayout());
        jScrollPane = new JScrollPane(this.guestList);
        jScrollPane.setViewportBorder(border2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.importsTitleBorder = BorderFactory.createTitledBorder("");
        jScrollPane.setBorder(this.importsTitleBorder);
        this.importsPanel.add((Component)jScrollPane, "Center");
        this.searchPanel = new JPanel(new BorderLayout());
        this.searchBox = Box.createVerticalBox();
        this.searchBox.setBackground(Color.white);
        this.searchBox.setOpaque(true);
        this.refreshSearchTab();
        jScrollPane = new JScrollPane(this.searchBox);
        jScrollPane.setViewportBorder(border2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.searchTitleBorder = BorderFactory.createTitledBorder("");
        jScrollPane.setBorder(this.searchTitleBorder);
        this.searchPanel.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorder(compoundBorder);
        jToolBar.add(this.allButton);
        jToolBar.add(this.noneButton);
        this.searchPanel.add((Component)jToolBar, "North");
        this.cachePanel = new JPanel(new BorderLayout());
        this.cacheBox = Box.createVerticalBox();
        this.cacheBox.setBackground(Color.white);
        this.cacheBox.setOpaque(true);
        this.refreshCacheTab();
        jScrollPane = new JScrollPane(this.cacheBox);
        jScrollPane.setViewportBorder(border2);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(8);
        this.cacheTitleBorder = BorderFactory.createTitledBorder("");
        jScrollPane.setBorder(this.cacheTitleBorder);
        this.cachePanel.add((Component)jScrollPane, "Center");
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.setBorder(compoundBorder);
        jToolBar2.add(this.clearCacheButton);
        jToolBar2.add(this.setCacheButton);
        this.cachePanel.add((Component)jToolBar2, "North");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("", this.collectionsPanel);
        this.tabbedPane.addTab("", this.searchPanel);
        this.tabbedPane.addTab("", this.cachePanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.collectionsPanel) {
                    LibraryManager.this.collectionsPanel.add((Component)LibraryManager.this.libraryButtonbar, "North");
                    LibraryManager.this.collectionsPanel.add((Component)LibraryManager.this.libraryEditBox, "South");
                    LibraryManager.this.refreshGUI();
                } else if (LibraryManager.this.tabbedPane.getSelectedComponent() == LibraryManager.this.importsPanel) {
                    LibraryManager.this.importsPanel.add((Component)LibraryManager.this.libraryButtonbar, "North");
                    LibraryManager.this.importsPanel.add((Component)LibraryManager.this.libraryEditBox, "South");
                    LibraryManager.this.refreshGUI();
                }
            }
        });
        Border border3 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        this.listButtonBorder = BorderFactory.createCompoundBorder(border2, border3);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.add((Component)this.tabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.okButton);
        jPanel.add((Component)jPanel2, "South");
    }

    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("LibraryManager.Title"));
        this.okButton.setText(ToolsRes.getString("Tool.Button.Close"));
        this.addButton.setText(ToolsRes.getString("LibraryManager.Button.Add"));
        this.removeButton.setText(ToolsRes.getString("LibraryManager.Button.Remove"));
        this.moveUpButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Up"));
        this.moveDownButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Down"));
        this.allButton.setText(ToolsRes.getString("LibraryManager.Button.All"));
        this.noneButton.setText(ToolsRes.getString("LibraryManager.Button.None"));
        this.clearCacheButton.setText(ToolsRes.getString("LibraryManager.Button.ClearCache"));
        this.setCacheButton.setText(ToolsRes.getString("LibraryManager.Button.SetCache"));
        this.addButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.Add.Tooltip"));
        this.removeButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.Remove.Tooltip"));
        this.moveUpButton.setToolTipText(ToolsRes.getString("LibraryTreePanel.Button.Up.Tooltip"));
        this.moveDownButton.setToolTipText(ToolsRes.getString("LibraryTreePanel.Button.Down.Tooltip"));
        this.allButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.All.Tooltip"));
        this.noneButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.None.Tooltip"));
        this.clearCacheButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.ClearCache.Tooltip"));
        this.setCacheButton.setToolTipText(ToolsRes.getString("LibraryManager.Button.SetCache.Tooltip"));
        this.nameLabel.setText(String.valueOf(ToolsRes.getString("LibraryManager.Label.Name")) + ":");
        this.pathLabel.setText(String.valueOf(ToolsRes.getString("LibraryManager.Label.Path")) + ":");
        this.collectionsTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.MenuItems")) + ":");
        this.importsTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Import")) + ":");
        this.searchTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Search")) + ":");
        this.cacheTitleBorder.setTitle(String.valueOf(ToolsRes.getString("LibraryManager.Title.Cache")) + ":");
        int n = this.tabbedPane.indexOfComponent(this.collectionsPanel);
        if (n > -1) {
            this.tabbedPane.setTitleAt(n, ToolsRes.getString("LibraryManager.Tab.MyLibrary"));
            this.tabbedPane.setToolTipTextAt(n, ToolsRes.getString("LibraryManager.Tab.MyLibrary.Tooltip"));
        }
        if ((n = this.tabbedPane.indexOfComponent(this.importsPanel)) > -1) {
            this.tabbedPane.setTitleAt(n, ToolsRes.getString("LibraryManager.Tab.Import"));
            this.tabbedPane.setToolTipTextAt(n, ToolsRes.getString("LibraryManager.Tab.Import.Tooltip"));
        }
        if ((n = this.tabbedPane.indexOfComponent(this.searchPanel)) > -1) {
            this.tabbedPane.setTitleAt(n, ToolsRes.getString("LibraryManager.Tab.Search"));
            this.tabbedPane.setToolTipTextAt(n, ToolsRes.getString("LibraryManager.Tab.Search.Tooltip"));
        }
        if ((n = this.tabbedPane.indexOfComponent(this.cachePanel)) > -1) {
            this.tabbedPane.setTitleAt(n, ToolsRes.getString("LibraryManager.Tab.Cache"));
            this.tabbedPane.setToolTipTextAt(n, ToolsRes.getString("LibraryManager.Tab.Cache.Tooltip"));
        }
        this.resizeLabels();
        this.pathField.setForeground(LibraryTreePanel.defaultForeground);
        if (this.tabbedPane.getSelectedComponent() == this.collectionsPanel) {
            this.nameField.setEditable(true);
            int n2 = this.collectionList.getSelectedIndex();
            this.moveDownButton.setEnabled(n2 < this.library.pathList.size() - 1);
            this.moveUpButton.setEnabled(n2 > 0);
            if (n2 > -1 && this.library.pathList.size() > n2) {
                Resource resource;
                this.removeButton.setEnabled(true);
                String string = this.library.pathList.get(n2);
                this.pathField.setText(string);
                this.pathField.setCaretPosition(0);
                String string2 = this.library.pathToNameMap.get(string);
                this.nameField.setText(string2);
                boolean bl = string.startsWith("http:") && !LibraryBrowser.webConnected;
                Resource resource2 = resource = bl ? null : ResourceLoader.getResourceZipURLsOK(string);
                if (resource == null) {
                    this.pathField.setForeground(LibraryTreePanel.darkRed);
                }
            } else {
                this.removeButton.setEnabled(false);
                this.nameField.setEditable(false);
                this.nameField.setText(null);
                this.nameField.setBackground(Color.white);
                this.pathField.setText(null);
                this.pathField.setBackground(Color.white);
            }
        } else if (this.tabbedPane.getSelectedComponent() == this.importsPanel) {
            this.nameField.setEditable(false);
            int n3 = this.guestList.getSelectedIndex();
            this.moveDownButton.setEnabled(n3 < this.library.importedPathList.size() - 1);
            this.moveUpButton.setEnabled(n3 > 0);
            if (n3 > -1 && this.library.importedPathList.size() > n3) {
                Resource resource;
                this.removeButton.setEnabled(true);
                String string = this.library.importedPathList.get(n3);
                this.pathField.setText(string);
                this.pathField.setCaretPosition(0);
                String string3 = this.library.importedPathToLibraryMap.get(string).getName();
                this.nameField.setText(string3);
                boolean bl = string.startsWith("http:") && !LibraryBrowser.webConnected;
                Resource resource3 = resource = bl ? null : ResourceLoader.getResourceZipURLsOK(string);
                if (resource == null) {
                    this.pathField.setForeground(LibraryTreePanel.darkRed);
                }
            } else {
                this.removeButton.setEnabled(false);
                this.nameField.setText(null);
                this.nameField.setBackground(Color.white);
                this.pathField.setText(null);
                this.pathField.setBackground(Color.white);
            }
        }
        this.nameField.setBackground(Color.white);
        this.pathField.setBackground(Color.white);
    }

    protected void refreshSearchTab() {
        Iterator iterator;
        Object object3;
        this.searchBox.removeAll();
        this.checkboxes.clear();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (LibraryResource object22 : this.browser.getSearchCacheTargets()) {
            String n = object22.collectionPath;
            if (n == null) continue;
            object3 = object22.toString();
            Object object2 = new JLabel((String)object3);
            ((JComponent)object2).setToolTipText(n);
            arrayList.add(object2);
            iterator = new SearchCheckBox(n);
            this.checkboxes.add((SearchCheckBox)((Object)iterator));
            DeleteButton deleteButton = new DeleteButton(n);
            Box box = Box.createHorizontalBox();
            box.add((Component)object2);
            box.add((Component)((Object)iterator));
            box.add(deleteButton);
            box.add(Box.createHorizontalGlue());
            this.searchBox.add(box);
            FontSizer.setFonts(this.searchBox, FontSizer.getLevel());
        }
        if (arrayList.isEmpty()) {
            return;
        }
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = ((JLabel)arrayList.get(0)).getFont();
        int n = 0;
        for (Object object3 : arrayList) {
            iterator = font.getStringBounds(((JLabel)object3).getText(), fontRenderContext);
            n = Math.max(n, (int)((RectangularShape)((Object)iterator)).getWidth());
        }
        object3 = new Dimension(n + 48, 20);
        for (Object object2 : arrayList) {
            ((JComponent)object2).setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            ((JComponent)object2).setPreferredSize((Dimension)object3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void refreshCacheTab() {
        Object object;
        this.cacheBox.removeAll();
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        File file = ResourceLoader.getOSPCache();
        File[] fileArray = file == null ? new File[]{} : file.listFiles(ResourceLoader.OSP_CACHE_FILTER);
        this.clearCacheButton.setEnabled(fileArray.length > 0);
        if (fileArray.length == 0) {
            JLabel jLabel = new JLabel(ToolsRes.getString("LibraryManager.Cache.IsEmpty"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            Box box = Box.createHorizontalBox();
            box.add(jLabel);
            box.add(Box.createHorizontalGlue());
            this.cacheBox.add(box);
            return;
        }
        File[] object22 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            void var8_14;
            object = object22[n2];
            String string = ((File)object).getName().substring(4).replace('_', '.');
            long l = this.getFileSize((File)object);
            long l2 = l / 0x100000L;
            if (l > 0L) {
                if (l2 > 0L) {
                    String string2 = String.valueOf(string) + " (" + l2 + " MB)";
                } else {
                    String string3 = String.valueOf(string) + " (" + l / 1024L + " kB)";
                }
            }
            JLabel jLabel = new JLabel((String)var8_14);
            jLabel.setToolTipText(((File)object).getAbsolutePath());
            arrayList.add(jLabel);
            ClearHostButton clearHostButton = new ClearHostButton((File)object);
            Box box = Box.createHorizontalBox();
            box.add(jLabel);
            box.add(clearHostButton);
            box.add(Box.createHorizontalGlue());
            this.cacheBox.add(box);
            FontSizer.setFonts(this.cacheBox, FontSizer.getLevel());
            ++n2;
        }
        object = new FontRenderContext(null, false, false);
        Font font = ((JLabel)arrayList.get(0)).getFont();
        n = 0;
        for (JLabel jLabel : arrayList) {
            Rectangle2D rectangle2D = font.getStringBounds(jLabel.getText(), (FontRenderContext)object);
            n = Math.max(n, (int)rectangle2D.getWidth());
        }
        Dimension dimension = new Dimension(n + 48, 20);
        for (JLabel jLabel : arrayList) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            jLabel.setPreferredSize(dimension);
        }
    }

    protected void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        Font font = this.collectionList.getFont();
        font = FontSizer.getResizedFont(font, n);
        int n2 = 8 + n;
        this.collectionList.setFixedCellHeight(font.getSize() + n2);
        this.resizeLabels();
    }

    private void resizeLabels() {
        int n = 0;
        Font font = this.nameLabel.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(this.nameLabel.getText()) + " ", fontRenderContext);
        n = Math.max(n, (int)rectangle2D.getWidth() + 4);
        rectangle2D = font.getStringBounds(String.valueOf(this.pathLabel.getText()) + " ", fontRenderContext);
        n = Math.max(n, (int)rectangle2D.getWidth() + 4);
        Dimension dimension = new Dimension(n, 20);
        this.nameLabel.setPreferredSize(dimension);
        this.nameLabel.setMinimumSize(dimension);
        this.pathLabel.setPreferredSize(dimension);
        this.pathLabel.setMinimumSize(dimension);
    }

    private long getFileSize(File file) {
        File[] fileArray;
        if (file == null) {
            return 0L;
        }
        long l = 0L;
        File[] fileArray2 = fileArray = file.equals(ResourceLoader.getOSPCache()) ? file.listFiles(ResourceLoader.OSP_CACHE_FILTER) : file.listFiles();
        if (fileArray == null) {
            return 0L;
        }
        int n = 0;
        while (n < fileArray.length) {
            l = fileArray[n].isDirectory() ? (l += this.getFileSize(fileArray[n])) : (l += fileArray[n].length());
            ++n;
        }
        return l;
    }

    protected class ClearHostButton
    extends JButton {
        File hostCacheDir;

        public ClearHostButton(File file) {
            this.hostCacheDir = file;
            this.setText(ToolsRes.getString("LibraryManager.Button.Clear"));
            this.setToolTipText(ToolsRes.getString("LibraryManager.Button.Clear.Tooltip"));
            this.setOpaque(false);
            this.setBorder(LibraryManager.this.listButtonBorder);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    ClearHostButton.this.setBorderPainted(true);
                    ClearHostButton.this.setContentAreaFilled(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    ClearHostButton.this.setBorderPainted(false);
                    ClearHostButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResourceLoader.clearOSPCacheHost(ClearHostButton.this.hostCacheDir);
                    LibraryManager.this.refreshCacheTab();
                    ((ClearHostButton)ClearHostButton.this).LibraryManager.this.tabbedPane.repaint();
                }
            });
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    protected class DeleteButton
    extends JButton {
        String urlPath;

        public DeleteButton(String string) {
            this.urlPath = string;
            this.setText(ToolsRes.getString("LibraryManager.Button.Delete"));
            this.setToolTipText(ToolsRes.getString("LibraryManager.Button.Delete.Tooltip"));
            this.setOpaque(false);
            this.setBorder(LibraryManager.this.listButtonBorder);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    DeleteButton.this.setBorderPainted(true);
                    DeleteButton.this.setContentAreaFilled(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    DeleteButton.this.setBorderPainted(false);
                    DeleteButton.this.setContentAreaFilled(false);
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file = ResourceLoader.getSearchCacheFile(DeleteButton.this.urlPath);
                    file.delete();
                    LibraryManager.this.refreshSearchTab();
                }
            });
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }

    protected class SearchCheckBox
    extends JCheckBoxMenuItem {
        String urlPath;

        public SearchCheckBox(String string) {
            this.urlPath = string;
            this.setText(ToolsRes.getString("LibraryManager.Checkbox.Search"));
            this.setFont(LibraryManager.this.sharedFont);
            this.setSelected(!LibraryManager.this.library.noSearchSet.contains(string));
            this.setOpaque(false);
            int n = 20 + FontSizer.getLevel() * 5;
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, n));
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

