/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryResource
implements Comparable<LibraryResource> {
    public static final String META_AUTHOR = "Author";
    public static final String META_CONTACT = "Contact";
    public static final String META_KEYWORDS = "Keywords";
    public static final String[] META_TYPES;
    public static final String UNKNOWN_TYPE = "Unknown";
    public static final String COLLECTION_TYPE = "Collection";
    public static final String TRACKER_TYPE = "Tracker";
    public static final String EJS_TYPE = "EJS";
    public static final String VIDEO_TYPE = "Video";
    public static final String IMAGE_TYPE = "Image";
    public static final String HTML_TYPE = "HTML";
    public static final String PDF_TYPE = "PDF";
    protected static final String[] RESOURCE_TYPES;
    protected static List<String> allResourceTypes;
    protected static Icon htmlIcon;
    protected static Icon videoIcon;
    protected static Icon trackerIcon;
    protected static Icon ejsIcon;
    protected static Icon pdfIcon;
    protected static Icon unknownIcon;
    protected static Icon imageIcon;
    protected static FileFilter[] imageFilters;
    protected static DecimalFormat megabyteFormat;
    private String name = "";
    private String description = "";
    private String basePath = "";
    private String htmlPath = "";
    protected String target = "";
    private String type = "Unknown";
    protected String displayName;
    private String thumbnail;
    private Map<String, String> properties = new TreeMap<String, String>();
    private TreeSet<Metadata> metadata;
    protected LibraryCollection parent;
    protected String collectionPath;
    protected List<String> treePath;

    static {
        String string;
        META_TYPES = new String[]{META_AUTHOR, META_CONTACT, META_KEYWORDS};
        RESOURCE_TYPES = new String[]{TRACKER_TYPE, EJS_TYPE, VIDEO_TYPE, IMAGE_TYPE, HTML_TYPE, PDF_TYPE, UNKNOWN_TYPE};
        allResourceTypes = new ArrayList<String>();
        imageFilters = new ImageVideoType().getFileFilters();
        allResourceTypes.add(COLLECTION_TYPE);
        String[] stringArray = RESOURCE_TYPES;
        int n = RESOURCE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            string = stringArray[n2];
            allResourceTypes.add(string);
            ++n2;
        }
        string = "/org/opensourcephysics/resources/tools/images/html.gif";
        htmlIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/pdf.gif";
        pdfIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/video.gif";
        videoIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/portrait.gif";
        imageIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/tracker_icon_16.png";
        trackerIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/ejsicon.gif";
        ejsIcon = new ImageIcon(LibraryResource.class.getResource(string));
        string = "/org/opensourcephysics/resources/tools/images/question_mark.gif";
        unknownIcon = new ImageIcon(LibraryResource.class.getResource(string));
        try {
            megabyteFormat = (DecimalFormat)NumberFormat.getInstance();
            megabyteFormat.applyPattern("0.0");
        }
        catch (Exception exception) {}
    }

    public LibraryResource(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public boolean setName(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (!string.equals(this.name)) {
            this.name = string;
            return true;
        }
        return false;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean setBasePath(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (!string.equals(this.basePath)) {
            this.basePath = string;
            return true;
        }
        return false;
    }

    protected String getInheritedBasePath() {
        if (!"".equals(this.basePath)) {
            return this.basePath;
        }
        if (this.parent != null) {
            return this.parent.getInheritedBasePath();
        }
        return this.basePath;
    }

    public String getTarget() {
        return "".equals(this.target) ? null : this.target;
    }

    private String getAbsoluteTarget() {
        if ("".equals(this.target)) {
            return this.target;
        }
        return XML.getResolvedPath(this.target, this.getInheritedBasePath());
    }

    public boolean setTarget(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (!string.equals(this.target)) {
            this.thumbnail = null;
            this.target = string;
            if ((string = string.toUpperCase()).endsWith(".TRK") || string.endsWith(".TRZ")) {
                this.setType(TRACKER_TYPE);
            } else if (string.endsWith(".PDF")) {
                this.setType(PDF_TYPE);
            } else if (string.indexOf(EJS_TYPE) > -1) {
                this.setType(EJS_TYPE);
            } else if (string.endsWith(".ZIP")) {
                final String string3 = this.getBasePath();
                Runnable runnable = new Runnable(){

                    public void run() {
                        String string = XML.getResolvedPath(LibraryResource.this.target, string3);
                        Set<String> set = ResourceLoader.getZipContents(string);
                        for (String string2 : set) {
                            if (!string2.toUpperCase().endsWith(".TRK")) continue;
                            LibraryResource.this.setType(LibraryResource.TRACKER_TYPE);
                            break;
                        }
                    }
                };
                new Thread(runnable).start();
            } else if (string.equals("")) {
                if (this.getHTMLPath() == null) {
                    this.setType(UNKNOWN_TYPE);
                } else {
                    this.setType(HTML_TYPE);
                }
            } else {
                Object object;
                boolean bl = false;
                Object[] objectArray = imageFilters;
                int n = imageFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    object = objectArray[n2];
                    if (bl) break;
                    VideoFileFilter videoFileFilter = (VideoFileFilter)object;
                    String[] stringArray = videoFileFilter.getExtensions();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string4 = stringArray[n4];
                        if (string.endsWith("." + string4.toUpperCase())) {
                            this.setType(IMAGE_TYPE);
                            bl = true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                objectArray = VideoIO.getVideoExtensions();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    object = objectArray[n2];
                    if (bl) break;
                    if (string.endsWith("." + ((String)object).toUpperCase())) {
                        this.setType(VIDEO_TYPE);
                        bl = true;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }

    public String getHTMLPath() {
        return this.htmlPath;
    }

    public boolean setHTMLPath(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (!string.equals(this.htmlPath)) {
            this.htmlPath = string;
            if (!(this instanceof LibraryCollection) && this.getTarget() == null) {
                if (string.equals("")) {
                    this.setType(UNKNOWN_TYPE);
                } else {
                    this.setType(HTML_TYPE);
                }
            }
            return true;
        }
        return false;
    }

    private String getAbsoluteHTMLPath() {
        if ("".equals(this.htmlPath)) {
            return this.htmlPath;
        }
        return XML.getResolvedPath(this.htmlPath, this.getInheritedBasePath());
    }

    public String getDescription() {
        return this.description;
    }

    public boolean setDescription(String string) {
        String string2 = string = string == null ? "" : string.trim();
        if (!string.equals(this.description)) {
            this.description = string;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public boolean setType(String string) {
        if (this.type.equals(string)) {
            return false;
        }
        for (String string2 : allResourceTypes) {
            if (!string2.equals(string)) continue;
            this.type = string2;
            return true;
        }
        return false;
    }

    public TreeSet<Metadata> getMetadata() {
        return this.metadata;
    }

    public Metadata getMetadata(String string) {
        if (this.metadata == null) {
            return null;
        }
        for (Metadata metadata : this.metadata) {
            if (!metadata.data[0].equals(string)) continue;
            return metadata;
        }
        return null;
    }

    public void setMetadata(TreeSet<Metadata> treeSet) {
        this.metadata = treeSet;
    }

    public void addMetadata(Metadata metadata) {
        if (this.metadata == null) {
            this.metadata = new TreeSet();
        }
        String[] stringArray = META_TYPES;
        int n = META_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.toLowerCase().equals(metadata.getData()[0])) {
                metadata.getData()[0] = string;
            }
            ++n2;
        }
        this.metadata.add(metadata);
    }

    public boolean removeMetadata(Metadata metadata) {
        if (this.metadata == null) {
            this.metadata = new TreeSet();
        }
        Iterator<Metadata> iterator = this.metadata.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(metadata)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Icon getIcon() {
        if (this.type == TRACKER_TYPE) {
            return trackerIcon;
        }
        if (this.type == EJS_TYPE) {
            return ejsIcon;
        }
        if (this.type == IMAGE_TYPE) {
            return imageIcon;
        }
        if (this.type == VIDEO_TYPE) {
            return videoIcon;
        }
        if (this.type == HTML_TYPE) {
            return htmlIcon;
        }
        if (this.type == PDF_TYPE) {
            return pdfIcon;
        }
        return null;
    }

    public String getThumbnail() {
        return this.thumbnail;
    }

    public void setThumbnail(String string) {
        this.thumbnail = string;
    }

    public String getCollectionPath() {
        if (this.collectionPath != null) {
            return this.collectionPath;
        }
        if (this.parent != null) {
            return this.parent.getCollectionPath();
        }
        return null;
    }

    public String getTitle(String string) {
        String string2 = this.getName();
        if (string2.equals("") && string != null) {
            String string3 = XML.getName(string);
            String string4 = XML.getDirectoryPath(string);
            if (string4.startsWith("http:")) {
                string4 = string4.substring(5);
                while (string4.startsWith("/")) {
                    string4 = string4.substring(1);
                }
                int n = string4.indexOf("/");
                if (n > -1) {
                    string4 = string4.substring(0, n);
                }
                string2 = String.valueOf(string4) + ": " + string3;
            } else {
                string2 = XML.getName(string);
            }
        }
        this.displayName = string2;
        return string2;
    }

    public String toString() {
        if (!this.getName().equals("")) {
            return this.getName();
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.collectionPath != null && this.parent == null) {
            return this.getTitle(this.collectionPath);
        }
        if (this instanceof LibraryCollection) {
            return ToolsRes.getString("LibraryCollection.Name.Default");
        }
        return ToolsRes.getString("LibraryResource.Name.Default");
    }

    @Override
    public int compareTo(LibraryResource libraryResource) {
        if (this == libraryResource) {
            return 0;
        }
        int n = this.getName().compareTo(libraryResource.getName());
        if (n != 0) {
            return n;
        }
        String string = this.getAbsoluteTarget();
        String string2 = libraryResource.getAbsoluteTarget();
        if (string != null || string2 != null) {
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            n = string.compareTo(string2);
        }
        if (n != 0) {
            return n;
        }
        String string3 = this.getAbsoluteHTMLPath();
        String string4 = libraryResource.getAbsoluteHTMLPath();
        if (string3 != null || string4 != null) {
            if (string3 == null) {
                return 1;
            }
            if (string4 == null) {
                return -1;
            }
            n = string3.compareTo(string4);
        }
        if (n != 0) {
            return n;
        }
        n = this.getType().compareTo(libraryResource.getType());
        if (n != 0) {
            return n;
        }
        if (this instanceof LibraryCollection && libraryResource instanceof LibraryCollection) {
            LibraryResource[] libraryResourceArray;
            LibraryResource[] libraryResourceArray2 = ((LibraryCollection)this).getResources();
            if (libraryResourceArray2.length > (libraryResourceArray = ((LibraryCollection)libraryResource).getResources()).length) {
                return -1;
            }
            if (libraryResourceArray2.length < libraryResourceArray.length) {
                return 1;
            }
            int n2 = 0;
            while (n2 < libraryResourceArray2.length) {
                n = libraryResourceArray2[n2].compareTo(libraryResourceArray[n2]);
                if (n != 0) {
                    return n;
                }
                ++n2;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof LibraryResource)) {
            return false;
        }
        return this.compareTo((LibraryResource)object) == 0;
    }

    public LibraryResource getClone() {
        boolean bl = this instanceof LibraryCollection;
        LibraryResource libraryResource = bl ? new LibraryCollection(this.getName()) : new LibraryResource(this.getName());
        libraryResource.setBasePath(this.getBasePath());
        libraryResource.setTarget(this.getTarget());
        libraryResource.setHTMLPath(this.getHTMLPath());
        libraryResource.setDescription(this.getDescription());
        libraryResource.setType(this.getType());
        for (String object : this.getPropertyNames()) {
            libraryResource.setProperty(object, this.getProperty(object));
        }
        if (this.getMetadata() != null) {
            for (Metadata metadata : this.getMetadata()) {
                libraryResource.addMetadata(new Metadata(metadata.getData()[0], metadata.getData()[1]));
            }
        }
        if (bl) {
            LibraryCollection libraryCollection = (LibraryCollection)this;
            LibraryResource[] libraryResourceArray = libraryCollection.getResources();
            int n = libraryResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryResource libraryResource2 = libraryResourceArray[n2];
                ((LibraryCollection)libraryResource).addResource(libraryResource2.getClone());
                ++n2;
            }
        }
        libraryResource.collectionPath = this.getCollectionPath();
        libraryResource.treePath = this.getTreePath(null);
        return libraryResource;
    }

    protected List<String> getTreePath(List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (this.parent != null) {
            this.parent.getTreePath(list);
        }
        list.add(this.toString());
        return list;
    }

    public static String getHTMLCode(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray, Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        stringBuffer.append("\n  <html>");
        stringBuffer.append("\n    <head>");
        stringBuffer.append("\n" + LibraryResource.getStyleSheetCode());
        stringBuffer.append("\n      <meta http-equiv=\"content-type\" content=\"text/html;charset=iso-8859-1\">");
        if (map != null) {
            for (String string8 : map.keySet()) {
                String string9 = map.get(string8);
                stringBuffer.append("\n      <meta name=\"" + string8 + "\" content=\"" + string9 + "\">");
            }
        }
        if (string != null && !string.equals("")) {
            stringBuffer.append("\n      <title>" + string + "</title>");
        }
        stringBuffer.append("\n    </head>\n");
        stringBuffer.append("\n    <body>");
        stringBuffer.append(LibraryResource.getHTMLBody(string, string2, string3, string4, string5, string6, string7, stringArray));
        stringBuffer.append("\n    </body>");
        stringBuffer.append("\n  </html>");
        return stringBuffer.toString();
    }

    protected static String getHTMLBody(String string, String string2, String string3, String string4, String string5, String string6, String string7, String[] stringArray) {
        String string8;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && !string.equals("")) {
            stringBuffer.append("\n      <h2>" + string + "</h2>");
        }
        stringBuffer.append("\n      <blockquote>");
        if (string2 != null && !string2.equals("")) {
            if (allResourceTypes.contains(string2)) {
                string2 = ToolsRes.getString("LibraryResource.Type." + string2);
            }
            stringBuffer.append("\n        <b>" + string2 + "</b>");
        }
        if (string3 != null && !string3.equals("")) {
            string3 = "<p><img src=\"" + string3 + "\"";
            if (string != null && !string.equals("")) {
                string3 = String.valueOf(string3) + " alt=\"" + string + "\"";
            }
            stringBuffer.append("\n        " + string3 + "></p>");
        }
        if (string4 != null && !string4.equals("")) {
            if (!string4.startsWith("<p>")) {
                string4 = "<p>" + LibraryResource.insertLineBreaks(string4) + "</p>";
            }
            stringBuffer.append("\n        " + string4);
        }
        if (string5 != null && !string5.equals("")) {
            string8 = ToolsRes.getString("LibraryTreePanel.Label.Author");
            stringBuffer.append("\n        <p><b>" + string8 + ":  </b>" + string5 + "</p>");
        }
        if (string6 != null && !string6.equals("")) {
            string8 = ToolsRes.getString("LibraryTreePanel.Label.Contact");
            stringBuffer.append("\n        <p><b>" + string8 + ":  </b>" + string6 + "</p>");
        }
        if (stringArray != null && stringArray[1] != null) {
            string8 = stringArray[1];
            String string9 = ToolsRes.getString("LibraryResource.Description.Resource");
            int n = Integer.parseInt(stringArray[2]);
            String string10 = " (" + megabyteFormat.format((double)n / 1048576.0) + "MB)";
            stringBuffer.append("\n        <p><b>" + string9 + ":  </b>" + string8 + string10 + "</p>");
        }
        if (string7 != null && !string7.equals("")) {
            try {
                new URL(string7);
                string8 = ToolsRes.getString("LibraryComPADRE.Description.InfoField");
                stringBuffer.append("\n        <p><b>" + string8 + "  </b><a href=\"" + string7 + "\">" + string7 + "</a></p>");
            }
            catch (MalformedURLException malformedURLException) {}
        }
        stringBuffer.append("\n      </blockquote>");
        return stringBuffer.toString();
    }

    protected static String getBodyStyle() {
        return "body {\n  font-family: Verdana, Arial, Helvetica, sans-serif;\n  font-size: 12pt;\n  color: #405050;\n  background-color: #FFFFFF;\n}\n";
    }

    protected static String getH1Style() {
        return "h1 {\n  font-size: 24pt;\n  text-align: center;\n}\n";
    }

    protected static String getH2Style() {
        return "h2 {\n  font-size: 16pt;\n}\n";
    }

    protected static String getStyleSheetCode() {
        return "<style TYPE=\"text/css\">\n<!--\n" + LibraryResource.getBodyStyle() + LibraryResource.getH1Style() + LibraryResource.getH2Style() + "-->\n" + "</style>\n";
    }

    protected static String insertLineBreaks(String string) {
        String[] stringArray = string.split("\n");
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 <= n) {
            String string2 = stringArray[n2];
            stringBuffer.append(string2);
            if (n2 < n) {
                stringBuffer.append("<br>");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            LibraryResource libraryResource = (LibraryResource)object;
            xMLControl.setValue("name", libraryResource.name);
            if (!"".equals(libraryResource.description)) {
                xMLControl.setValue("description", libraryResource.description);
            }
            if (!"".equals(libraryResource.htmlPath)) {
                xMLControl.setValue("html_path", libraryResource.htmlPath);
            }
            if (!"".equals(libraryResource.basePath)) {
                xMLControl.setValue("base_path", libraryResource.basePath);
            }
            if (!"".equals(libraryResource.target)) {
                xMLControl.setValue("target", libraryResource.getTarget());
            }
            if (libraryResource.thumbnail != null) {
                xMLControl.setValue("thumbnail", libraryResource.getThumbnail());
            }
            if (!LibraryResource.UNKNOWN_TYPE.equals(libraryResource.type)) {
                xMLControl.setValue("type", libraryResource.type);
            }
            if (libraryResource.metadata != null && libraryResource.metadata.size() > 0) {
                int n = libraryResource.metadata.size();
                String[][] object2 = new String[n][];
                int n2 = 0;
                for (Metadata metadata : libraryResource.metadata) {
                    object2[n2] = metadata.data;
                    ++n2;
                }
                xMLControl.setValue("metadata", object2);
            }
            if (!libraryResource.getPropertyNames().isEmpty()) {
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                for (String string : libraryResource.getPropertyNames()) {
                    arrayList.add(new String[]{string, libraryResource.getProperty(string)});
                }
                xMLControl.setValue("properties", arrayList.toArray((T[])new String[arrayList.size()][2]));
            }
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            return new LibraryResource(string);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            String[][] stringArray;
            String[] stringArray2;
            LibraryResource libraryResource = (LibraryResource)object;
            libraryResource.setDescription(xMLControl.getString("description"));
            libraryResource.setBasePath(xMLControl.getString("base_path"));
            String string = xMLControl.getString("target");
            if (string != null) {
                libraryResource.target = string;
            }
            libraryResource.setHTMLPath(xMLControl.getString("html_path"));
            libraryResource.setType(xMLControl.getString("type"));
            libraryResource.setThumbnail(xMLControl.getString("thumbnail"));
            String[][] stringArray3 = (String[][])xMLControl.getObject("metadata");
            if (stringArray3 != null) {
                if (libraryResource.getMetadata() != null) {
                    libraryResource.getMetadata().clear();
                }
                int n = 0;
                while (n < stringArray3.length) {
                    stringArray2 = stringArray3[n];
                    libraryResource.addMetadata(new Metadata(stringArray2[0], stringArray2[1]));
                    ++n;
                }
            }
            if ((stringArray = (String[][])xMLControl.getObject("properties")) != null) {
                String[][] stringArray4 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    stringArray2 = stringArray4[n2];
                    libraryResource.setProperty(stringArray2[0], stringArray2[1]);
                    ++n2;
                }
            }
            return libraryResource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Metadata
    implements Comparable<Metadata> {
        private String[] data;

        public Metadata() {
            this.data = new String[]{"", ""};
        }

        public Metadata(String string, String string2) {
            string = string == null ? "" : string;
            string2 = string2 == null ? "" : string2;
            this.data = new String[]{string, string2};
        }

        public String[] getData() {
            return this.data;
        }

        public void clearData() {
            this.data[0] = "";
            this.data[1] = "";
        }

        @Override
        public int compareTo(Metadata metadata) {
            int n = this.data[0].compareTo(metadata.data[0]);
            return n == 0 ? this.data[1].compareTo(metadata.data[1]) : n;
        }

        public String toString() {
            return String.valueOf(this.data[0]) + ": " + this.data[1];
        }
    }
}

