/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.gif.GifDecoder;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreePanel;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryTreeNode
extends DefaultMutableTreeNode
implements Comparable<LibraryTreeNode> {
    protected static HashMap<String, URL> htmlURLs = new HashMap();
    protected static HashMap<String, URL> targetURLs = new HashMap();
    protected static Dimension defaultThumbnailDimension = new Dimension(320, 240);
    protected LibraryResource record;
    protected boolean editable = true;
    protected LibraryTreePanel treePanel;
    protected ArrayList<LibraryResource> resources = new ArrayList();
    protected String tooltip;
    protected LibraryResource.Metadata selectedMetadata;
    protected String metadataSource;

    protected LibraryTreeNode(LibraryResource libraryResource, LibraryTreePanel libraryTreePanel) {
        this.record = libraryResource;
        this.treePanel = libraryTreePanel;
        if (libraryTreePanel.tree != null) {
            this.createChildNodes();
        }
        this.setUserObject(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)object;
        String string = this.getAbsoluteTarget();
        String string2 = libraryTreeNode.getAbsoluteTarget();
        String string3 = this.getHTMLPath();
        String string4 = libraryTreeNode.getHTMLPath();
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2) && string3 == null && string4 == null || string3 != null && string4 != null && string3.equals(string4) && libraryTreeNode.getName().equals(this.getName());
    }

    @Override
    public int compareTo(LibraryTreeNode libraryTreeNode) {
        if (this == libraryTreeNode || this.equals(libraryTreeNode)) {
            return 0;
        }
        int n = this.getName().compareTo(libraryTreeNode.getName());
        if (n != 0) {
            return n;
        }
        String string = this.getAbsoluteTarget();
        String string2 = libraryTreeNode.getAbsoluteTarget();
        if (string != null || string2 != null) {
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            n = string.compareTo(string2);
        }
        if (n != 0) {
            return n;
        }
        String string3 = this.getHTMLPath();
        String string4 = libraryTreeNode.getHTMLPath();
        if (string3 != null || string4 != null) {
            if (string3 == null) {
                return 1;
            }
            if (string4 == null) {
                return -1;
            }
            return string3.compareTo(string4);
        }
        return 0;
    }

    protected boolean createChildNodes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getChildCount()) {
            arrayList.add(this.getChildAt(n).toString());
            n += 1;
        }
        n = 0;
        if (this.record instanceof LibraryCollection) {
            LibraryCollection libraryCollection = (LibraryCollection)this.record;
            LibraryResource[] libraryResourceArray = libraryCollection.getResources();
            int n2 = libraryResourceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                LibraryTreeNode libraryTreeNode;
                LibraryResource libraryResource = libraryResourceArray[n3];
                if (libraryResource != null && !arrayList.contains(libraryResource.getName()) && this.treePanel.insertChildAt(libraryTreeNode = new LibraryTreeNode(libraryResource, this.treePanel), this, this.getChildCount())) {
                    n = 1;
                }
                ++n3;
            }
        }
        if (n) {
            this.treePanel.setChanged();
        }
        return n != 0;
    }

    protected String getName() {
        return this.record.getName();
    }

    protected String getBasePath() {
        String string = this.record.getBasePath();
        if (!string.equals("")) {
            return string;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.getParent();
        if (libraryTreeNode != null) {
            return libraryTreeNode.getBasePath();
        }
        if (this.treePanel != null) {
            return XML.getDirectoryPath(this.treePanel.pathToRoot);
        }
        return "";
    }

    protected String getHTMLPath() {
        String string = this.record.getHTMLPath();
        if (string != null && !string.trim().equals("")) {
            string = XML.getResolvedPath(string, this.getBasePath());
            return string;
        }
        return null;
    }

    protected URL getHTMLURL() {
        String string = this.getHTMLPath();
        if (string == null) {
            return null;
        }
        URL uRL = null;
        File file = ResourceLoader.getOSPCacheFile(string);
        boolean bl = file.exists();
        if (htmlURLs.keySet().contains(string)) {
            uRL = htmlURLs.get(string);
        } else {
            Resource resource;
            String string2 = string;
            if (bl) {
                string2 = file.toURI().toString();
            }
            if ((resource = ResourceLoader.getResourceZipURLsOK(string2)) != null) {
                uRL = resource.getURL();
            } else {
                resource = ResourceLoader.getResourceZipURLsOK(string2 = ResourceLoader.getURIPath(string2));
                if (resource != null) {
                    uRL = resource.getURL();
                }
            }
        }
        htmlURLs.put(string, uRL);
        return uRL;
    }

    protected String getHTMLString() {
        String string5;
        Object object;
        CharSequence charSequence;
        String string2;
        if (!this.record.getDescription().equals("")) {
            return this.record.getDescription();
        }
        boolean bl = this.record.getType().equals("Image") && this.record.getTarget() != null;
        boolean bl2 = this.record.getType().equals("Video") && this.record.getTarget() != null;
        boolean bl3 = this.record.getTarget() != null && (this.record.getTarget().toLowerCase().endsWith(".zip") || this.record.getTarget().toLowerCase().endsWith(".trz"));
        boolean bl4 = bl2 || bl3 || bl;
        String string3 = string2 = bl4 ? this.record.getThumbnail() : null;
        if (bl4 && string2 == null) {
            charSequence = this.getAbsoluteTarget();
            object = this.getThumbnailFile();
            if (((File)object).exists()) {
                string2 = ((File)object).getAbsolutePath();
                this.record.setThumbnail(string2);
            } else {
                new ThumbnailLoader((String)charSequence, ((File)object).getAbsolutePath()).execute();
            }
        }
        if (string2 != null) {
            string2 = XML.forwardSlash(string2);
            string2 = ResourceLoader.getURIPath(string2);
        }
        charSequence = new StringBuffer();
        object = " " + ToolsRes.getString("LibraryResource.Type.Collection.Description");
        String string4 = this.record.getName();
        if ("".equals(string4) && this.isRoot()) {
            string4 = this.record.getTitle(this.treePanel.pathToRoot);
        }
        for (String string5 : LibraryResource.allResourceTypes) {
            ArrayList<LibraryResource> arrayList;
            if (string5.equals("Unknown") || string5.equals("PDF")) continue;
            String[] stringArray = new String[]{string5};
            if (string5.equals("HTML")) {
                string5 = "Other";
                stringArray = new String[]{"HTML", "PDF", "Unknown"};
            }
            if ((arrayList = this.getChildResources(stringArray)).isEmpty()) continue;
            String string6 = "LibraryResource.Type." + string5 + ".List";
            ((StringBuffer)charSequence).append("<p>" + ToolsRes.getString(string6) + " " + string4 + (String)object + ":</p>\n");
            ((StringBuffer)charSequence).append("<ol>\n");
            for (LibraryResource libraryResource : arrayList) {
                String string7 = libraryResource.getName();
                if (string7.equals("")) {
                    string7 = ToolsRes.getString("LibraryResource.Name.Default");
                }
                ((StringBuffer)charSequence).append("<li>" + string7 + "</li>\n");
            }
            ((StringBuffer)charSequence).append("</ol>\n");
        }
        string5 = ((StringBuffer)charSequence).toString();
        String string8 = LibraryResource.getHTMLBody(string4, this.record.getType(), string2, string5, null, null, null, null);
        return string8;
    }

    protected String getTarget() {
        return this.record.getTarget();
    }

    protected String getAbsoluteTarget() {
        if (this.getTarget() == null) {
            return null;
        }
        if (this.record instanceof LibraryCollection) {
            return String.valueOf(this.getBasePath()) + this.getTarget();
        }
        return XML.getResolvedPath(this.getTarget(), this.getBasePath());
    }

    protected URL getTargetURL() {
        String string = this.getAbsoluteTarget();
        if (string == null) {
            return null;
        }
        String string2 = string;
        URL uRL = null;
        String string3 = this.record.getProperty("download_filename");
        File file = ResourceLoader.getOSPCacheFile(string, string3);
        boolean bl = file.exists();
        if (bl) {
            string2 = ResourceLoader.getURIPath(file.getAbsolutePath());
        }
        if (targetURLs.keySet().contains(string)) {
            uRL = targetURLs.get(string);
        } else {
            Resource resource = ResourceLoader.getResourceZipURLsOK(string2);
            if (resource != null) {
                uRL = resource.getURL();
            } else {
                resource = ResourceLoader.getResourceZipURLsOK(string2 = ResourceLoader.getURIPath(string2));
                if (resource != null) {
                    uRL = resource.getURL();
                }
            }
        }
        targetURLs.put(string, uRL);
        return uRL;
    }

    @Override
    public String toString() {
        return this.record.toString();
    }

    protected boolean isEditable() {
        if (this.isRoot()) {
            return this.editable;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.getParent();
        return this.editable && libraryTreeNode.isEditable();
    }

    protected void setEditable(boolean bl) {
        this.editable = bl;
    }

    protected void setName(String string) {
        if (this.record.setName(string)) {
            this.treePanel.tree.getModel().valueForPathChanged(new TreePath(this.getPath()), string);
            this.treePanel.showInfo(this);
            this.treePanel.setChanged();
        }
    }

    protected boolean setTarget(String string) {
        if (this.record.setTarget(string)) {
            if (string == null) {
                string = "";
            }
            if (string.toLowerCase().endsWith(".trk") || string.toLowerCase().endsWith(".trz")) {
                this.setType("Tracker");
            } else if (string.indexOf("EJS") > -1) {
                this.setType("EJS");
            } else if (string.toLowerCase().endsWith(".zip")) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        String string = LibraryTreeNode.this.getAbsoluteTarget();
                        Set<String> set = ResourceLoader.getZipContents(string);
                        for (String string2 : set) {
                            if (!string2.endsWith(".trk")) continue;
                            LibraryTreeNode.this.setType("Tracker");
                            break;
                        }
                    }
                };
                new Thread(runnable).start();
            } else if (string.equals("")) {
                if (this.getHTMLPath() == null) {
                    this.setType("Unknown");
                } else {
                    this.setType("HTML");
                }
            } else {
                Object object;
                boolean bl = false;
                Object[] objectArray = LibraryResource.imageFilters;
                int n = LibraryResource.imageFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    object = objectArray[n2];
                    if (bl) break;
                    VideoFileFilter videoFileFilter = (VideoFileFilter)object;
                    String[] stringArray = videoFileFilter.getExtensions();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String string2 = stringArray[n4];
                        if (string.toUpperCase().endsWith("." + string2.toUpperCase())) {
                            this.setType("Image");
                            bl = true;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                objectArray = VideoIO.getVideoExtensions();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    object = objectArray[n2];
                    if (bl) break;
                    if (string.toUpperCase().endsWith("." + ((String)object).toUpperCase())) {
                        this.setType("Video");
                        bl = true;
                    }
                    ++n2;
                }
            }
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.record.setThumbnail(null);
            this.treePanel.showInfo(this);
            this.treePanel.setChanged();
            this.tooltip = null;
            return true;
        }
        return false;
    }

    protected void setHTMLPath(String string) {
        if (this.record.setHTMLPath(string)) {
            this.treePanel.showInfo(this);
            this.treePanel.setChanged();
            this.tooltip = null;
        }
    }

    protected void setBasePath(String string) {
        if (this.record.setBasePath(string)) {
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.record.setThumbnail(null);
            this.treePanel.showInfo(this);
            this.treePanel.setChanged();
        }
    }

    protected void setType(String string) {
        if (this.record.setType(string)) {
            LibraryTreePanel.htmlPanesByNode.remove(this);
            this.treePanel.showInfo(this);
            this.treePanel.setChanged();
            this.tooltip = null;
        }
    }

    protected ArrayList<LibraryResource> getChildResources(String[] stringArray) {
        this.resources.clear();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            int n3 = 0;
            while (n3 < this.getChildCount()) {
                LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.getChildAt(n3);
                if (libraryTreeNode.record.getType().equals(string)) {
                    this.resources.add(libraryTreeNode.record);
                }
                ++n3;
            }
            ++n2;
        }
        return this.resources;
    }

    protected String getToolTip() {
        if (this.tooltip == null) {
            TreeSet<LibraryResource.Metadata> treeSet;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.record.getType().equals("Collection") && this.isRoot() && !"".equals(this.treePanel.pathToRoot)) {
                stringBuffer.append(String.valueOf(ToolsRes.getString("LibraryTreeNode.Tooltip.CollectionPath")) + ": " + this.treePanel.pathToRoot);
            }
            if ((treeSet = this.record.getMetadata()) != null) {
                for (LibraryResource.Metadata metadata : treeSet) {
                    String string = metadata.getData()[0];
                    String string2 = metadata.getData()[1];
                    boolean bl = false;
                    Object object = LibraryResource.META_TYPES;
                    int n = LibraryResource.META_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string3 = object[n2];
                        if (string3.toLowerCase().contains(string.toLowerCase())) {
                            string = ToolsRes.getString("LibraryTreePanel.Label." + string3);
                        }
                        bl = string3.equals("Keywords");
                        ++n2;
                    }
                    if (bl && string2.length() > 100) {
                        int n3 = string.length();
                        String string4 = "";
                        n = 0;
                        while (n < n3) {
                            string4 = String.valueOf(string4) + "  ";
                            ++n;
                        }
                        StringBuffer stringBuffer2 = new StringBuffer();
                        object = string2.substring(0, 80);
                        String string5 = string2.substring(80);
                        while (true) {
                            String[] stringArray = string5.split(" ", 2);
                            stringBuffer2.append(String.valueOf(object) + stringArray[0]);
                            if (stringArray.length == 1) break;
                            if (stringArray[1].length() < 100) {
                                stringBuffer2.append("\n" + string4 + stringArray[1]);
                                break;
                            }
                            stringBuffer2.append("\n" + string4);
                            object = stringArray[1].substring(0, 80);
                            string5 = stringArray[1].substring(80);
                        }
                        string2 = stringBuffer2.toString();
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(String.valueOf(string) + ": " + string2);
                }
            }
            this.tooltip = stringBuffer.toString();
        }
        return this.tooltip.length() > 0 ? this.tooltip : ToolsRes.getString("LibraryTreeNode.Tooltip.None");
    }

    protected String getMetadataSourcePath() {
        String string = this.metadataSource;
        if (string != null) {
            return XML.getResolvedPath(string, this.getBasePath());
        }
        return this.getHTMLPath();
    }

    protected TreeSet<LibraryResource.Metadata> getMetadata() {
        TreeSet<LibraryResource.Metadata> treeSet = this.record.getMetadata();
        if (treeSet == null) {
            Resource resource;
            String string;
            treeSet = new TreeSet();
            this.record.setMetadata(treeSet);
            String string2 = this.getMetadataSourcePath();
            if (string2 != null && (string = (resource = ResourceLoader.getResourceZipURLsOK(string2)).getString()) != null) {
                boolean[] blArray = new boolean[LibraryResource.META_TYPES.length];
                String[] stringArray = string.split("<meta name=");
                int n = 1;
                while (n < stringArray.length) {
                    int n2 = stringArray[n].indexOf("\">");
                    if (n2 > -1) {
                        stringArray[n] = stringArray[n].substring(0, n2);
                        String[] stringArray2 = stringArray[n].split("content=\"");
                        if (stringArray2.length > 1) {
                            String string3 = stringArray2[0].trim();
                            if (string3.startsWith("\"")) {
                                string3 = string3.substring(1);
                            }
                            if (string3.endsWith("\"")) {
                                string3 = string3.substring(0, string3.length() - 1);
                            }
                            int n3 = 0;
                            while (n3 < LibraryResource.META_TYPES.length) {
                                if (!blArray[n3] && LibraryResource.META_TYPES[n3].toLowerCase().contains(string3.toLowerCase())) {
                                    string3 = LibraryResource.META_TYPES[n3];
                                    blArray[n3] = true;
                                }
                                ++n3;
                            }
                            String string4 = stringArray2[1].trim();
                            this.record.addMetadata(new LibraryResource.Metadata(string3, string4));
                        }
                    }
                    ++n;
                }
            }
            this.tooltip = null;
        }
        return treeSet;
    }

    protected String getMetadataValue(String string) {
        TreeSet<LibraryResource.Metadata> treeSet = this.record.getMetadata();
        if (treeSet != null) {
            for (LibraryResource.Metadata metadata : treeSet) {
                if (metadata.getData()[0].indexOf(string) <= -1) continue;
                return metadata.getData()[1];
            }
        }
        return null;
    }

    protected File getThumbnailFile() {
        String string = this.record.getThumbnail();
        if (string != null) {
            return new File(string);
        }
        String string2 = this.getAbsoluteTarget();
        String string3 = XML.stripExtension(XML.getName(string2));
        String string4 = String.valueOf(string3) + "_thumbnail.png";
        return ResourceLoader.getOSPCacheFile(string2, string4);
    }

    protected File createThumbnailFile(BufferedImage bufferedImage, String string, Dimension dimension) {
        double d = dimension.getWidth() / (double)bufferedImage.getWidth();
        double d2 = dimension.getHeight() / (double)bufferedImage.getHeight();
        double d3 = Math.min(d, d2);
        int n = (int)((double)bufferedImage.getWidth() * d3);
        int n2 = (int)((double)bufferedImage.getHeight() * d3);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 5);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d3, d3);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return VideoIO.writeImageFile(bufferedImage2, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ThumbnailLoader
    extends SwingWorker<File, Object> {
        String thumbPath;
        String sourcePath;

        ThumbnailLoader(String string, String string2) {
            this.thumbPath = string2;
            this.sourcePath = string;
        }

        @Override
        public File doInBackground() {
            File file = null;
            String string = XML.getExtension(this.sourcePath);
            if (string != null && "GIF".equals(string.toUpperCase())) {
                GifDecoder gifDecoder = new GifDecoder();
                int n = gifDecoder.read(this.sourcePath);
                if (n != 0) {
                    OSPLog.fine("failed to create thumbnail for GIF " + this.thumbPath);
                } else {
                    BufferedImage bufferedImage = gifDecoder.getImage();
                    Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                    file = LibraryTreeNode.this.createThumbnailFile(bufferedImage, this.thumbPath, dimension);
                }
            } else if (string != null && ("PNG".equals(string.toUpperCase()) || string.toUpperCase().contains("JP"))) {
                try {
                    URL uRL = new URL(ResourceLoader.getURIPath(this.sourcePath));
                    BufferedImage bufferedImage = ImageIO.read(uRL);
                    Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                    file = LibraryTreeNode.this.createThumbnailFile(bufferedImage, this.thumbPath, dimension);
                }
                catch (Exception exception) {
                    OSPLog.fine("failed to create thumbnail for " + this.thumbPath);
                }
            } else if (string != null && ("ZIP".equals(string.toUpperCase()) || "TRZ".equals(string.toUpperCase()))) {
                for (String string2 : ResourceLoader.getZipContents(this.sourcePath)) {
                    if (string2.indexOf("_thumbnail") <= -1) continue;
                    String string3 = ResourceLoader.getURIPath(String.valueOf(this.sourcePath) + "!/" + string2);
                    file = JarTool.extract(string3, new File(this.thumbPath));
                }
            } else {
                String string4 = "org.opensourcephysics.media.xuggle.XuggleThumbnailTool";
                Class[] classArray = new Class[]{Dimension.class, String.class, String.class};
                Object[] objectArray = new Object[]{defaultThumbnailDimension, this.sourcePath, this.thumbPath};
                try {
                    Class<?> clazz = Class.forName(string4);
                    Method method = clazz.getMethod("createThumbnailFile", classArray);
                    file = (File)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    OSPLog.fine("failed to create thumbnail: " + exception.toString());
                }
                catch (Error error) {}
            }
            return file;
        }

        @Override
        protected void done() {
            try {
                File file = (File)this.get();
                LibraryTreeNode.this.record.setThumbnail(file == null || !file.exists() ? null : file.getAbsolutePath());
                if (LibraryTreeNode.this.record.getThumbnail() != null) {
                    LibraryTreePanel.htmlPanesByNode.remove(LibraryTreeNode.this);
                    LibraryTreeNode.this.treePanel.showInfo(LibraryTreeNode.this.treePanel.getSelectedNode());
                }
            }
            catch (Exception exception) {}
        }
    }
}

