/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLDocument;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.desktop.ostermiller.Browser;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.JMultiLineToolTip;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryCollection;
import org.opensourcephysics.tools.LibraryComPADRE;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.LibraryTreeNode;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryTreePanel
extends JPanel {
    protected final String AND = " AND ";
    protected final String OR = " OR ";
    protected final String OPENING = "(";
    protected final String CLOSING = ")";
    protected static int keyFieldWidth = 100;
    protected static Color lightRed = new Color(255, 180, 200);
    protected static Color darkRed = new Color(220, 0, 0);
    protected static Color lightGreen = new Color(100, 200, 100);
    protected static Color defaultForeground;
    protected static Icon openFileIcon;
    protected static HyperlinkListener hyperlinkListener;
    protected static JFileChooser chooser;
    protected static FileFilter htmlFilter;
    protected static FileFilter folderFilter;
    protected static HashMap<URL, HTMLPane> htmlPanesByURL;
    protected static HashMap<LibraryTreeNode, HTMLPane> htmlPanesByNode;
    protected LibraryBrowser browser;
    protected LibraryResource rootResource;
    protected String pathToRoot;
    protected LibraryTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected JTree tree;
    protected JScrollPane treeScroller = new JScrollPane();
    protected JScrollPane htmlScroller = new JScrollPane();
    protected JToolBar editorbar;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action addCollectionAction;
    protected Action addResourceAction;
    protected Action moveUpAction;
    protected Action moveDownAction;
    protected Action metadataAction;
    protected JButton cutButton;
    protected JButton copyButton;
    protected JButton pasteButton;
    protected JButton addCollectionButton;
    protected JButton addResourceButton;
    protected JButton moveUpButton;
    protected JButton moveDownButton;
    protected JButton metadataButton;
    protected Box editorPanel;
    protected Box fileBox;
    protected JPanel displayPanel;
    protected HTMLPane emptyHTMLPane;
    protected JSplitPane splitPane;
    protected EntryField nameField;
    protected EntryField htmlField;
    protected EntryField basePathField;
    protected EntryField targetField;
    protected JLabel nameLabel;
    protected JLabel htmlLabel;
    protected JLabel basePathLabel;
    protected JLabel targetLabel;
    protected ActionListener metadataFieldListener;
    protected EntryField authorField;
    protected EntryField contactField;
    protected EntryField keywordsField;
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JLabel keywordsLabel;
    protected JLabel metadataLabel;
    protected Box authorBox;
    protected Box contactBox;
    protected Box keywordsBox;
    protected Box metadataBox;
    protected MetadataComboBoxModel metadataModel;
    protected JComboBox metadataDropdown;
    protected MetadataEditField keyEditField;
    protected MetadataEditField valueEditField;
    protected JLabel typeLabel;
    protected JLabel typeField;
    protected JButton openHTMLButton;
    protected JButton openBasePathButton;
    protected JButton openFileButton;
    protected ArrayList<JLabel> labels = new ArrayList();
    protected JPopupMenu popup;
    protected MouseAdapter treeMouseListener;
    protected MouseAdapter convertPathMouseListener;
    protected TreeSelectionListener treeSelectionListener;
    protected XMLControl pasteControl;
    protected boolean isEditing;
    protected boolean isChanged;
    protected boolean isXMLPath;
    protected boolean ignoreChanges;
    protected XMLControl revertControl;
    protected int typeFieldWidth;
    protected String command;
    protected LibraryResource.Metadata emptyMetadata = new LibraryResource.Metadata();
    protected MetadataLoader metadataLoader;
    protected Set<EntryField> entryFields = new HashSet<EntryField>();

    static {
        htmlPanesByURL = new HashMap();
        htmlPanesByNode = new HashMap();
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        openFileIcon = new ImageIcon(LibraryTreePanel.class.getResource(string));
        hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (!OSPDesktop.browse(hyperlinkEvent.getURL().toURI())) {
                            Browser.init();
                            Browser.displayURL(hyperlinkEvent.getURL().toString());
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
    }

    public LibraryTreePanel(LibraryBrowser libraryBrowser) {
        super(new BorderLayout());
        this.browser = libraryBrowser;
        this.createGUI();
    }

    public void setRootResource(LibraryResource libraryResource, String string, boolean bl, boolean bl2) {
        this.rootResource = libraryResource;
        this.isXMLPath = bl2;
        this.pathToRoot = string;
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this.treeSelectionListener);
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        this.setEditing(false);
        if (libraryResource != null) {
            this.ignoreChanges = true;
            this.rootNode = new LibraryTreeNode(libraryResource, this);
            this.rootNode.setEditable(bl);
            this.createTree(this.rootNode);
            this.tree.setSelectionRow(0);
            this.splitPane.setDividerLocation(this.treeScroller.getPreferredSize().width);
            this.isChanged = false;
            this.ignoreChanges = false;
            this.refreshGUI();
        }
    }

    public LibraryResource getCollection() {
        return this.rootResource;
    }

    protected LibraryTreeNode getSelectedNode() {
        if (this.tree == null) {
            return null;
        }
        return (LibraryTreeNode)this.tree.getLastSelectedPathComponent();
    }

    protected void setSelectedNode(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode != null) {
            this.tree.setSelectionPath(new TreePath(libraryTreeNode.getPath()));
        } else {
            this.tree.setSelectionPath(null);
        }
    }

    protected void setSelectionPath(List<String> list) {
        if (list != null && list.get(0).equals(this.rootNode.toString())) {
            LibraryTreeNode libraryTreeNode = this.rootNode;
            int n = 1;
            while (n < list.size()) {
                String string = list.get(n);
                int n2 = libraryTreeNode.getChildCount();
                int n3 = 0;
                while (n3 < n2) {
                    if (string.equals(libraryTreeNode.getChildAt(n3).toString())) {
                        libraryTreeNode = (LibraryTreeNode)libraryTreeNode.getChildAt(n3);
                        break;
                    }
                    ++n3;
                }
                ++n;
            }
            this.setSelectedNode(libraryTreeNode);
        }
    }

    protected void setFontLevel(int n) {
        Object[] objectArray = new Object[]{this.splitPane, this.editorPanel, this.editorbar, this.authorField, this.contactField, this.keywordsField, this.authorLabel, this.contactLabel, this.keywordsLabel, this.metadataLabel, this.metadataDropdown};
        FontSizer.setFonts(objectArray, n);
        EntryField.font = this.authorField.getFont();
        TreeModel treeModel = this.tree.getModel();
        if (treeModel instanceof DefaultTreeModel) {
            LibraryTreeNode libraryTreeNode = this.getSelectedNode();
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModel;
            defaultTreeModel.nodeStructureChanged(this.rootNode);
            this.setSelectedNode(libraryTreeNode);
        }
        this.refreshGUI();
    }

    protected void setEditing(boolean bl) {
        this.isEditing = bl;
        if (this.isEditing) {
            this.displayPanel.add((Component)this.editorPanel, "North");
            this.add((Component)this.editorbar, "North");
            this.showInfo(this.getSelectedNode());
        } else {
            this.displayPanel.remove(this.editorPanel);
            this.remove(this.editorbar);
        }
        this.validate();
        if (this.isEditing) {
            this.revertControl = new XMLControlElement(this.rootResource);
        }
    }

    protected boolean isEditable() {
        boolean bl;
        boolean bl2 = bl = this.rootNode != null && this.rootNode.isEditable();
        if (bl && !this.pathToRoot.startsWith("http:")) {
            File file = new File(this.pathToRoot);
            bl = !file.exists() || file.canWrite();
        }
        return bl;
    }

    protected boolean isEditing() {
        return this.isEditing;
    }

    protected void showInfo(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode == null) {
            this.htmlScroller.setViewportView(this.emptyHTMLPane);
            this.nameField.setText(null);
            this.typeField.setText(" ");
            this.basePathField.setText(null);
            this.htmlField.setText(null);
            this.targetField.setText(null);
            this.nameField.setBackground(Color.white);
            this.basePathField.setBackground(Color.white);
            this.htmlField.setBackground(Color.white);
            this.targetField.setBackground(Color.white);
            this.nameField.setEnabled(false);
            this.basePathField.setEnabled(false);
            this.htmlField.setEnabled(false);
            this.targetField.setEnabled(false);
            this.typeField.setEnabled(false);
            this.nameLabel.setEnabled(false);
            this.htmlLabel.setEnabled(false);
            this.basePathLabel.setEnabled(false);
            this.targetLabel.setEnabled(false);
            this.typeLabel.setEnabled(false);
            this.openHTMLButton.setEnabled(false);
            this.openBasePathButton.setEnabled(false);
            this.openFileButton.setEnabled(false);
            return;
        }
        this.showHTMLPane(libraryTreeNode);
        boolean bl = libraryTreeNode.record instanceof LibraryCollection;
        String string = libraryTreeNode.isRoot() ? this.pathToRoot : libraryTreeNode.getAbsoluteTarget();
        LibraryTreePanel libraryTreePanel = this.browser.getSelectedTreePanel();
        if (libraryTreePanel == this && !this.browser.commandField.getText().equals(string)) {
            this.browser.commandField.setText(string);
            boolean bl2 = false;
            if (string != null) {
                if (string.startsWith("http:/")) {
                    bl2 = LibraryBrowser.isWebConnected();
                    if (!bl2) {
                        File file = null;
                        if (bl) {
                            file = ResourceLoader.getSearchCacheFile(string);
                        } else {
                            String string2 = libraryTreeNode.record.getProperty("download_filename");
                            file = ResourceLoader.getOSPCacheFile(string, string2);
                        }
                        bl2 = file.exists();
                    }
                } else {
                    bl2 = ResourceLoader.getResourceZipURLsOK(ResourceLoader.getURIPath(string)) != null;
                }
            }
            this.browser.commandField.setForeground(bl2 ? defaultForeground : darkRed);
            this.browser.commandField.setCaretPosition(0);
            if (libraryTreeNode.isRoot()) {
                this.browser.commandButton.setEnabled(false);
            }
        }
        if (this.isEditing()) {
            String string3;
            String string4;
            String string5;
            if (!this.nameField.getText().equals(libraryTreeNode.getName())) {
                this.nameField.setText(libraryTreeNode.getName());
                this.nameField.setCaretPosition(0);
            }
            String string6 = string5 = this.basePathField.hasFocus() ? libraryTreeNode.record.getBasePath() : libraryTreeNode.getBasePath();
            if (!this.basePathField.getText().equals(string5)) {
                this.basePathField.setText(string5);
                this.basePathField.setCaretPosition(0);
            }
            if (!this.htmlField.getText().equals(libraryTreeNode.record.getHTMLPath())) {
                this.htmlField.setText(libraryTreeNode.record.getHTMLPath());
                this.htmlField.setCaretPosition(0);
            }
            boolean bl3 = true;
            if (!"".equals(libraryTreeNode.record.getHTMLPath())) {
                bl3 = libraryTreeNode.getHTMLURL() != null;
            }
            this.htmlField.setForeground(bl3 ? defaultForeground : darkRed);
            this.htmlField.setBackground(Color.white);
            if (!this.targetField.getText().equals(libraryTreeNode.getTarget())) {
                this.targetField.setText(libraryTreeNode.getTarget());
                this.targetField.setCaretPosition(0);
            }
            boolean bl4 = true;
            if (libraryTreeNode.getTarget() != null) {
                bl4 = libraryTreeNode.getTargetURL() != null;
            }
            this.targetField.setForeground(bl4 ? defaultForeground : darkRed);
            this.targetField.setBackground(Color.white);
            String string7 = libraryTreeNode.record.getType();
            string7 = ToolsRes.getString("LibraryResource.Type." + string7);
            this.typeField.setText(string7);
            boolean bl5 = !"".equals(libraryTreeNode.record.getBasePath());
            this.nameField.setEnabled(true);
            this.basePathField.setEnabled(true);
            this.htmlField.setEnabled(true);
            this.typeField.setEnabled(true);
            this.targetField.setEnabled(!bl);
            this.nameLabel.setEnabled(true);
            this.htmlLabel.setEnabled(true);
            this.basePathLabel.setEnabled(true);
            this.targetLabel.setEnabled(!bl);
            this.typeLabel.setEnabled(true);
            this.openHTMLButton.setEnabled(true);
            this.openBasePathButton.setEnabled(true);
            this.openFileButton.setEnabled(!bl);
            this.basePathField.setForeground(bl5 || this.basePathField.hasFocus() ? defaultForeground : lightGreen);
            this.nameField.setBackground(Color.white);
            this.basePathField.setBackground(Color.white);
            String string8 = libraryTreeNode.getMetadataValue("Author");
            if (string8 == null) {
                string8 = "";
            }
            if (!this.authorField.getText().equals(string8)) {
                this.authorField.setText(string8);
                this.authorField.setCaretPosition(0);
                this.authorField.setBackground(Color.white);
            }
            if ((string4 = libraryTreeNode.getMetadataValue("Contact")) == null) {
                string4 = "";
            }
            if (!this.contactField.getText().equals(string4)) {
                this.contactField.setText(string4);
                this.contactField.setCaretPosition(0);
                this.contactField.setBackground(Color.white);
            }
            if ((string3 = libraryTreeNode.getMetadataValue("Keywords")) == null) {
                string3 = "";
            }
            if (!this.keywordsField.getText().equals(string3)) {
                this.keywordsField.setText(string3);
                this.keywordsField.setCaretPosition(0);
                this.keywordsField.setBackground(Color.white);
            }
            if (libraryTreeNode.selectedMetadata != null) {
                this.metadataDropdown.getEditor().setItem(libraryTreeNode.selectedMetadata);
            } else {
                this.metadataDropdown.getEditor().setItem(this.emptyMetadata);
            }
            string = this.htmlField.getText();
            if (!string.equals(XML.getPathRelativeTo(string, string5))) {
                this.htmlField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Relative"));
            } else if (!string.equals(XML.getResolvedPath(string, string5))) {
                this.htmlField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Absolute"));
            } else {
                this.htmlField.setToolTipText(null);
            }
            string = this.targetField.getText();
            if (!string.equals(XML.getPathRelativeTo(string, string5))) {
                this.targetField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Relative"));
            } else if (!string.equals(XML.getResolvedPath(string, string5))) {
                this.targetField.setToolTipText(ToolsRes.getString("LibraryTreePanel.Tooltip.Absolute"));
            } else {
                this.targetField.setToolTipText(null);
            }
        }
        this.repaint();
    }

    protected void showHTMLPane(LibraryTreeNode libraryTreeNode) {
        HTMLPane hTMLPane = htmlPanesByNode.get(libraryTreeNode);
        if (hTMLPane != null && hTMLPane == this.htmlScroller.getViewport().getView()) {
            return;
        }
        new HTMLDisplayer(libraryTreeNode).execute();
    }

    protected void createGUI() {
        this.popup = new JPopupMenu();
        this.addCollectionAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                htmlPanesByNode.remove(libraryTreeNode);
                LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
                LibraryCollection libraryCollection2 = new LibraryCollection(null);
                libraryCollection.addResource(libraryCollection2);
                LibraryTreeNode libraryTreeNode2 = new LibraryTreeNode(libraryCollection2, LibraryTreePanel.this);
                if (LibraryTreePanel.this.insertChildAt(libraryTreeNode2, libraryTreeNode, libraryTreeNode.getChildCount())) {
                    TreePath treePath = new TreePath(libraryTreeNode2.getPath());
                    LibraryTreePanel.this.tree.scrollPathToVisible(treePath);
                    LibraryTreePanel.this.tree.setSelectionPath(treePath);
                }
                LibraryTreePanel.this.setChanged();
            }
        };
        this.addResourceAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                htmlPanesByNode.remove(libraryTreeNode);
                LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
                LibraryResource libraryResource = new LibraryResource(null);
                libraryCollection.addResource(libraryResource);
                LibraryTreeNode libraryTreeNode2 = new LibraryTreeNode(libraryResource, LibraryTreePanel.this);
                if (LibraryTreePanel.this.insertChildAt(libraryTreeNode2, libraryTreeNode, libraryTreeNode.getChildCount())) {
                    TreePath treePath = new TreePath(libraryTreeNode2.getPath());
                    LibraryTreePanel.this.tree.scrollPathToVisible(treePath);
                    LibraryTreePanel.this.tree.setSelectionPath(treePath);
                }
                LibraryTreePanel.this.setChanged();
            }
        };
        this.copyAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    XMLControlElement xMLControlElement = new XMLControlElement(libraryTreeNode.record);
                    String string = XML.forwardSlash(libraryTreeNode.getTarget());
                    if (!LibraryTreePanel.this.isEditing() && !string.startsWith("/") && string.indexOf(":") == -1) {
                        xMLControlElement.setValue("base_path", libraryTreeNode.getBasePath());
                    }
                    StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                    LibraryTreePanel.this.enableButtons();
                }
            }
        };
        this.cutAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    LibraryTreePanel.this.copyAction.actionPerformed(null);
                    LibraryTreePanel.this.removeNode(libraryTreeNode);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.pasteAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode == null || !(libraryTreeNode.record instanceof LibraryCollection)) {
                    return;
                }
                try {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable transferable = clipboard.getContents(null);
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (string != null) {
                        XMLControlElement xMLControlElement = new XMLControlElement();
                        xMLControlElement.readXML(string);
                        if (LibraryResource.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
                            htmlPanesByNode.remove(libraryTreeNode);
                            LibraryResource libraryResource = (LibraryResource)xMLControlElement.loadObject(null);
                            LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
                            libraryCollection.addResource(libraryResource);
                            LibraryTreeNode libraryTreeNode2 = new LibraryTreeNode(libraryResource, LibraryTreePanel.this);
                            if (LibraryTreePanel.this.insertChildAt(libraryTreeNode2, libraryTreeNode, libraryTreeNode.getChildCount())) {
                                TreePath treePath = new TreePath(libraryTreeNode2.getPath());
                                LibraryTreePanel.this.tree.scrollPathToVisible(treePath);
                                LibraryTreePanel.this.tree.setSelectionPath(treePath);
                            }
                            LibraryTreePanel.this.setChanged();
                        }
                    }
                }
                catch (Exception exception) {}
                LibraryTreePanel.this.enableButtons();
            }
        };
        this.moveUpAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                LibraryTreeNode libraryTreeNode;
                LibraryTreeNode libraryTreeNode2 = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode2 != null && (libraryTreeNode = (LibraryTreeNode)libraryTreeNode2.getParent()) != null && (n = libraryTreeNode.getIndex(libraryTreeNode2)) > 0) {
                    htmlPanesByNode.remove(libraryTreeNode);
                    LibraryTreePanel.this.treeModel.removeNodeFromParent(libraryTreeNode2);
                    LibraryTreePanel.this.treeModel.insertNodeInto(libraryTreeNode2, libraryTreeNode, n - 1);
                    LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
                    libraryCollection.removeResource(libraryTreeNode2.record);
                    libraryCollection.insertResource(libraryTreeNode2.record, n - 1);
                    LibraryTreePanel.this.setSelectedNode(libraryTreeNode2);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.moveDownAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2;
                LibraryTreeNode libraryTreeNode;
                LibraryTreeNode libraryTreeNode2 = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode2 != null && (libraryTreeNode = (LibraryTreeNode)libraryTreeNode2.getParent()) != null && (n2 = libraryTreeNode.getIndex(libraryTreeNode2)) < (n = libraryTreeNode.getChildCount()) - 1) {
                    htmlPanesByNode.remove(libraryTreeNode);
                    LibraryTreePanel.this.treeModel.removeNodeFromParent(libraryTreeNode2);
                    LibraryTreePanel.this.treeModel.insertNodeInto(libraryTreeNode2, libraryTreeNode, n2 + 1);
                    LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode.record;
                    libraryCollection.removeResource(libraryTreeNode2.record);
                    libraryCollection.insertResource(libraryTreeNode2.record, n2 + 1);
                    LibraryTreePanel.this.setSelectedNode(libraryTreeNode2);
                    LibraryTreePanel.this.enableButtons();
                    LibraryTreePanel.this.setChanged();
                }
            }
        };
        this.metadataAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !LibraryTreePanel.this.metadataButton.isSelected();
                LibraryTreePanel.this.metadataButton.setSelected(bl);
                LibraryTreePanel.this.metadataButton.setText(bl ? ToolsRes.getString("LibraryTreePanel.Button.Metadata.Hide") : ToolsRes.getString("LibraryTreePanel.Button.Metadata.Show"));
                if (bl) {
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.authorBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.contactBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.keywordsBox);
                    LibraryTreePanel.this.editorPanel.add(LibraryTreePanel.this.metadataBox);
                } else {
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.authorBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.contactBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.keywordsBox);
                    LibraryTreePanel.this.editorPanel.remove(LibraryTreePanel.this.metadataBox);
                }
            }
        };
        this.convertPathMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                EntryField entryField = (EntryField)mouseEvent.getSource();
                String string = entryField.getText();
                if ("".equals(string)) {
                    return;
                }
                final boolean bl = entryField == LibraryTreePanel.this.targetField;
                final LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null && OSPRuntime.isPopupTrigger(mouseEvent)) {
                    String string2 = libraryTreeNode.getBasePath();
                    if ("".equals(string2)) {
                        return;
                    }
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    final String string3 = XML.getPathRelativeTo(string, string2);
                    final String string4 = XML.getResolvedPath(string, string2);
                    if (!string.equals(string3)) {
                        JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("LibraryTreePanel.MenuItem.SetToRelative"));
                        jPopupMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (bl) {
                                    libraryTreeNode.setTarget(string3);
                                } else {
                                    libraryTreeNode.setHTMLPath(string3);
                                }
                            }
                        });
                    } else if (!string.equals(string4)) {
                        JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("LibraryTreePanel.MenuItem.SetToAbsolute"));
                        jPopupMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                if (bl) {
                                    libraryTreeNode.setTarget(string4);
                                } else {
                                    libraryTreeNode.setHTMLPath(string4);
                                }
                            }
                        });
                    }
                    if (jPopupMenu.getComponentCount() > 0) {
                        jPopupMenu.show(entryField, mouseEvent.getX() + 2, mouseEvent.getY() + 2);
                    }
                }
            }
        };
        this.treeSelectionListener = new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                LibraryTreePanel.this.emptyMetadata.clearData();
                LibraryTreePanel.this.metadataModel.dataChanged();
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                LibraryTreePanel.this.showInfo(libraryTreeNode);
                LibraryTreePanel.this.enableButtons();
            }
        };
        this.treeMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = LibraryTreePanel.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                LibraryTreePanel.this.tree.setSelectionPath(treePath);
                LibraryTreeNode libraryTreeNode = (LibraryTreeNode)LibraryTreePanel.this.tree.getLastSelectedPathComponent();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    LibraryTreePanel.this.getPopup(libraryTreeNode).show(LibraryTreePanel.this.tree, mouseEvent.getX(), mouseEvent.getY() + 8);
                } else if (mouseEvent.getClickCount() == 2 && libraryTreeNode.getTarget() != null) {
                    LibraryTreePanel.this.firePropertyChange("target", null, libraryTreeNode);
                }
            }
        };
        this.addCollectionButton = new JButton();
        this.addCollectionButton.setOpaque(false);
        this.addCollectionButton.setBorder(LibraryBrowser.buttonBorder);
        this.addCollectionButton.addActionListener(this.addCollectionAction);
        this.addResourceButton = new JButton(this.addResourceAction);
        this.addResourceButton.setOpaque(false);
        this.addResourceButton.setBorder(LibraryBrowser.buttonBorder);
        this.copyButton = new JButton(this.copyAction);
        this.copyButton.setOpaque(false);
        this.copyButton.setBorder(LibraryBrowser.buttonBorder);
        this.cutButton = new JButton(this.cutAction);
        this.cutButton.setOpaque(false);
        this.cutButton.setBorder(LibraryBrowser.buttonBorder);
        this.pasteButton = new JButton(this.pasteAction);
        this.pasteButton.setOpaque(false);
        this.pasteButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveUpButton = new JButton(this.moveUpAction);
        this.moveUpButton.setOpaque(false);
        this.moveUpButton.setBorder(LibraryBrowser.buttonBorder);
        this.moveDownButton = new JButton(this.moveDownAction);
        this.moveDownButton.setOpaque(false);
        this.moveDownButton.setBorder(LibraryBrowser.buttonBorder);
        this.metadataButton = new JButton(this.metadataAction);
        this.metadataButton.setOpaque(false);
        this.metadataButton.setBorder(LibraryBrowser.buttonBorder);
        this.editorbar = new JToolBar();
        this.editorbar.setFloatable(false);
        this.editorbar.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.editorbar.add(this.addResourceButton);
        this.editorbar.add(this.addCollectionButton);
        this.editorbar.addSeparator();
        this.editorbar.add(this.copyButton);
        this.editorbar.add(this.cutButton);
        this.editorbar.add(this.pasteButton);
        this.editorbar.addSeparator();
        this.editorbar.add(this.moveUpButton);
        this.editorbar.add(this.moveDownButton);
        this.editorbar.add(Box.createHorizontalGlue());
        this.editorbar.add(this.metadataButton);
        this.emptyHTMLPane = new HTMLPane();
        this.displayPanel = new JPanel(new BorderLayout());
        this.displayPanel.add((Component)this.htmlScroller, "Center");
        this.splitPane = new JSplitPane(1, this.treeScroller, this.displayPanel);
        this.add((Component)this.splitPane, "Center");
        this.treeScroller.setPreferredSize(new Dimension(240, 400));
        this.editorPanel = Box.createVerticalBox();
        this.nameField = new EntryField();
        this.entryFields.add(this.nameField);
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    htmlPanesByNode.remove(libraryTreeNode);
                    LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
                    if (libraryTreeNode2 != null) {
                        htmlPanesByNode.remove(libraryTreeNode2);
                    }
                    libraryTreeNode.setName(LibraryTreePanel.this.nameField.getText());
                    if (libraryTreeNode.isRoot()) {
                        LibraryTreePanel.this.browser.refreshTabTitle(LibraryTreePanel.this.pathToRoot, LibraryTreePanel.this.rootResource);
                    }
                }
            }
        });
        this.typeField = new JLabel(" "){

            public Dimension getPreferredSize() {
                Dimension dimension = LibraryTreePanel.this.nameField.getPreferredSize();
                dimension.width = LibraryTreePanel.this.typeFieldWidth;
                return dimension;
            }
        };
        this.typeField.setBorder(this.nameField.getBorder());
        this.typeField.setBackground(this.nameField.getBackground());
        this.typeField.setFont(this.nameField.getFont());
        this.typeField.setOpaque(true);
        this.typeField.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                final LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null && !(libraryTreeNode.record instanceof LibraryCollection)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            String string = actionEvent.getActionCommand();
                            if (!string.equals(libraryTreeNode.record.getType())) {
                                htmlPanesByNode.remove(libraryTreeNode);
                                LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
                                if (libraryTreeNode2 != null) {
                                    htmlPanesByNode.remove(libraryTreeNode2);
                                }
                                libraryTreeNode.setType(string);
                                string = ToolsRes.getString("LibraryResource.Type." + libraryTreeNode.record.getType());
                                (this).LibraryTreePanel.this.typeField.setText(string);
                                LibraryTreePanel.this.setChanged();
                                LibraryTreePanel.this.showInfo(libraryTreeNode);
                            }
                        }
                    };
                    String[] stringArray = LibraryResource.RESOURCE_TYPES;
                    int n = LibraryResource.RESOURCE_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string = stringArray[n2];
                        JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("LibraryResource.Type." + string)){

                            public Dimension getPreferredSize() {
                                Dimension dimension = (this).LibraryTreePanel.this.typeField.getPreferredSize();
                                dimension.width -= 2;
                                return dimension;
                            }
                        };
                        jPopupMenu.add(jMenuItem);
                        jMenuItem.addActionListener(actionListener);
                        jMenuItem.setActionCommand(string);
                        ++n2;
                    }
                    jPopupMenu.show(LibraryTreePanel.this.typeField, 0, LibraryTreePanel.this.typeField.getHeight());
                }
            }
        });
        this.htmlField = new EntryField();
        this.entryFields.add(this.htmlField);
        this.htmlField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    libraryTreeNode.setHTMLPath(LibraryTreePanel.this.htmlField.getText());
                }
            }
        });
        this.htmlField.addMouseListener(this.convertPathMouseListener);
        this.openHTMLButton = new JButton(openFileIcon);
        this.openHTMLButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openHTMLButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    int n = 1;
                    JFileChooser jFileChooser = LibraryTreePanel.getFileChooser();
                    jFileChooser.setDialogTitle(null);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setAcceptAllFileFilterUsed(true);
                    jFileChooser.addChoosableFileFilter(htmlFilter);
                    n = jFileChooser.showOpenDialog(LibraryTreePanel.this);
                    File file = jFileChooser.getSelectedFile();
                    jFileChooser.removeChoosableFileFilter(htmlFilter);
                    jFileChooser.setSelectedFile(new File(""));
                    if (n == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = jFileChooser.getCurrentDirectory().toString();
                        if (file != null) {
                            String string = XML.forwardSlash(file.getAbsolutePath());
                            String string2 = libraryTreeNode.getBasePath();
                            if (!"".equals(string2)) {
                                string = XML.getPathRelativeTo(string, string2);
                            }
                            libraryTreeNode.setHTMLPath(string);
                        }
                    }
                }
            }
        });
        this.basePathField = new EntryField();
        this.entryFields.add(this.basePathField);
        this.basePathField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (LibraryTreePanel.this.basePathField.getBackground() != Color.yellow) {
                    return;
                }
                if (libraryTreeNode != null && !LibraryTreePanel.this.basePathField.getText().equals(libraryTreeNode.record.getBasePath())) {
                    htmlPanesByNode.remove(libraryTreeNode);
                    LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
                    if (libraryTreeNode2 != null) {
                        htmlPanesByNode.remove(libraryTreeNode2);
                    }
                    libraryTreeNode.setBasePath(LibraryTreePanel.this.basePathField.getText());
                    LibraryTreePanel.this.setChanged();
                }
            }
        });
        this.basePathField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if ("".equals(libraryTreeNode.record.getBasePath())) {
                    LibraryTreePanel.this.basePathField.setText(null);
                    LibraryTreePanel.this.basePathField.setForeground(LibraryTreePanel.this.htmlField.getForeground());
                    LibraryTreePanel.this.basePathField.setBackground(Color.white);
                }
            }
        });
        this.openBasePathButton = new JButton(openFileIcon);
        this.openBasePathButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openBasePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    int n = 1;
                    JFileChooser jFileChooser = LibraryTreePanel.getFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setAcceptAllFileFilterUsed(false);
                    jFileChooser.addChoosableFileFilter(folderFilter);
                    jFileChooser.setDialogTitle(ToolsRes.getString("LibraryTreePanel.FileChooser.Title.Base"));
                    n = jFileChooser.showDialog(LibraryTreePanel.this, ToolsRes.getString("LibraryTreePanel.FileChooser.Button.Select"));
                    File file = jFileChooser.getSelectedFile();
                    jFileChooser.removeChoosableFileFilter(folderFilter);
                    jFileChooser.setSelectedFile(new File(""));
                    if (n == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = jFileChooser.getCurrentDirectory().toString();
                        if (file != null) {
                            htmlPanesByNode.remove(libraryTreeNode);
                            LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
                            if (libraryTreeNode2 != null) {
                                htmlPanesByNode.remove(libraryTreeNode2);
                            }
                            libraryTreeNode.setBasePath(XML.forwardSlash(file.getAbsolutePath()));
                            LibraryTreePanel.this.setChanged();
                            LibraryTreePanel.this.showInfo(libraryTreeNode);
                        }
                    }
                }
            }
        });
        this.targetField = new EntryField();
        this.entryFields.add(this.targetField);
        this.targetField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null && !(libraryTreeNode.record instanceof LibraryCollection)) {
                    libraryTreeNode.setTarget(LibraryTreePanel.this.targetField.getText());
                }
            }
        });
        this.targetField.addMouseListener(this.convertPathMouseListener);
        this.openFileButton = new JButton(openFileIcon);
        this.openFileButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
        this.openFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    int n = 1;
                    JFileChooser jFileChooser = LibraryTreePanel.getFileChooser();
                    jFileChooser.setDialogTitle(null);
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setAcceptAllFileFilterUsed(true);
                    n = jFileChooser.showOpenDialog(LibraryTreePanel.this);
                    File file = jFileChooser.getSelectedFile();
                    jFileChooser.setSelectedFile(new File(""));
                    if (n == 0) {
                        LibraryTreePanel.this.browser.library.chooserDir = jFileChooser.getCurrentDirectory().toString();
                        if (file != null) {
                            String string = XML.forwardSlash(file.getAbsolutePath());
                            String string2 = libraryTreeNode.getBasePath();
                            if (!"".equals(string2)) {
                                string = XML.getPathRelativeTo(string, string2);
                            }
                            libraryTreeNode.setTarget(string);
                        }
                    }
                }
            }
        });
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.nameLabel.setHorizontalAlignment(11);
        this.typeLabel = new JLabel();
        this.typeLabel.setBorder(BorderFactory.createEmptyBorder(2, 6, 2, 2));
        this.typeLabel.setHorizontalAlignment(11);
        this.htmlLabel = new JLabel();
        this.htmlLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.htmlLabel.setHorizontalAlignment(11);
        this.basePathLabel = new JLabel();
        this.basePathLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.basePathLabel.setHorizontalAlignment(11);
        this.targetLabel = new JLabel();
        this.targetLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.targetLabel.setHorizontalAlignment(11);
        this.labels.add(this.nameLabel);
        this.labels.add(this.htmlLabel);
        this.labels.add(this.basePathLabel);
        this.labels.add(this.targetLabel);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.nameLabel);
        box.add(this.nameField);
        box.add(this.typeLabel);
        box.add(this.typeField);
        this.editorPanel.add(box);
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.htmlLabel);
        box.add(this.htmlField);
        box.add(this.openHTMLButton);
        this.editorPanel.add(box);
        box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 2));
        box.add(this.basePathLabel);
        box.add(this.basePathField);
        box.add(this.openBasePathButton);
        this.editorPanel.add(box);
        this.fileBox = Box.createHorizontalBox();
        this.fileBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.fileBox.add(this.targetLabel);
        this.fileBox.add(this.targetField);
        this.fileBox.add(this.openFileButton);
        this.editorPanel.add(this.fileBox);
        this.metadataFieldListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
                if (libraryTreeNode != null) {
                    EntryField entryField = (EntryField)actionEvent.getSource();
                    String string = entryField.getText().trim();
                    LibraryResource.Metadata metadata = libraryTreeNode.selectedMetadata;
                    String string2 = null;
                    int n = 1;
                    if (entryField == LibraryTreePanel.this.authorField) {
                        string2 = "Author";
                        metadata = libraryTreeNode.record.getMetadata(string2);
                    } else if (entryField == LibraryTreePanel.this.contactField) {
                        string2 = "Contact";
                        metadata = libraryTreeNode.record.getMetadata(string2);
                    } else if (entryField == LibraryTreePanel.this.keywordsField) {
                        string2 = "Keywords";
                        metadata = libraryTreeNode.record.getMetadata(string2);
                    } else if (entryField == LibraryTreePanel.this.keyEditField) {
                        n = 0;
                    }
                    if (metadata != null && string.equals(metadata.getData()[n])) {
                        return;
                    }
                    if (string.length() > 0 && (metadata == null || metadata == LibraryTreePanel.this.emptyMetadata)) {
                        metadata = n == 0 ? new LibraryResource.Metadata(string, null) : new LibraryResource.Metadata(string2, string);
                        libraryTreeNode.record.addMetadata(metadata);
                        LibraryTreePanel.this.metadataModel.dataAdded();
                        if (entryField == LibraryTreePanel.this.keyEditField || entryField == LibraryTreePanel.this.valueEditField) {
                            libraryTreeNode.selectedMetadata = metadata;
                        }
                    } else if (metadata != null) {
                        if ("".equals(string)) {
                            libraryTreeNode.record.removeMetadata(metadata);
                            LibraryTreePanel.this.metadataModel.dataRemoved();
                            if (libraryTreeNode.selectedMetadata == metadata) {
                                libraryTreeNode.selectedMetadata = null;
                            }
                        } else {
                            String[] stringArray = metadata.getData();
                            stringArray[n] = string;
                            LibraryTreePanel.this.metadataModel.dataChanged();
                        }
                    }
                    LibraryTreePanel.this.setChanged();
                    libraryTreeNode.tooltip = null;
                    LibraryTreePanel.this.showInfo(libraryTreeNode);
                }
            }
        };
        this.authorField = new EntryField();
        this.entryFields.add(this.authorField);
        this.authorField.addActionListener(this.metadataFieldListener);
        this.contactField = new EntryField();
        this.entryFields.add(this.contactField);
        this.contactField.addActionListener(this.metadataFieldListener);
        this.keywordsField = new EntryField();
        this.entryFields.add(this.keywordsField);
        this.keywordsField.addActionListener(this.metadataFieldListener);
        this.metadataModel = new MetadataComboBoxModel();
        this.metadataDropdown = new JComboBox(this.metadataModel);
        this.metadataDropdown.setRenderer(new MetadataComboBoxRenderer());
        this.metadataDropdown.setEditor(new MetadataComboBoxEditor());
        this.metadataDropdown.setEditable(true);
        this.authorLabel = new JLabel();
        this.authorLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.authorLabel.setHorizontalAlignment(11);
        this.contactLabel = new JLabel();
        this.contactLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.contactLabel.setHorizontalAlignment(11);
        this.keywordsLabel = new JLabel();
        this.keywordsLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.keywordsLabel.setHorizontalAlignment(11);
        this.metadataLabel = new JLabel();
        this.metadataLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.metadataLabel.setHorizontalAlignment(11);
        this.labels.add(this.authorLabel);
        this.labels.add(this.contactLabel);
        this.labels.add(this.keywordsLabel);
        this.labels.add(this.metadataLabel);
        this.authorBox = Box.createHorizontalBox();
        this.authorBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.authorBox.add(this.authorLabel);
        this.authorBox.add(this.authorField);
        this.contactBox = Box.createHorizontalBox();
        this.contactBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.contactBox.add(this.contactLabel);
        this.contactBox.add(this.contactField);
        this.keywordsBox = Box.createHorizontalBox();
        this.keywordsBox.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 1));
        this.keywordsBox.add(this.keywordsLabel);
        this.keywordsBox.add(this.keywordsField);
        this.metadataBox = Box.createHorizontalBox();
        this.metadataBox.add(this.metadataLabel);
        this.metadataBox.add(this.metadataDropdown);
    }

    protected void refreshGUI() {
        Serializable serializable2;
        this.addCollectionButton.setText(ToolsRes.getString("LibraryTreePanel.Button.AddCollection"));
        this.addResourceButton.setText(ToolsRes.getString("LibraryTreePanel.Button.AddResource"));
        this.copyButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
        this.cutButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Cut"));
        this.pasteButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Paste"));
        this.moveUpButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Up"));
        this.moveDownButton.setText(ToolsRes.getString("LibraryTreePanel.Button.Down"));
        this.metadataButton.setText(this.metadataButton.isSelected() ? ToolsRes.getString("LibraryTreePanel.Button.Metadata.Hide") : ToolsRes.getString("LibraryTreePanel.Button.Metadata.Show"));
        this.nameLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Name"));
        this.typeLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Type"));
        this.htmlLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.HTML"));
        this.basePathLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.BasePath"));
        this.targetLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.TargetFile"));
        this.authorLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Author"));
        this.contactLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Contact"));
        this.keywordsLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Keywords"));
        this.metadataLabel.setText(ToolsRes.getString("LibraryTreePanel.Label.Metadata"));
        this.browser.refreshButton.setEnabled(this.getSelectedNode() != null);
        if (this.getSelectedNode() == this.rootNode) {
            this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Reload"));
        } else {
            this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
        }
        int n = 0;
        int n2 = 0;
        Font font = this.nameLabel.getFont();
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        for (Serializable serializable2 : this.labels) {
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(serializable2.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D.getWidth() + 4);
            n2 = Math.max(n2, (int)rectangle2D.getHeight() + 4);
        }
        n2 = Math.max(n2, 20);
        serializable2 = new Dimension(n, n2);
        for (JLabel jLabel : this.labels) {
            jLabel.setPreferredSize((Dimension)serializable2);
            jLabel.setMinimumSize((Dimension)serializable2);
        }
        this.typeFieldWidth = 0;
        String[] stringArray = LibraryResource.RESOURCE_TYPES;
        int n3 = LibraryResource.RESOURCE_TYPES.length;
        int n4 = 0;
        while (n4 < n3) {
            String string2 = stringArray[n4];
            string2 = ToolsRes.getString("LibraryResource.Type." + string2);
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(string2) + " ", fontRenderContext);
            this.typeFieldWidth = Math.max(this.typeFieldWidth, (int)rectangle2D.getWidth() + 24);
            ++n4;
        }
    }

    protected void enableButtons() {
        LibraryTreeNode libraryTreeNode = this.getSelectedNode();
        boolean bl = libraryTreeNode != null && libraryTreeNode.record instanceof LibraryCollection;
        this.addCollectionButton.setEnabled(bl);
        this.addResourceButton.setEnabled(bl);
        this.copyButton.setEnabled(libraryTreeNode != null);
        this.cutButton.setEnabled(libraryTreeNode != null && libraryTreeNode != this.rootNode);
        this.pasteButton.setEnabled(bl && this.isClipboardPastable());
        boolean bl2 = false;
        boolean bl3 = false;
        if (libraryTreeNode != null && libraryTreeNode.getParent() != null) {
            LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
            int n = libraryTreeNode2.getIndex(libraryTreeNode);
            bl2 = n > 0;
            bl3 = n < libraryTreeNode2.getChildCount() - 1;
        }
        this.moveUpButton.setEnabled(bl2);
        this.moveDownButton.setEnabled(bl3);
    }

    protected void revert() {
        if (this.revertControl != null) {
            this.revertControl = new XMLControlElement(this.revertControl);
            LibraryResource libraryResource = (LibraryResource)this.revertControl.loadObject(null);
            this.isChanged = false;
            this.setRootResource(libraryResource, this.pathToRoot, this.rootNode.isEditable(), this.isXMLPath);
            this.browser.refreshTabTitle(this.pathToRoot, this.rootResource);
        }
    }

    protected void createTree(LibraryTreeNode libraryTreeNode) {
        this.treeModel = new DefaultTreeModel(libraryTreeNode);
        this.tree = new JTree(this.treeModel){

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        if (libraryTreeNode.createChildNodes()) {
            LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getLastChild();
            TreePath treePath = new TreePath(libraryTreeNode2.getPath());
            this.tree.scrollPathToVisible(treePath);
        }
        this.tree.setCellRenderer(new LibraryTreeNodeRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.treeMouseListener);
        this.treeScroller.setViewportView(this.tree);
    }

    protected boolean isClipboardPastable() {
        this.pasteControl = null;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        String string = null;
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {}
        if (string != null) {
            XMLControlElement xMLControlElement = new XMLControlElement();
            xMLControlElement.readXML(string);
            if (LibraryResource.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
                this.pasteControl = xMLControlElement;
                return true;
            }
        }
        return false;
    }

    protected JPopupMenu getPopup(final LibraryTreeNode libraryTreeNode) {
        Serializable serializable;
        this.popup.removeAll();
        if (!this.isEditing()) {
            JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
            this.popup.add(jMenuItem);
            jMenuItem.addActionListener(this.copyAction);
            if ("".equals(this.pathToRoot) && libraryTreeNode.record.getCollectionPath() != null) {
                jMenuItem = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Popup.Item.OpenCollection"));
                this.popup.addSeparator();
                this.popup.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = libraryTreeNode.record.getCollectionPath();
                        LibraryTreePanel.this.browser.loadTab(string, libraryTreeNode.record.treePath);
                    }
                });
            }
            FontSizer.setFonts(this.popup, FontSizer.getLevel());
            return this.popup;
        }
        boolean bl = libraryTreeNode.record instanceof LibraryCollection;
        boolean bl2 = false;
        boolean bl3 = false;
        if (libraryTreeNode.getParent() != null) {
            serializable = (LibraryTreeNode)libraryTreeNode.getParent();
            int n = ((DefaultMutableTreeNode)serializable).getIndex(libraryTreeNode);
            bl2 = n > 0;
            boolean bl4 = bl3 = n < ((DefaultMutableTreeNode)serializable).getChildCount() - 1;
        }
        if (bl) {
            serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.AddResource"));
            this.popup.add((JMenuItem)serializable);
            ((AbstractButton)serializable).addActionListener(this.addResourceAction);
            serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.AddCollection"));
            this.popup.add((JMenuItem)serializable);
            ((AbstractButton)serializable).addActionListener(this.addCollectionAction);
            this.popup.addSeparator();
        }
        serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Copy"));
        this.popup.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(this.copyAction);
        serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Cut"));
        this.popup.add((JMenuItem)serializable);
        ((AbstractButton)serializable).addActionListener(this.cutAction);
        if (bl && this.isClipboardPastable()) {
            serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Paste"));
            this.popup.add((JMenuItem)serializable);
            ((AbstractButton)serializable).addActionListener(this.pasteAction);
        }
        if (bl2 || bl3) {
            this.popup.addSeparator();
            if (bl2) {
                serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Up"));
                this.popup.add((JMenuItem)serializable);
                ((AbstractButton)serializable).addActionListener(this.moveUpAction);
            }
            if (bl3) {
                serializable = new JMenuItem(ToolsRes.getString("LibraryTreePanel.Button.Down"));
                this.popup.add((JMenuItem)serializable);
                ((AbstractButton)serializable).addActionListener(this.moveDownAction);
            }
        }
        FontSizer.setFonts(this.popup, FontSizer.getLevel());
        return this.popup;
    }

    protected boolean insertChildAt(LibraryTreeNode libraryTreeNode, LibraryTreeNode libraryTreeNode2, int n) {
        if (this.tree == null || libraryTreeNode2.getChildCount() < n) {
            return false;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.insertNodeInto(libraryTreeNode, libraryTreeNode2, n);
        return true;
    }

    protected void removeNode(LibraryTreeNode libraryTreeNode) {
        if (this.rootNode == null || libraryTreeNode == this.rootNode) {
            return;
        }
        LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getParent();
        htmlPanesByNode.remove(libraryTreeNode2);
        htmlPanesByNode.remove(libraryTreeNode);
        LibraryCollection libraryCollection = (LibraryCollection)libraryTreeNode2.record;
        libraryCollection.removeResource(libraryTreeNode.record);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
        defaultTreeModel.removeNodeFromParent(libraryTreeNode);
        TreePath treePath = new TreePath(libraryTreeNode2.getPath());
        this.tree.scrollPathToVisible(treePath);
        this.tree.setSelectionPath(treePath);
    }

    protected void setChanged() {
        if (this.ignoreChanges) {
            return;
        }
        this.isChanged = true;
        this.firePropertyChange("collection_edit", null, null);
    }

    protected boolean isChanged() {
        return this.isEditable() && this.isChanged;
    }

    protected String save() {
        Object object;
        if (!this.isXMLPath) {
            return this.browser.saveAs();
        }
        if (this.isEditable()) {
            object = new XMLControlElement(this.rootResource);
            object.write(this.pathToRoot);
            this.isChanged = false;
        }
        object = ResourceLoader.getSearchCacheFile(this.pathToRoot);
        XMLControlElement xMLControlElement = new XMLControlElement(this.rootNode.record);
        xMLControlElement.setValue("real_path", this.pathToRoot);
        xMLControlElement.write(((File)object).getAbsolutePath());
        return this.pathToRoot;
    }

    protected boolean saveChanges(String string) {
        if (!this.isChanged()) {
            return true;
        }
        if (OSPRuntime.applet != null) {
            return true;
        }
        int n = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("LibraryBrowser.Dialog.SaveChanges.Message")) + " \"" + string + "\"?", ToolsRes.getString("LibraryBrowser.Dialog.SaveChanges.Title"), 1, 3);
        if (n == -1 || n == 2) {
            return false;
        }
        if (n == 0) {
            if (this.save() == null) {
                return false;
            }
        } else {
            this.revert();
        }
        return true;
    }

    protected String[] getNextSplit(String string) {
        int n;
        String[] stringArray = string.split(" AND ", 2);
        String[] stringArray2 = string.split(" OR ", 2);
        String[] stringArray3 = string.split(Pattern.quote("("), 2);
        int n2 = stringArray[0].length() <= stringArray2[0].length() ? (stringArray[0].length() <= stringArray3[0].length() ? 0 : 2) : (n = stringArray2[0].length() <= stringArray3[0].length() ? 1 : 2);
        if (n == 2 && stringArray3.length > 1) {
            String[] stringArray4 = this.getParenthesisSplit(stringArray3[1]);
            if (stringArray4.length == 1) {
                return new String[]{stringArray4[0]};
            }
            int n3 = stringArray4[1].indexOf(" AND ");
            int n4 = stringArray4[1].indexOf(" OR ");
            if (n3 == -1 && n4 == -1) {
                return new String[]{stringArray3[1]};
            }
            if (n3 > -1 && (n4 == -1 || n3 < n4)) {
                return new String[]{stringArray4[0], " AND ", stringArray4[1].substring(n3 + " AND ".length())};
            }
            if (n4 > -1 && (n3 == -1 || n4 < n3)) {
                return new String[]{stringArray4[0], " OR ", stringArray4[1].substring(n4 + " OR ".length())};
            }
        }
        switch (n) {
            case 0: {
                if (stringArray.length == 1) {
                    return new String[]{stringArray[0]};
                }
                return new String[]{stringArray[0], " AND ", stringArray[1]};
            }
            case 1: {
                if (stringArray2.length == 1) {
                    return new String[]{stringArray2[0]};
                }
                return new String[]{stringArray2[0], " OR ", stringArray2[1]};
            }
        }
        return new String[]{string};
    }

    protected String[] getParenthesisSplit(String string) {
        String[] stringArray;
        int n = 1;
        int n2 = 1;
        int n3 = string.indexOf("(", n);
        int n4 = string.indexOf(")", n);
        while (n2 > 0) {
            if (n3 > -1 && n3 < n4) {
                ++n2;
                n = n3 + 1;
                n3 = string.indexOf("(", n);
                continue;
            }
            if (n4 > -1) {
                --n2;
                n = n4 + 1;
                n4 = string.indexOf(")", n);
                continue;
            }
            return new String[]{string};
        }
        String string2 = string.substring(0, n - 1);
        String string3 = string.substring(n);
        if (string3.trim().equals("")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string2;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string2;
            stringArray = stringArray3;
            stringArray3[1] = string3;
        }
        return stringArray;
    }

    protected Map<LibraryTreeNode, List<String[]>> applyAND(Map<LibraryTreeNode, List<String[]>> map, Map<LibraryTreeNode, List<String[]>> map2) {
        HashMap<LibraryTreeNode, List<String[]>> hashMap = new HashMap<LibraryTreeNode, List<String[]>>();
        Set<LibraryTreeNode> set = map.keySet();
        for (LibraryTreeNode libraryTreeNode : map2.keySet()) {
            if (!set.contains(libraryTreeNode)) continue;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(map.get(libraryTreeNode));
            arrayList.addAll(map2.get(libraryTreeNode));
            hashMap.put(libraryTreeNode, arrayList);
        }
        return hashMap;
    }

    protected Map<LibraryTreeNode, List<String[]>> applyOR(Map<LibraryTreeNode, List<String[]>> map, Map<LibraryTreeNode, List<String[]>> map2) {
        ArrayList arrayList;
        HashMap<LibraryTreeNode, List<String[]>> hashMap = new HashMap<LibraryTreeNode, List<String[]>>();
        for (LibraryTreeNode libraryTreeNode : map.keySet()) {
            arrayList = new ArrayList();
            arrayList.addAll(map.get(libraryTreeNode));
            hashMap.put(libraryTreeNode, arrayList);
        }
        for (LibraryTreeNode libraryTreeNode : map2.keySet()) {
            if (hashMap.keySet().contains(libraryTreeNode)) {
                ((List)hashMap.get(libraryTreeNode)).addAll((Collection)map2.get(libraryTreeNode));
                continue;
            }
            arrayList = new ArrayList();
            arrayList.addAll(map2.get(libraryTreeNode));
            hashMap.put(libraryTreeNode, arrayList);
        }
        return hashMap;
    }

    protected String getHTMLBody(String string) {
        String string2 = ResourceLoader.getString(string);
        if (string2 != null) {
            String[] stringArray = string2.split("<body>");
            stringArray = stringArray[1].split("</body>");
            return stringArray[0];
        }
        return null;
    }

    protected void refreshEntryFields() {
        for (EntryField entryField : this.entryFields) {
            if (entryField.getBackground() != Color.yellow) continue;
            entryField.processEntry();
        }
    }

    protected static JFileChooser getFileChooser() {
        if (chooser == null) {
            String string = LibraryBrowser.getBrowser().library.chooserDir;
            chooser = string == null ? new JFileChooser() : new JFileChooser(new File(string));
            htmlFilter = new FileFilter(){

                public boolean accept(File file) {
                    String[] stringArray;
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = XML.getExtension(file.getName());
                    String[] stringArray2 = stringArray = new String[]{"html", "htm"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String string2 = stringArray2[n2];
                        if (string2.equals(string)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }

                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.HTMLFileFilter.Description");
                }
            };
            folderFilter = new FileFilter(){

                public boolean accept(File file) {
                    return file != null && file.isDirectory();
                }

                public String getDescription() {
                    return ToolsRes.getString("LibraryTreePanel.FolderFileFilter.Description");
                }
            };
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    protected static class EntryField
    extends JTextField {
        static Font font = new JTextField().getFont();
        static DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                EntryField entryField = (EntryField)documentEvent.getDocument().getProperty("parent");
                entryField.setBackground(Color.yellow);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                EntryField entryField = (EntryField)documentEvent.getDocument().getProperty("parent");
                entryField.setBackground(Color.yellow);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
        static FocusListener focusListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                EntryField entryField = (EntryField)focusEvent.getSource();
                if (entryField.getDefaultText() != null) {
                    entryField.setText(null);
                    entryField.setFont(entryField.getDefaultFont());
                    entryField.setForeground(defaultForeground);
                }
                entryField.selectAll();
                entryField.setBackground(Color.white);
            }

            public void focusLost(FocusEvent focusEvent) {
                EntryField entryField = (EntryField)focusEvent.getSource();
                entryField.processEntry();
            }
        };
        static ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryField entryField = (EntryField)actionEvent.getSource();
                entryField.setBackground(Color.white);
            }
        };

        EntryField() {
            this.getDocument().putProperty("parent", this);
            this.addFocusListener(focusListener);
            this.addActionListener(actionListener);
            this.getDocument().addDocumentListener(documentListener);
        }

        protected String getDefaultText() {
            return null;
        }

        protected Font getEmptyFont() {
            return this.getFont();
        }

        protected Font getDefaultFont() {
            return this.getFont();
        }

        protected void processEntry() {
            boolean bl;
            boolean bl2 = bl = this.getBackground() == Color.yellow;
            if (this.getDefaultText() != null && "".equals(this.getText())) {
                this.setText(this.getDefaultText());
                this.setForeground(Color.gray);
                this.setFont(this.getEmptyFont());
            }
            this.setBackground(Color.white);
            if (bl) {
                this.fireActionPerformed();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HTMLDisplayer
    extends SwingWorker<HTMLPane, Void> {
        LibraryTreeNode node;
        boolean hasNewChildren = false;

        HTMLDisplayer(LibraryTreeNode libraryTreeNode) {
            this.node = libraryTreeNode;
        }

        @Override
        public HTMLPane doInBackground() {
            HTMLPane hTMLPane = htmlPanesByNode.get(this.node);
            if (hTMLPane == null) {
                Object object;
                URL uRL = this.node.getHTMLURL();
                if (uRL != null) {
                    hTMLPane = htmlPanesByURL.get(uRL);
                    if (hTMLPane == null) {
                        hTMLPane = new HTMLPane();
                        htmlPanesByURL.put(uRL, hTMLPane);
                        hTMLPane.setText("<h2>" + this.node + "</h2>");
                        try {
                            hTMLPane.setPage(uRL);
                        }
                        catch (Exception exception) {}
                    } else if (!uRL.equals(hTMLPane.getPage())) {
                        try {
                            hTMLPane.getDocument().putProperty("stream", null);
                            hTMLPane.setPage(uRL);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    hTMLPane = new HTMLPane();
                    object = this.node.getHTMLString();
                    hTMLPane.setText((String)object);
                }
                if (hTMLPane.getDocument() instanceof HTMLDocument) {
                    object = (HTMLDocument)hTMLPane.getDocument();
                    ((HTMLDocument)object).getStyleSheet().addRule(LibraryResource.getBodyStyle());
                    ((HTMLDocument)object).getStyleSheet().addRule(LibraryResource.getH1Style());
                    ((HTMLDocument)object).getStyleSheet().addRule(LibraryResource.getH2Style());
                }
                htmlPanesByNode.put(this.node, hTMLPane);
                hTMLPane.setCaretPosition(0);
            }
            return hTMLPane;
        }

        @Override
        protected void done() {
            HTMLPane hTMLPane = null;
            try {
                hTMLPane = (HTMLPane)this.get();
            }
            catch (Exception exception) {}
            if (hTMLPane != null && this.node == LibraryTreePanel.this.getSelectedNode()) {
                LibraryTreePanel.this.htmlScroller.setViewportView(hTMLPane);
                if (this.node == LibraryTreePanel.this.rootNode) {
                    LibraryTreePanel.this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Reload"));
                } else {
                    LibraryTreePanel.this.browser.refreshButton.setToolTipText(ToolsRes.getString("LibraryBrowser.Tooltip.Refresh"));
                }
            }
        }
    }

    protected static class HTMLPane
    extends JEditorPane {
        public HTMLPane() {
            this.setEditable(false);
            this.setFocusable(false);
            this.setContentType("text/html");
            this.addHyperlinkListener(hyperlinkListener);
            HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
            hTMLDocument.getStyleSheet().addRule(LibraryResource.getBodyStyle());
            hTMLDocument.getStyleSheet().addRule(LibraryResource.getH1Style());
            hTMLDocument.getStyleSheet().addRule(LibraryResource.getH2Style());
        }

        public void paintComponent(Graphics graphics) {
            if (OSPRuntime.antiAliasText.booleanValue()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paintComponent(graphics);
        }
    }

    protected class LibraryTreeNodeRenderer
    extends DefaultTreeCellRenderer {
        protected LibraryTreeNodeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)object;
            Icon icon = libraryTreeNode.record.getIcon();
            Color color = this.getForeground();
            if (libraryTreeNode.record instanceof LibraryCollection) {
                Icon icon2 = icon = bl2 ? this.getOpenIcon() : this.getClosedIcon();
                if (libraryTreeNode.getTarget() != null) {
                    color = Color.red;
                }
            }
            this.setToolTipText(libraryTreeNode.getToolTip());
            this.setIcon(icon != null ? icon : LibraryResource.unknownIcon);
            this.setForeground(color);
            return this;
        }
    }

    protected class MetadataComboBoxEditor
    extends Box
    implements ComboBoxEditor {
        JLabel spacer;
        LibraryResource.Metadata metadata;

        MetadataComboBoxEditor() {
            super(0);
            LibraryTreePanel.this.keyEditField = new MetadataEditField(LibraryTreePanel.this, keyFieldWidth){

                protected String getDefaultText() {
                    return MetadataComboBoxEditor.this.metadata == ((MetadataComboBoxEditor)MetadataComboBoxEditor.this).LibraryTreePanel.this.emptyMetadata ? ToolsRes.getString("LibraryTreePanel.Metadata.Name") : null;
                }

                protected Font getEmptyFont() {
                    return font.deriveFont(3);
                }

                protected Font getDefaultFont() {
                    return font.deriveFont(1);
                }
            };
            LibraryTreePanel.this.entryFields.add(LibraryTreePanel.this.keyEditField);
            LibraryTreePanel.this.keyEditField.setHorizontalAlignment(4);
            LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
            LibraryTreePanel.this.valueEditField = new MetadataEditField(LibraryTreePanel.this, 0){

                protected String getDefaultText() {
                    return MetadataComboBoxEditor.this.metadata == ((MetadataComboBoxEditor)MetadataComboBoxEditor.this).LibraryTreePanel.this.emptyMetadata ? ToolsRes.getString("LibraryTreePanel.Metadata.Value") : null;
                }

                protected Font getEmptyFont() {
                    return font.deriveFont(2);
                }

                protected Font getDefaultFont() {
                    return font.deriveFont(0);
                }
            };
            LibraryTreePanel.this.entryFields.add(LibraryTreePanel.this.valueEditField);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(LibraryTreePanel.this.keyEditField.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 1));
            LibraryTreePanel.this.keyEditField.setBorder(compoundBorder);
            LibraryTreePanel.this.valueEditField.setBorder(compoundBorder);
            this.spacer = new JLabel();
            this.spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add(LibraryTreePanel.this.keyEditField);
            this.add(this.spacer);
            this.add(LibraryTreePanel.this.valueEditField);
        }

        public Component getEditorComponent() {
            return this;
        }

        public void setItem(Object object) {
            boolean bl;
            if (object == null) {
                return;
            }
            this.metadata = (LibraryResource.Metadata)object;
            boolean bl2 = bl = this.metadata == LibraryTreePanel.this.emptyMetadata;
            if (bl) {
                LibraryTreePanel.this.keyEditField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Name"));
                LibraryTreePanel.this.valueEditField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Value"));
                LibraryTreePanel.this.keyEditField.setForeground(Color.gray);
                LibraryTreePanel.this.valueEditField.setForeground(Color.gray);
                LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getEmptyFont());
                LibraryTreePanel.this.valueEditField.setFont(LibraryTreePanel.this.valueEditField.getEmptyFont());
            } else {
                LibraryTreePanel.this.keyEditField.setText(this.metadata.getData()[0]);
                LibraryTreePanel.this.keyEditField.setCaretPosition(0);
                LibraryTreePanel.this.valueEditField.setText(this.metadata.getData()[1]);
                LibraryTreePanel.this.valueEditField.setCaretPosition(0);
                LibraryTreePanel.this.keyEditField.setForeground(defaultForeground);
                LibraryTreePanel.this.valueEditField.setForeground(defaultForeground);
                LibraryTreePanel.this.keyEditField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
                LibraryTreePanel.this.valueEditField.setFont(LibraryTreePanel.this.valueEditField.getDefaultFont());
            }
            LibraryTreePanel.this.keyEditField.setBackground(Color.white);
            LibraryTreePanel.this.valueEditField.setBackground(Color.white);
        }

        public Object getItem() {
            return this.metadata;
        }

        public void selectAll() {
        }

        public void addActionListener(ActionListener actionListener) {
        }

        public void removeActionListener(ActionListener actionListener) {
        }
    }

    protected class MetadataComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        protected MetadataComboBoxModel() {
        }

        public int getSize() {
            LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
            if (libraryTreeNode == null) {
                return 0;
            }
            TreeSet<LibraryResource.Metadata> treeSet = libraryTreeNode.record.getMetadata();
            if (treeSet == null) {
                return 1;
            }
            return treeSet.size() + 1;
        }

        public Object getElementAt(int n) {
            LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
            if (libraryTreeNode == null) {
                return 0;
            }
            TreeSet<LibraryResource.Metadata> treeSet = libraryTreeNode.record.getMetadata();
            if (treeSet == null) {
                return LibraryTreePanel.this.emptyMetadata;
            }
            int n2 = 0;
            for (LibraryResource.Metadata metadata : treeSet) {
                if (n == n2) {
                    return metadata;
                }
                ++n2;
            }
            return LibraryTreePanel.this.emptyMetadata;
        }

        public void setSelectedItem(Object object) {
            LibraryResource.Metadata metadata;
            if (object == null || !(object instanceof LibraryResource.Metadata)) {
                return;
            }
            LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
            if (libraryTreeNode == null) {
                return;
            }
            libraryTreeNode.selectedMetadata = metadata = (LibraryResource.Metadata)object;
        }

        public Object getSelectedItem() {
            LibraryTreeNode libraryTreeNode = LibraryTreePanel.this.getSelectedNode();
            if (libraryTreeNode == null) {
                return null;
            }
            LibraryResource.Metadata metadata = libraryTreeNode.selectedMetadata;
            return metadata;
        }

        void dataChanged() {
            if (this.getSize() > 0) {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            }
        }

        void dataAdded() {
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize() - 1);
            }
        }

        void dataRemoved() {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
            }
        }
    }

    protected class MetadataComboBoxRenderer
    extends Box
    implements ListCellRenderer {
        JTextField keyField;
        JTextField valueField;
        JLabel spacer;

        public MetadataComboBoxRenderer() {
            super(0);
            this.keyField = new JTextField(){

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getPreferredSize() {
                    return ((MetadataComboBoxRenderer)MetadataComboBoxRenderer.this).LibraryTreePanel.this.keyEditField.getPreferredSize();
                }
            };
            this.keyField.setHorizontalAlignment(4);
            this.keyField.setFont(this.keyField.getFont().deriveFont(1));
            this.valueField = new JTextField(){

                public Dimension getMaximumSize() {
                    return ((MetadataComboBoxRenderer)MetadataComboBoxRenderer.this).LibraryTreePanel.this.valueEditField.getMaximumSize();
                }

                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }
            };
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(this.keyField.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 1));
            this.keyField.setBorder(compoundBorder);
            this.valueField.setBorder(compoundBorder);
            this.spacer = new JLabel();
            this.spacer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add(this.keyField);
            this.add(this.spacer);
            this.add(this.valueField);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            boolean bl3 = false;
            if (object != null && object instanceof LibraryResource.Metadata) {
                LibraryResource.Metadata metadata = (LibraryResource.Metadata)object;
                boolean bl4 = bl3 = metadata == LibraryTreePanel.this.emptyMetadata;
                if (bl3) {
                    this.keyField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Name"));
                    this.valueField.setText(ToolsRes.getString("LibraryTreePanel.Metadata.Value"));
                    this.keyField.setFont(LibraryTreePanel.this.keyEditField.getEmptyFont());
                    this.valueField.setFont(LibraryTreePanel.this.valueEditField.getEmptyFont());
                } else {
                    this.keyField.setText(metadata.getData()[0]);
                    this.valueField.setText(metadata.getData()[1]);
                    this.keyField.setFont(LibraryTreePanel.this.keyEditField.getDefaultFont());
                    this.valueField.setFont(LibraryTreePanel.this.valueEditField.getDefaultFont());
                }
            }
            if (bl) {
                this.keyField.setBackground(jList.getSelectionBackground());
                this.keyField.setForeground(bl3 ? Color.gray : jList.getSelectionForeground());
                this.valueField.setBackground(jList.getSelectionBackground());
                this.valueField.setForeground(bl3 ? Color.gray : jList.getSelectionForeground());
            } else {
                this.keyField.setBackground(jList.getBackground());
                this.keyField.setForeground(bl3 ? Color.gray : jList.getForeground());
                this.valueField.setBackground(jList.getBackground());
                this.valueField.setForeground(bl3 ? Color.gray : jList.getForeground());
            }
            return this;
        }
    }

    protected class MetadataEditField
    extends EntryField {
        int preferredWidth;

        MetadataEditField(int n) {
            this.preferredWidth = n;
            this.addActionListener(LibraryTreePanel.this.metadataFieldListener);
        }

        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            dimension.height = this.getPreferredSize().height;
            if (this.preferredWidth > 0) {
                dimension.width = this.preferredWidth;
            }
            return dimension;
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            if (this.preferredWidth > 0) {
                dimension.width = this.preferredWidth;
            }
            return dimension;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.preferredWidth > 0) {
                dimension.width = this.preferredWidth;
            }
            return dimension;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MetadataLoader
    extends SwingWorker<Void, Void> {
        boolean saveToCache;
        boolean canceled = false;
        List<String> treePath;

        MetadataLoader(boolean bl, List<String> list) {
            this.saveToCache = bl;
            this.treePath = list;
        }

        void cancel() {
            this.canceled = true;
        }

        @Override
        public Void doInBackground() {
            if (this.saveToCache) {
                final ArrayList<NodeLoader> arrayList = new ArrayList<NodeLoader>();
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        NodeLoader nodeLoader = (NodeLoader)propertyChangeEvent.getSource();
                        if (nodeLoader.isDone()) {
                            if (MetadataLoader.this.canceled) {
                                return;
                            }
                            int n = arrayList.indexOf(nodeLoader);
                            if (n + 1 < arrayList.size()) {
                                nodeLoader = (NodeLoader)arrayList.get(n + 1);
                                nodeLoader.execute();
                            } else {
                                MetadataLoader.this.canceled = true;
                                File file = ResourceLoader.getSearchCacheFile(((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.pathToRoot);
                                XMLControlElement xMLControlElement = new XMLControlElement(((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.rootNode.record);
                                xMLControlElement.setValue("real_path", ((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.pathToRoot);
                                xMLControlElement.write(file.getAbsolutePath());
                                LibraryTreePanel.this.setSelectionPath(MetadataLoader.this.treePath);
                                Enumeration<TreeNode> enumeration = ((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.rootNode.preorderEnumeration();
                                while (enumeration.hasMoreElements()) {
                                    LibraryTreeNode libraryTreeNode = (LibraryTreeNode)enumeration.nextElement();
                                    if (!(libraryTreeNode.record instanceof LibraryCollection)) continue;
                                    libraryTreeNode.record.setDescription(null);
                                    htmlPanesByNode.remove(libraryTreeNode);
                                }
                                if (((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.browser.libraryManager != null) {
                                    ((MetadataLoader)MetadataLoader.this).LibraryTreePanel.this.browser.libraryManager.refreshSearchTab();
                                }
                                LibraryTreePanel.this.showInfo(LibraryTreePanel.this.getSelectedNode());
                            }
                        }
                    }
                };
                Enumeration<TreeNode> enumeration = LibraryTreePanel.this.rootNode.preorderEnumeration();
                while (enumeration.hasMoreElements()) {
                    LibraryTreeNode libraryTreeNode = (LibraryTreeNode)enumeration.nextElement();
                    NodeLoader nodeLoader = new NodeLoader(libraryTreeNode);
                    arrayList.add(nodeLoader);
                    nodeLoader.addPropertyChangeListener(propertyChangeListener);
                }
                ((NodeLoader)arrayList.get(0)).execute();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeLoader
    extends SwingWorker<Void, Void> {
        LibraryTreeNode node;
        boolean hasNewChildren = false;

        NodeLoader(LibraryTreeNode libraryTreeNode) {
            this.node = libraryTreeNode;
        }

        @Override
        public Void doInBackground() {
            Serializable serializable;
            String string;
            boolean bl;
            String string2 = this.node.getHTMLPath();
            String string3 = this.node.getAbsoluteTarget();
            boolean bl2 = bl = string3 != null && (string3.toLowerCase().endsWith(".zip") || string3.toLowerCase().endsWith(".trz"));
            if (string2 == null && bl) {
                string = "." + XML.getExtension(string3);
                serializable = this.node.getTargetURL();
                String string4 = ((URL)serializable).toExternalForm();
                String string5 = XML.getName(string4);
                if (this.node.getName().equals(string5)) {
                    String string6;
                    string5 = XML.stripExtension(string5);
                    Set<String> set = ResourceLoader.getZipContents(string4);
                    String string7 = null;
                    for (String string8 : set) {
                        string6 = XML.stripExtension(XML.getName(string8));
                        if (!string8.toLowerCase().contains(".htm") || !string6.equals(String.valueOf(string5) + "_info")) continue;
                        string7 = string8;
                    }
                    if (string7 == null) {
                        for (String string8 : set) {
                            if (!"trk".equals(XML.getExtension(string8))) continue;
                            string6 = XML.stripExtension(XML.getName(string8));
                            for (String string9 : set) {
                                String string10 = XML.stripExtension(XML.getName(string9));
                                if (!string9.toLowerCase().contains(".htm") || !string10.equals(String.valueOf(string6) + "_info")) continue;
                                string7 = string9;
                            }
                        }
                    }
                    if (string7 != null) {
                        String string8;
                        string2 = String.valueOf(string4) + "!/" + string7;
                        string8 = ResourceLoader.getHTMLCode(string2);
                        String string11 = LibraryBrowser.getRedirectFromHTMLCode(string8);
                        if (string11 != null) {
                            this.node.record.setHTMLPath(string11);
                            this.node.metadataSource = String.valueOf(string5) + string + "!/" + string7;
                        } else {
                            this.node.record.setHTMLPath(String.valueOf(string5) + string + "!/" + string7);
                        }
                        string6 = ResourceLoader.getTitleFromHTMLCode(string8);
                        if (string6 != null) {
                            this.node.record.setName(string6);
                        }
                    }
                }
            }
            string = this.node.record.getProperty("reload_url");
            if (string3 != null && string3.contains("www.compadre.org")) {
                if (this.node.record instanceof LibraryCollection) {
                    this.hasNewChildren = LibraryComPADRE.loadResources(this.node);
                } else if ("".equals(this.node.record.getDescription()) && string != null) {
                    LibraryComPADRE.reloadResource(this.node, string);
                }
            }
            if (string2 == null) {
                if (string == null) {
                    this.node.record.setDescription(null);
                }
            } else {
                serializable = ResourceLoader.getOSPCacheFile(string2);
                boolean bl3 = ((File)serializable).exists();
                boolean bl4 = string2.contains("!/");
                if (!bl3 && bl4) {
                    serializable = ResourceLoader.copyHTMLToOSPCache(string2);
                }
            }
            htmlPanesByNode.remove(this.node);
            LibraryTreeNode.htmlURLs.remove(string2);
            this.node.getMetadata();
            return null;
        }

        @Override
        protected void done() {
            htmlPanesByNode.remove(this.node);
            htmlPanesByURL.remove(this.node.getHTMLURL());
            if (this.hasNewChildren) {
                this.node.createChildNodes();
                LibraryTreePanel.this.treeModel.nodeStructureChanged(this.node);
            } else {
                LibraryTreePanel.this.treeModel.nodeChanged(this.node);
            }
            if (this.node == LibraryTreePanel.this.getSelectedNode()) {
                LibraryTreePanel.this.showInfo(this.node);
            }
            if (this.node == LibraryTreePanel.this.rootNode) {
                LibraryTreePanel.this.browser.refreshTabTitle(LibraryTreePanel.this.pathToRoot, LibraryTreePanel.this.rootResource);
            }
        }
    }
}

