/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultiLineToolTipUI
extends BasicToolTipUI {
    private static MultiLineToolTipUI sharedInstance = new MultiLineToolTipUI();
    private static JTextArea textArea;
    private CellRendererPane rendererPane;

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    protected MultiLineToolTipUI() {
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.rendererPane = new CellRendererPane();
        jComponent.add(this.rendererPane);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.remove(this.rendererPane);
        this.rendererPane = null;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        textArea.setBackground(jComponent.getBackground());
        this.rendererPane.paintComponent(graphics, textArea, jComponent, 1, 1, dimension.width - 1, dimension.height - 1, true);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            return new Dimension(0, 0);
        }
        textArea = new JTextArea(string);
        textArea.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.rendererPane.removeAll();
        this.rendererPane.add(textArea);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(false);
        Dimension dimension = textArea.getPreferredSize();
        dimension.height += 2;
        dimension.width += 2;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }
}

