/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.preferences;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class StatisticsDetailsDialog
extends PaintImmediateDialog {
    private static final String TITLE = PhetCommonResources.getString("Common.statistics.details.title");
    private static final String DESCRIPTION = PhetCommonResources.getString("Common.statistics.details.description");
    private static final String CLOSE_BUTTON = PhetCommonResources.getString("Common.choice.close");

    public StatisticsDetailsDialog(Frame frame, SessionMessage sessionMessage) {
        super(frame);
        this.init(sessionMessage);
    }

    public StatisticsDetailsDialog(Dialog dialog, SessionMessage sessionMessage) {
        super(dialog);
        this.init(sessionMessage);
    }

    private void init(SessionMessage sessionMessage) {
        this.setTitle(TITLE);
        this.setModal(true);
        this.setResizable(true);
        JComponent jComponent = this.createDescription();
        JComponent jComponent2 = this.createReport(sessionMessage);
        JPanel jPanel = this.createButtonPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.add((Component)jComponent, "North");
        jPanel2.add((Component)jComponent2, "Center");
        jPanel2.add((Component)jPanel, "South");
        jPanel2.setPreferredSize(new Dimension(450, jPanel2.getPreferredSize().height));
        this.setContentPane(jPanel2);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    protected JComponent createDescription() {
        return new JLabel(DESCRIPTION);
    }

    protected JComponent createReport(SessionMessage sessionMessage) {
        JTextArea jTextArea = new JTextArea("");
        String string = sessionMessage.toHumanReadable();
        if (string != null) {
            jTextArea.setText(string);
        }
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width + 30, 200));
        jTextArea.setCaretPosition(0);
        return jScrollPane;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(CLOSE_BUTTON);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatisticsDetailsDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }
}

