/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.menu;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.ModuleEvent;
import edu.colorado.phet.common.phetcommon.application.ModuleObserver;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJCheckBoxMenuItem;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJMenu;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJMenuItem;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingLogMenuItem;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.updates.ManualUpdatesManager;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;

public class HelpMenu
extends SimSharingJMenu
implements ModuleObserver {
    private final JMenuItem onscreenHelp;

    public HelpMenu(final PhetApplication phetApplication, PhetFrame phetFrame) {
        super(UserComponents.helpMenu, PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.Title"));
        this.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.TitleMnemonic").charAt(0));
        phetApplication.addModuleObserver(this);
        this.onscreenHelp = new SimSharingJCheckBoxMenuItem(UserComponents.helpMenuItem, PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.Help"));
        this.onscreenHelp.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.HelpMnemonic").charAt(0));
        this.onscreenHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetApplication.getActiveModule().setHelpEnabled(HelpMenu.this.onscreenHelp.isSelected());
            }
        });
        this.onscreenHelp.setEnabled(phetApplication.getActiveModule() != null && phetApplication.getActiveModule().hasHelp());
        this.add(this.onscreenHelp);
        final SimSharingJMenuItem simSharingJMenuItem = new SimSharingJMenuItem(UserComponents.megaHelpMenuItem, PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.MegaHelp"));
        simSharingJMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.MegaHelpMnemonic").charAt(0));
        simSharingJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (phetApplication.getActiveModule().hasMegaHelp()) {
                    phetApplication.getActiveModule().showMegaHelp();
                } else {
                    PhetOptionPane.showMessageDialog(PhetApplication.getInstance().getPhetFrame(), "No MegaHelp available for this module.");
                }
            }
        });
        phetApplication.addModuleObserver(new ModuleObserver(){

            public void moduleAdded(ModuleEvent moduleEvent) {
            }

            public void activeModuleChanged(ModuleEvent moduleEvent) {
                simSharingJMenuItem.setVisible(moduleEvent.getModule().hasMegaHelp());
            }

            public void moduleRemoved(ModuleEvent moduleEvent) {
            }
        });
        simSharingJMenuItem.setVisible(phetApplication.getActiveModule() != null && phetApplication.getActiveModule().hasMegaHelp());
        this.add(simSharingJMenuItem);
        if (SimSharingManager.getInstance().isEnabled()) {
            this.addSeparator();
            this.add(new SimSharingLogMenuItem(phetFrame));
        }
        this.addSeparator();
        if (phetApplication.getSimInfo().isUpdatesFeatureIncluded()) {
            this.add(new CheckForSimUpdateMenuItem());
        }
        SimSharingJMenuItem simSharingJMenuItem2 = new SimSharingJMenuItem(UserComponents.aboutMenuItem, PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.About"));
        simSharingJMenuItem2.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.HelpMenu.AboutMnemonic").charAt(0));
        simSharingJMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetApplication.showAboutDialog();
            }
        });
        this.add(simSharingJMenuItem2);
    }

    public void setHelpSelected(boolean bl) {
        this.onscreenHelp.setSelected(bl);
    }

    public void moduleAdded(ModuleEvent moduleEvent) {
    }

    public void activeModuleChanged(ModuleEvent moduleEvent) {
        Module module = moduleEvent.getModule();
        if (module != null) {
            this.onscreenHelp.setEnabled(module.hasHelp());
            this.onscreenHelp.setSelected(module.isHelpEnabled());
        }
    }

    public void moduleRemoved(ModuleEvent moduleEvent) {
    }

    private class CheckForSimUpdateMenuItem
    extends SimSharingJMenuItem {
        private CheckForSimUpdateMenuItem() {
            super(UserComponents.checkForSimulationUpdateMenuItem, PhetCommonResources.getInstance().getLocalizedString("Common.updates.checkForSimUpdate"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ManualUpdatesManager.getInstance().checkForSimUpdates();
                }
            });
        }
    }
}

