/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.menu;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.preferences.PreferencesDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJMenu;
import edu.colorado.phet.common.phetcommon.simsharing.components.SimSharingJMenuItem;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PhetFileMenu
extends SimSharingJMenu {
    public PhetFileMenu(final PhetFrame phetFrame, ISimInfo iSimInfo) {
        super(UserComponents.fileMenu, PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Title"));
        this.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.TitleMnemonic").charAt(0));
        if (iSimInfo.isPreferencesEnabled()) {
            this.addPreferencesMenuItem(phetFrame, iSimInfo);
            this.addSeparator();
        }
        SimSharingJMenuItem simSharingJMenuItem = new SimSharingJMenuItem(UserComponentChain.chain(UserComponents.fileMenu, UserComponents.exitMenuItem), PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Exit"));
        simSharingJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetFrame.getApplication().exit();
            }
        });
        simSharingJMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.ExitMnemonic").charAt(0));
        this.add(simSharingJMenuItem);
    }

    private void addPreferencesMenuItem(final PhetFrame phetFrame, final ISimInfo iSimInfo) {
        SimSharingJMenuItem simSharingJMenuItem = new SimSharingJMenuItem(UserComponentChain.chain(UserComponents.fileMenu, UserComponents.preferencesMenuItem), PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Preferences"));
        simSharingJMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PreferencesDialog(phetFrame, SessionMessage.getInstance(), PhetPreferences.getInstance(), iSimInfo.isStatisticsFeatureIncluded(), iSimInfo.isUpdatesFeatureIncluded(), iSimInfo.isDev()).setVisible(true);
            }
        });
        simSharingJMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.PreferencesMnemonic").charAt(0));
        this.add(simSharingJMenuItem);
    }
}

