/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasLookAndFeel;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.view.WiggleMeGraphic;
import java.awt.Color;
import java.awt.geom.Point2D;

public class GasPropertiesApplication
extends PhetApplication {
    public GasPropertiesApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        IdealGasClock idealGasClock = new IdealGasClock(40, 0.1f);
        final IdealGasModule idealGasModule = new IdealGasModule(idealGasClock);
        Module[] moduleArray = new Module[]{idealGasModule};
        this.setModules(moduleArray);
        final WiggleMeGraphic wiggleMeGraphic = new WiggleMeGraphic(idealGasModule.getApparatusPanel(), new Point2D.Double(510.0, 70.0), idealGasModule.getModel());
        wiggleMeGraphic.start();
        idealGasModule.addGraphic(wiggleMeGraphic, 40.0);
        idealGasModule.getPump().addObserver(new SimpleObserver(){

            public void update() {
                if (wiggleMeGraphic != null) {
                    wiggleMeGraphic.kill();
                    idealGasModule.getApparatusPanel().removeGraphic(wiggleMeGraphic);
                    idealGasModule.getPump().removeObserver(this);
                }
            }
        });
    }

    protected void parseArgs(String[] stringArray) {
        super.parseArgs(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("-B")) continue;
            PhetGraphicsModule[] phetGraphicsModuleArray = (PhetGraphicsModule[])this.getModules();
            for (int j = 0; j < phetGraphicsModuleArray.length; ++j) {
                ApparatusPanel apparatusPanel = phetGraphicsModuleArray[j].getApparatusPanel();
                apparatusPanel.setBackground(Color.black);
                apparatusPanel.paintImmediately(apparatusPanel.getBounds());
            }
        }
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new GasPropertiesApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "ideal-gas", "gas-properties");
        phetApplicationConfig.setLookAndFeel(new IdealGasLookAndFeel());
        phetApplicationConfig.setFrameSetup(IdealGasConfig.FRAME_SETUP);
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }
}

