/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SphereHotAirBalloonContactDetector;
import edu.colorado.phet.idealgas.collision.SphereSphereCollision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.HollowSphere;
import edu.colorado.phet.idealgas.model.IdealGasModel;

public class SphereHotAirBalloonExpert
implements CollisionExpert {
    private ContactDetector detector = new SphereHotAirBalloonContactDetector();
    private IdealGasModel model;
    private double dt;

    public SphereHotAirBalloonExpert(IdealGasModel idealGasModel, double d) {
        this.model = idealGasModel;
        this.dt = d;
    }

    public boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        if (this.detector.applies(collidableBody, collidableBody2) && this.detector.areInContact(collidableBody, collidableBody2)) {
            SphereSphereCollision sphereSphereCollision = new SphereSphereCollision((HollowSphere)collidableBody, (SphericalBody)collidableBody2);
            sphereSphereCollision.collide();
            bl = true;
        }
        return bl;
    }
}

