/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.collision.WallDescriptor;
import edu.colorado.phet.idealgas.collision.WallFixupStrategy;

public class VerticalWallFixupStrategy
implements WallFixupStrategy {
    public void fixup(Wall wall, SphericalBody sphericalBody) {
        WallDescriptor wallDescriptor = new WallDescriptor(wall, sphericalBody.getRadius());
        double d = wallDescriptor.AB.ptLineDistSq(sphericalBody.getPosition());
        double d2 = wallDescriptor.BC.ptLineDistSq(sphericalBody.getPosition());
        double d3 = wallDescriptor.CD.ptLineDistSq(sphericalBody.getPosition());
        double d4 = wallDescriptor.AD.ptLineDistSq(sphericalBody.getPosition());
        if (d2 < d4) {
            sphericalBody.setPosition(wallDescriptor.BC.getX1(), sphericalBody.getPosition().getY());
            sphericalBody.setVelocity(Math.abs(sphericalBody.getVelocity().getX()), sphericalBody.getVelocity().getY());
        } else {
            sphericalBody.setPosition(wallDescriptor.AD.getX1(), sphericalBody.getPosition().getY());
            sphericalBody.setVelocity(-Math.abs(sphericalBody.getVelocity().getX()), sphericalBody.getVelocity().getY());
        }
    }
}

