/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.VerticalBarrier;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.PChemModel;
import edu.colorado.phet.idealgas.model.ParticleCounter;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.Box2DGraphic;
import edu.colorado.phet.idealgas.view.HeavySpeciesGraphic;
import edu.colorado.phet.idealgas.view.LightSpeciesGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AdvancedModule
extends IdealGasModule {
    public static final Color COLOR_B = new Color(252, 65, 40);
    public static final Color COLOR_A = new Color(0, 150, 0);
    private static Font readoutFont = new PhetFont(1, 12);
    protected VerticalBarrier verticalWall;
    private ParticleCounter leftRegionParticleCounter;
    private ParticleCounter rightRegionParticleCounter;

    public AdvancedModule(IdealGasClock idealGasClock, String string, PChemModel pChemModel) {
        super(idealGasClock, string, pChemModel);
        this.init();
    }

    private void init() {
        this.setStopwatchEnabled(true);
        this.setPressureGaugeVisible(false);
        this.getBox().setMultipleSlicesEnabled(false);
        Box2DGraphic box2DGraphic = this.getBoxGraphic();
        box2DGraphic.setIgnoreMouse(true);
        box2DGraphic.removeAllMouseInputListeners();
        LightSpecies.setMoleculeMass(HeavySpecies.getMoleculeMass());
        LightSpecies.setMoleculeRadius(HeavySpecies.getMoleculeRadius());
        HeavySpeciesGraphic.setColor(COLOR_A);
        LightSpeciesGraphic.setColor(COLOR_B);
        Color color = new Color(120, 120, 120);
        this.getBoxGraphic().setWallColor(color);
        this.getBoxDoorGraphic().setColor(color);
    }

    protected void addParticleCounters(String string, String string2) {
        Rectangle2D rectangle2D = this.getBox().getBoundsInternal();
        this.leftRegionParticleCounter = new ParticleCounter(this.getIdealGasModel());
        this.getModel().addModelElement(this.leftRegionParticleCounter);
        this.rightRegionParticleCounter = new ParticleCounter(this.getIdealGasModel());
        this.getModel().addModelElement(this.rightRegionParticleCounter);
        this.setParticleCounterRegions();
        ReadoutGraphic readoutGraphic = new ReadoutGraphic(this.leftRegionParticleCounter, IdealGasResources.getString("AdvancedModule.Count") + ": ");
        readoutGraphic.setLocation((int)rectangle2D.getMinX() + 0, (int)rectangle2D.getMaxY() + 7);
        this.addGraphic(readoutGraphic, 100.0);
        ReadoutGraphic readoutGraphic2 = new ReadoutGraphic(this.rightRegionParticleCounter, IdealGasResources.getString("AdvancedModule.Count") + ": ");
        readoutGraphic2.setLocation((int)rectangle2D.getMaxX() - 110, (int)rectangle2D.getMaxY() + 7);
        this.addGraphic(readoutGraphic2, 100.0);
        CounterLetter counterLetter = new CounterLetter(this.getApparatusPanel(), readoutFont, string, COLOR_A, this.leftRegionParticleCounter);
        counterLetter.setLocation((int)rectangle2D.getMinX() + 50, (int)rectangle2D.getMinY() - 30);
        this.addGraphic(counterLetter, 100.0);
        CounterLetter counterLetter2 = new CounterLetter(this.getApparatusPanel(), readoutFont, string2, COLOR_B, this.rightRegionParticleCounter);
        counterLetter2.setLocation((int)rectangle2D.getMaxX() - 60, (int)rectangle2D.getMinY() - 30);
        this.addGraphic(counterLetter2, 100.0);
        double d = 2.0;
        double d2 = 4.0;
        Arrow arrow = new Arrow(new Point2D.Double(counterLetter.getLocation().x + 100, counterLetter.getLocation().y - 20), new Point2D.Double(counterLetter2.getLocation().x - 100, counterLetter2.getLocation().y - 20), d * d2, d * d2, d);
        Arrow arrow2 = new Arrow(new Point2D.Double(counterLetter2.getLocation().x - 100, counterLetter2.getLocation().y - 0), new Point2D.Double(counterLetter.getLocation().x + 100, counterLetter.getLocation().y - 0), d * d2, d * d2, d);
        Color color = new Color(200, 200, 200);
        this.addGraphic(new PhetShapeGraphic(this.getApparatusPanel(), arrow.getShape(), color), 100.0);
        this.addGraphic(new PhetShapeGraphic(this.getApparatusPanel(), arrow2.getShape(), color), 100.0);
    }

    protected String[] getSpeciesNames() {
        return new String[]{IdealGasResources.getString("AdvancedModule.Particle_Type_A"), IdealGasResources.getString("AdvancedModule.Particle_Type_B")};
    }

    protected void setParticleCounterRegions() {
        Rectangle2D rectangle2D = this.getBox().getBoundsInternal();
        Rectangle2D rectangle2D2 = this.verticalWall.getBounds();
        this.leftRegionParticleCounter.setRegion(new Rectangle2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D2.getMinX() + rectangle2D2.getWidth() / 2.0 - rectangle2D.getMinX(), rectangle2D.getHeight()));
        this.rightRegionParticleCounter.setRegion(new Rectangle2D.Double(rectangle2D2.getMinX() + rectangle2D2.getWidth() / 2.0, rectangle2D.getMinY(), rectangle2D.getMaxX() - rectangle2D2.getMaxX() + rectangle2D2.getWidth() / 2.0, rectangle2D.getHeight()));
    }

    public abstract Pump[] getPumps();

    private class CounterLetter
    extends PhetTextGraphic
    implements SimpleObserver {
        private ParticleCounter particleCounter;

        public CounterLetter(Component component, Font font, String string, Color color, ParticleCounter particleCounter) {
            super(component, font, string, color);
            this.particleCounter = particleCounter;
            particleCounter.addObserver(this);
            this.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            this.setJustification(6);
        }

        public void update() {
            int n = Math.max(12, this.particleCounter.getCnt());
            PhetFont phetFont = new PhetFont(1, n);
            this.setFont(phetFont);
        }
    }

    private class ReadoutGraphic
    extends CompositePhetGraphic
    implements SimpleObserver {
        private ParticleCounter counter;
        private PhetTextGraphic labelGraphic;
        private PhetTextGraphic readout;
        private PhetShapeGraphic border;
        private String label;

        public ReadoutGraphic(ParticleCounter particleCounter, String string) {
            super(AdvancedModule.this.getApparatusPanel());
            this.border = new PhetShapeGraphic(AdvancedModule.this.getApparatusPanel(), new Rectangle(40, 20), Color.white, new BasicStroke(1.0f), Color.black);
            this.label = string;
            this.labelGraphic = new PhetTextGraphic(AdvancedModule.this.getApparatusPanel(), readoutFont, string, Color.black);
            this.addGraphic(this.labelGraphic, 10.0);
            this.readout = new PhetTextGraphic(AdvancedModule.this.getApparatusPanel(), readoutFont, "", Color.black);
            this.addGraphic(this.readout, 10.0);
            this.addGraphic(this.border, 5.0);
            this.border.setLocation(20, 0);
            particleCounter.addObserver(this);
            this.counter = particleCounter;
            this.update();
        }

        public void paint(Graphics2D graphics2D) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            this.border.setLocation((int)(readoutFont.getStringBounds(this.label, fontRenderContext).getMaxX() + 5.0), 0);
            this.readout.setLocation((int)(this.getBounds().getWidth() - 5.0), (int)this.border.getBounds().getHeight() / 2);
            this.readout.setJustification(4);
            this.labelGraphic.setLocation(0, (int)this.border.getBounds().getHeight() / 2);
            this.labelGraphic.setJustification(8);
            super.paint(graphics2D);
        }

        public void update() {
            this.readout.setText(Integer.toString(this.counter.getCnt()));
            this.setBoundsDirty();
            this.repaint();
        }
    }
}

