/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.HotAirBalloon;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HotAirBalloonControlPanel
extends JPanel {
    private HotAirBalloon hotAirBalloon;

    public HotAirBalloonControlPanel(HotAirBalloon hotAirBalloon) {
        this.hotAirBalloon = hotAirBalloon;
        this.addHotAirBallonControls();
    }

    private void addHotAirBallonControls() {
        HotAirBalloonControlPanel hotAirBalloonControlPanel = this;
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        BufferedImage bufferedImage = IdealGasResources.getImage("stove-and-flames-small.gif");
        BufferedImage bufferedImage2 = IdealGasResources.getImage("stove-small.gif");
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage2);
        jPanel.add(new JLabel(imageIcon));
        jPanel.add(new JLabel(imageIcon2));
        hotAirBalloonControlPanel.add(jPanel);
        jPanel.setPreferredSize(new Dimension(24, 50));
        final JSlider jSlider = new JSlider(1, 0, 30, 0);
        jSlider.setMajorTickSpacing(5);
        jSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(IdealGasResources.getString("Common.0")));
        hashtable.put(new Integer(30), new JLabel(IdealGasResources.getString("Common.Add")));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setPreferredSize(new Dimension(76, 50));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HotAirBalloonControlPanel.this.setHotAirBalloonHeat(jSlider.getValue());
            }
        });
        this.hotAirBalloon.addChangeListener(new HotAirBalloon.ChangeListener(){

            public void heatSourceChanged(HotAirBalloon.ChangeEvent changeEvent) {
                jSlider.setValue((int)changeEvent.getHotAirBalloon().getHeatSource());
            }
        });
        hotAirBalloonControlPanel.add(jSlider);
        hotAirBalloonControlPanel.setBorder(new TitledBorder(IdealGasResources.getString("ModuleTitle.HotAirBalloon")));
    }

    private void setHotAirBalloonHeat(int n) {
        this.hotAirBalloon.setHeatSource(n);
    }
}

