/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.PumpControlPanel;
import edu.colorado.phet.idealgas.controller.ToolPanel;
import edu.colorado.phet.idealgas.model.Gravity;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IdealGasControlPanel
extends JPanel
implements Gravity.ChangeListener {
    private NumberFormat gravityFormat = NumberFormat.getInstance();
    private JSlider gravitySlider;
    private IdealGasModule module;
    private IdealGasModel idealGasModel;
    private GridBagConstraints gbc;
    private JPanel miscPanel;
    private JPanel particleControlsPanel;
    private GridBagConstraints particleControlsGbc;
    private PumpControlPanel speciesButtonPanel;

    public IdealGasControlPanel(IdealGasModule idealGasModule) {
        this.module = idealGasModule;
        this.idealGasModel = (IdealGasModel)idealGasModule.getModel();
        this.idealGasModel.getGravity().addListener(this);
        this.init();
    }

    private void init() {
        this.makeMiscControls();
        this.makeParticlesControls();
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.constantParamControls(), this.gbc);
        this.add((Component)this.particleControlsPanel, this.gbc);
        this.add((Component)this.miscPanel, this.gbc);
        this.add((Component)new ToolPanel(this.module), this.gbc);
        JButton jButton = new JButton(IdealGasResources.getString("IdealGasControlPanel.Reset"));
        jButton.setBackground(new Color(180, 255, 180));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdealGasControlPanel.this.module.reset();
            }
        });
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.gbc.clone();
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(border);
    }

    private void makeParticlesControls() {
        this.particleControlsPanel = new JPanel(new GridBagLayout());
        this.particleControlsGbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.speciesButtonPanel = new PumpControlPanel(this.module, this.module.getPump(), this.module.getSpeciesNames());
        this.speciesButtonPanel.setBorder(new TitledBorder(IdealGasResources.getString("IdealGasControlPanel.Gas_In_Chamber")));
        this.particleControlsPanel.add((Component)this.speciesButtonPanel, this.particleControlsGbc);
    }

    public void resetSpeciesControls() {
        this.speciesButtonPanel.reset();
    }

    private void makeMiscControls() {
        this.miscPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel jPanel = this.gravityControls();
        this.miscPanel.add((Component)jPanel, gridBagConstraints);
    }

    private JPanel constantParamControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JRadioButton jRadioButton = new JRadioButton(IdealGasResources.getString("Common.Volume"));
        JRadioButton jRadioButton2 = new JRadioButton(IdealGasResources.getString("Common.Pressure"));
        JRadioButton jRadioButton3 = new JRadioButton(IdealGasResources.getString("Common.Temperature"));
        JRadioButton jRadioButton4 = new JRadioButton(IdealGasResources.getString("Common.None"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jRadioButton3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jRadioButton4, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.anchor = 10;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jPanel2.setBorder(new TitledBorder(IdealGasResources.getString("IdealGasControlPanel.Constant_Parameter")));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdealGasControlPanel.this.idealGasModel.setConstantProperty(1);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdealGasControlPanel.this.idealGasModel.setConstantProperty(2);
            }
        });
        jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdealGasControlPanel.this.idealGasModel.setConstantProperty(3);
            }
        });
        jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IdealGasControlPanel.this.idealGasModel.setConstantProperty(0);
            }
        });
        jRadioButton4.setSelected(true);
        return jPanel2;
    }

    private JPanel gravityControls() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.gravitySlider = new JSlider(0, 0, 40, 0);
        this.gravitySlider.setPreferredSize(new Dimension(150, 50));
        this.gravitySlider.setPaintTicks(true);
        this.gravitySlider.setMajorTickSpacing(10);
        this.gravitySlider.setMinorTickSpacing(5);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(IdealGasResources.getString("Common.0")));
        hashtable.put(new Integer(40), new JLabel(IdealGasResources.getString("Common.Lots")));
        this.gravitySlider.setLabelTable(hashtable);
        this.gravitySlider.setPaintLabels(true);
        jPanel.add((Component)this.gravitySlider, gridBagConstraints);
        this.gravitySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IdealGasControlPanel.this.module.setGravity(IdealGasControlPanel.this.gravitySlider.getValue());
            }
        });
        JTextField jTextField = new JTextField(2);
        jTextField.setEditable(false);
        jTextField.setHorizontalAlignment(4);
        this.gravityFormat.setMaximumFractionDigits(2);
        this.gravityFormat.setMinimumFractionDigits(2);
        jTextField.setText(this.gravityFormat.format(0L));
        TitledBorder titledBorder = new TitledBorder(IdealGasResources.getString("Common.Gravity"));
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    public void addParticleControl(Component component) {
        this.particleControlsPanel.add(component, this.particleControlsGbc);
    }

    public void gravityChanged(Gravity.ChangeEvent changeEvent) {
        this.gravitySlider.setValue((int)changeEvent.getGravity().getAmt());
    }
}

