/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.idealgas.instrumentation.Thermometer;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.Component;
import java.awt.geom.Point2D;

class IdealGasThermometer
extends Thermometer
implements SimpleObserver {
    private IdealGasModel idealGasModel;
    private double temperature = Double.NaN;

    public IdealGasThermometer(Component component, IdealGasModel idealGasModel, Point2D.Double double_, double d, double d2, boolean bl, double d3, double d4) {
        super(component, double_, d, d2, bl, d3, d4);
        this.idealGasModel = idealGasModel;
        idealGasModel.addObserver(this);
        this.update();
    }

    public void update() {
        double d = this.idealGasModel.getTemperature();
        d = Double.isInfinite(d) ? 0.0 : d;
        double d2 = d = Double.isNaN(d) ? 0.0 : d;
        if (this.temperature != (d *= 20.0)) {
            this.temperature = d;
            super.setValue(this.temperature);
            super.setBoundsDirty();
            this.repaint();
        }
    }
}

