/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.FloorFixupStrategy;
import edu.colorado.phet.idealgas.collision.SphereWallExpert;
import edu.colorado.phet.idealgas.collision.VerticalBarrier;
import edu.colorado.phet.idealgas.collision.VerticalWallFixupStrategy;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.controller.AdvancedIdealGasControlPanel;
import edu.colorado.phet.idealgas.controller.AdvancedModule;
import edu.colorado.phet.idealgas.controller.command.PumpMoleculeCmd;
import edu.colorado.phet.idealgas.instrumentation.Thermometer;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.PChemModel;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.GasMoleculeGraphic;
import edu.colorado.phet.idealgas.view.GraduatedWallGraphic;
import edu.colorado.phet.idealgas.view.HeavySpeciesGraphic;
import edu.colorado.phet.idealgas.view.LightSpeciesGraphic;
import edu.colorado.phet.idealgas.view.WallGraphic;
import edu.colorado.phet.idealgas.view.monitors.EnergyHistogramDialog;
import edu.colorado.phet.idealgas.view.monitors.SpeciesMonitorDialog;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JDialog;

public class MovableWallsModule
extends AdvancedModule
implements PChemModel.Listener {
    private static double s_verticalWallLayer = 1000.0;
    private Wall leftFloor;
    private Wall rightFloor;
    private int wallThickness = (int)GasMolecule.s_radius * 8;
    private PhetShapeGraphic energyCurveGraphic;
    private Pump reactantsPump = new Pump(this, this.getBox(), this.getPumpingEnergyStrategy());
    private Pump productsPump;
    private Rectangle2D boxBounds;

    public MovableWallsModule(final IdealGasClock idealGasClock) {
        super(idealGasClock, "<html><center>Potential Energy<br>Surface</center></html>", new PChemModel(idealGasClock.getDt()));
        this.reactantsPump.setDispersionAngle(0.0, Math.PI * 2);
        this.productsPump = new Pump(this, this.getBox(), this.getPumpingEnergyStrategy());
        this.productsPump.setDispersionAngle(0.0, Math.PI * 2);
        this.createWalls();
        this.getIdealGasModel().addCollisionExpert(new SphereWallExpert(this.getIdealGasModel()));
        PChemModel pChemModel = (PChemModel)this.getModel();
        pChemModel.setVerticalWall(this.verticalWall);
        pChemModel.addListener(this);
        this.getIdealGasModel().getGravity().setAmt(20.0);
        ControlPanel controlPanel = new ControlPanel(this);
        this.setControlPanel(controlPanel);
        controlPanel.add(new AdvancedIdealGasControlPanel(this, IdealGasResources.getString("AdvancedModule.Particle_Type_A"), IdealGasResources.getString("AdvancedModule.Particle_Type_B")));
        this.createCurve();
        this.createCurveAdjuster();
        this.getStopwatchPanel().setTimeUnits(IdealGasResources.getString("MovableWallsModule.StopwatchTimeUnits"));
        this.getApparatusPanel().removeGraphic(wiggleMeGraphic);
        this.removePumpGraphic();
        this.getApparatusPanel().removeGraphic(this.getPusher());
        this.getApparatusPanel().removeGraphic(this.getBoxDoorGraphic());
        this.addParticleCounters(IdealGasResources.getString("AdvancedModule.Particle_Type_A"), IdealGasResources.getString("AdvancedModule.Particle_Type_B"));
        JButton jButton = new JButton("Test");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HeavySpecies heavySpecies = null;
                heavySpecies = new HeavySpecies(new Point2D.Double(MovableWallsModule.this.rightFloor.getBounds().getMinX() + 95.0, MovableWallsModule.this.rightFloor.getBounds().getMinY() - 105.0), new MutableVector2D(-200.0, 200.0), new MutableVector2D());
                new PumpMoleculeCmd(MovableWallsModule.this.getIdealGasModel(), heavySpecies, MovableWallsModule.this).doIt();
            }
        });
        JButton jButton2 = new JButton("Backup");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((IdealGasModel)MovableWallsModule.this.getModel()).stepInTime(-idealGasClock.getDt());
            }
        });
    }

    public JDialog setHistogramDlgEnabled(boolean bl) {
        EnergyHistogramDialog energyHistogramDialog = (EnergyHistogramDialog)super.setHistogramDlgEnabled(bl);
        energyHistogramDialog.setSpeedDetailsLegends(new String[]{"Speed: A", "Speed: B"}, new Color[]{COLOR_A, COLOR_B});
        return energyHistogramDialog;
    }

    public JDialog setSpeciesMonitorDlgEnabled(boolean bl) {
        SpeciesMonitorDialog speciesMonitorDialog = (SpeciesMonitorDialog)super.setSpeciesMonitorDlgEnabled(bl);
        speciesMonitorDialog.setSpeciesPanelTitles(new String[]{"A", "B"});
        return speciesMonitorDialog;
    }

    private void createCurveAdjuster() {
        Wall.ChangeListener changeListener = new Wall.ChangeListener(){

            public void wallChanged(Wall.ChangeEvent changeEvent) {
                MovableWallsModule.this.getApparatusPanel().removeGraphic(MovableWallsModule.this.energyCurveGraphic);
                MovableWallsModule.this.createCurve();
            }
        };
        this.verticalWall.addChangeListener(changeListener);
        this.leftFloor.addChangeListener(changeListener);
        this.rightFloor.addChangeListener(changeListener);
    }

    private void createCurve() {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath();
        Rectangle2D rectangle2D = this.leftFloor.getBounds();
        Rectangle2D rectangle2D2 = this.rightFloor.getBounds();
        Rectangle2D rectangle2D3 = this.verticalWall.getBounds();
        Rectangle2D rectangle2D4 = this.getBox().getBoundsInternal();
        double d = this.verticalWall.getBounds().getWidth() / 2.0;
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getMinX(), rectangle2D.getMinY());
        Point2D.Double double_2 = new Point2D.Double(rectangle2D.getMaxX() - d, rectangle2D.getMinY());
        Point2D.Double double_3 = new Point2D.Double(rectangle2D3.getMinX() + rectangle2D3.getWidth() / 2.0, rectangle2D3.getMinY());
        double d2 = ((Point2D)double_3).getX() - ((Point2D)double_2).getX();
        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_2).getX() + d2 * 3.0 / 4.0, ((Point2D)double_2).getY());
        Point2D.Double double_5 = new Point2D.Double(((Point2D)double_3).getX() - d2 / 2.0, ((Point2D)double_3).getY());
        Point2D.Double double_6 = new Point2D.Double(rectangle2D3.getMinX(), rectangle2D3.getMinY());
        Point2D.Double double_7 = new Point2D.Double(rectangle2D2.getMinX() + d, rectangle2D2.getMinY());
        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_3).getX() + d2 / 2.0, ((Point2D)double_3).getY());
        Point2D.Double double_9 = new Point2D.Double(((Point2D)double_7).getX() - d2 * 3.0 / 4.0, ((Point2D)double_7).getY());
        Point2D.Double double_10 = new Point2D.Double(rectangle2D2.getMaxX(), rectangle2D2.getMinY());
        Point2D.Double double_11 = new Point2D.Double(rectangle2D4.getMaxX(), rectangle2D4.getMaxY());
        Point2D.Double double_12 = new Point2D.Double(rectangle2D4.getMinX(), rectangle2D4.getMaxY());
        doubleGeneralPath.moveTo(double_);
        doubleGeneralPath.lineTo(double_2);
        doubleGeneralPath.curveTo(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_3).getX(), ((Point2D)double_3).getY());
        doubleGeneralPath.curveTo(((Point2D)double_8).getX(), ((Point2D)double_8).getY(), ((Point2D)double_9).getX(), ((Point2D)double_9).getY(), ((Point2D)double_7).getX(), ((Point2D)double_7).getY());
        doubleGeneralPath.lineTo(double_10);
        Color color = Color.cyan;
        Color color2 = new Color(255, 255, 255, 160);
        this.energyCurveGraphic = new PhetShapeGraphic(this.getApparatusPanel(), doubleGeneralPath.getGeneralPath(), new BasicStroke(2.0f), color);
        this.energyCurveGraphic.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        this.energyCurveGraphic.setIgnoreMouse(true);
        this.getApparatusPanel().addGraphic(this.energyCurveGraphic, s_verticalWallLayer + 10.0);
    }

    private void setBoxSize() {
        PressureSensingBox pressureSensingBox = super.getBox();
        pressureSensingBox.setBounds(this.boxBounds.getMinX(), this.boxBounds.getMinY(), this.boxBounds.getMaxX(), this.boxBounds.getMaxY());
    }

    private void createWalls() {
        PressureSensingBox pressureSensingBox = super.getBox();
        double d = pressureSensingBox.getMinX() / 2.0;
        double d2 = pressureSensingBox.getMinY() / 3.0;
        double d3 = pressureSensingBox.getMinX() - d;
        double d4 = pressureSensingBox.getMinY() - d2;
        double d5 = pressureSensingBox.getMaxX() + d - d3;
        double d6 = pressureSensingBox.getMaxY() - d4;
        this.boxBounds = new Rectangle2D.Double(d3, d4, d5, d6);
        this.setBoxSize();
        Thermometer thermometer = this.getThermometer();
        thermometer.setLocation((int)(pressureSensingBox.getMinX() + pressureSensingBox.getWidth() / 2.0), thermometer.getY());
        double d7 = 125.0;
        double d8 = pressureSensingBox.getCorner2Y() - d7;
        this.verticalWall = new VerticalBarrier(new Rectangle2D.Double(pressureSensingBox.getCorner1X() + pressureSensingBox.getWidth() / 2.0 - (double)(this.wallThickness / 2), d8, this.wallThickness, d7), pressureSensingBox.getBoundsInternal());
        this.verticalWall.setMinimumWidth(this.wallThickness);
        this.verticalWall.setMovementBounds(new Rectangle2D.Double(pressureSensingBox.getCorner1X() + (double)this.wallThickness, pressureSensingBox.getCorner1Y(), pressureSensingBox.getWidth() - (double)(2 * this.wallThickness), pressureSensingBox.getHeight()));
        this.verticalWall.setFixupStrategy(new VerticalWallFixupStrategy());
        GraduatedWallGraphic graduatedWallGraphic = new GraduatedWallGraphic(this.verticalWall, this.getApparatusPanel(), (Paint)Color.gray, Color.black, -1);
        graduatedWallGraphic.setResizableEast(false);
        graduatedWallGraphic.setResizableWest(false);
        graduatedWallGraphic.setResizableSouth(false);
        graduatedWallGraphic.setMovable(false);
        graduatedWallGraphic.setIsResizable(true);
        this.verticalWall.addChangeListener(new VerticalWallChangeListener());
        Color color = new Color(0, 0, 0, 0);
        this.leftFloor = new Wall(new Rectangle2D.Double(pressureSensingBox.getCorner1X(), pressureSensingBox.getCorner2Y() - 75.0, this.verticalWall.getBounds().getMinX() - pressureSensingBox.getCorner1X(), this.wallThickness), pressureSensingBox.getBoundsInternal());
        this.leftFloor.setFixupStrategy(new FloorFixupStrategy());
        this.getBox().addChangeListener(new BoxChangeListener());
        WallGraphic wallGraphic = new WallGraphic(this.leftFloor, this.getApparatusPanel(), (Paint)Color.gray, Color.black, 2);
        wallGraphic.setMovable(true);
        wallGraphic.setResizableEast(false);
        wallGraphic.setResizableWest(false);
        wallGraphic.setResizableNorth(false);
        wallGraphic.setResizableSouth(false);
        wallGraphic.setWallHighlightedByMouse(false);
        this.getModel().addModelElement(this.leftFloor);
        this.addGraphic(wallGraphic, s_verticalWallLayer - 1.0);
        this.rightFloor = new Wall(new Rectangle2D.Double(this.verticalWall.getBounds().getMaxX(), pressureSensingBox.getCorner2Y() - 40.0, pressureSensingBox.getCorner2X() - this.verticalWall.getBounds().getMaxX(), this.wallThickness), pressureSensingBox.getBoundsInternal());
        this.rightFloor.setFixupStrategy(new FloorFixupStrategy());
        WallGraphic wallGraphic2 = new WallGraphic(this.rightFloor, this.getApparatusPanel(), (Paint)Color.gray, Color.black, 2);
        wallGraphic2.setMovable(true);
        wallGraphic2.setResizableEast(false);
        wallGraphic2.setResizableWest(false);
        wallGraphic2.setResizableNorth(false);
        wallGraphic2.setResizableSouth(false);
        wallGraphic2.setWallHighlightedByMouse(false);
        this.getModel().addModelElement(this.rightFloor);
        this.addGraphic(wallGraphic2, s_verticalWallLayer - 1.0);
        this.getModel().addModelElement(this.verticalWall);
        this.addGraphic(graduatedWallGraphic, s_verticalWallLayer);
        this.rightFloor.addChangeListener(new VerticalWallLimitSetter());
        this.leftFloor.addChangeListener(new VerticalWallLimitSetter());
        double d9 = Math.max(this.getBox().getMaxY() - this.leftFloor.getBounds().getMinY(), this.getBox().getMaxY() - this.rightFloor.getBounds().getMinY());
        this.verticalWall.setMinHeight(d9);
        this.setWallBounds();
    }

    private void setWallBounds() {
        Rectangle2D rectangle2D = this.getBox().getBoundsInternal();
        Rectangle2D rectangle2D2 = this.verticalWall.getBounds();
        this.leftFloor.setBounds(new Rectangle2D.Double(rectangle2D.getMinX(), this.leftFloor.getBounds().getMinY(), rectangle2D2.getMinX() - rectangle2D.getMinX(), this.leftFloor.getBounds().getHeight()));
        this.rightFloor.setBounds(new Rectangle2D.Double(rectangle2D2.getMaxX(), this.rightFloor.getBounds().getMinY(), rectangle2D.getMaxX() - rectangle2D2.getMaxX(), this.rightFloor.getBounds().getHeight()));
        this.leftFloor.setMovementBounds(new Rectangle2D.Double(rectangle2D.getMinX(), rectangle2D2.getMinY(), rectangle2D2.getMinX() - rectangle2D.getMinX(), rectangle2D.getMaxY() - rectangle2D2.getMinY()));
        this.rightFloor.setMovementBounds(new Rectangle2D.Double(rectangle2D2.getMaxX(), rectangle2D2.getMinY(), rectangle2D.getMaxX() - rectangle2D2.getMaxX(), rectangle2D.getMaxY() - rectangle2D2.getMinY()));
    }

    public void reset() {
        super.reset();
        this.setBoxSize();
    }

    public void pumpGasMolecules(int n, Class clazz) {
        Point2D.Double double_ = null;
        if (clazz == HeavySpecies.class) {
            double_ = new Point2D.Double((this.leftFloor.getBounds().getMinX() + this.leftFloor.getBounds().getMaxX()) / 2.0, this.leftFloor.getBounds().getMinY() - 15.0);
            this.reactantsPump.pump(n, clazz, double_);
        }
        if (clazz == LightSpecies.class) {
            double_ = new Point2D.Double((this.rightFloor.getBounds().getMinX() + this.rightFloor.getBounds().getMaxX()) / 2.0, this.rightFloor.getBounds().getMinY() - 15.0);
            this.productsPump.pump(n, clazz, double_);
        }
    }

    public Pump[] getPumps() {
        return new Pump[]{this.getPump(), this.reactantsPump, this.productsPump};
    }

    public void moleculeCreated(PChemModel.MoleculeCreationEvent moleculeCreationEvent) {
        GasMoleculeGraphic gasMoleculeGraphic = null;
        GasMolecule gasMolecule = moleculeCreationEvent.getMolecule();
        if (gasMolecule instanceof HeavySpecies) {
            gasMoleculeGraphic = new HeavySpeciesGraphic(this.getApparatusPanel(), gasMolecule);
        } else if (gasMolecule instanceof LightSpecies) {
            gasMoleculeGraphic = new LightSpeciesGraphic(this.getApparatusPanel(), gasMolecule);
        }
        if (gasMoleculeGraphic != null) {
            this.addGraphic(gasMoleculeGraphic, 10.0);
        }
    }

    private class BoxChangeListener
    implements Box2D.ChangeListener {
        private BoxChangeListener() {
        }

        public void boundsChanged(Box2D.ChangeEvent changeEvent) {
            Rectangle2D rectangle2D = MovableWallsModule.this.leftFloor.getBounds();
            Box2D box2D = changeEvent.getBox2D();
            MovableWallsModule.this.leftFloor.setMovementBounds(MovableWallsModule.this.getBox().getBoundsInternal());
            MovableWallsModule.this.leftFloor.setBounds(new Rectangle2D.Double(box2D.getBoundsInternal().getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX() - box2D.getBoundsInternal().getMinX(), rectangle2D.getHeight()));
        }

        public void isVolumeFixedChanged(Box2D.ChangeEvent changeEvent) {
        }
    }

    private class VerticalWallChangeListener
    implements Wall.ChangeListener {
        private VerticalWallChangeListener() {
        }

        public void wallChanged(Wall.ChangeEvent changeEvent) {
            MovableWallsModule.this.setWallBounds();
            MovableWallsModule.this.setParticleCounterRegions();
        }
    }

    private class VerticalWallLimitSetter
    implements Wall.ChangeListener {
        public void wallChanged(Wall.ChangeEvent changeEvent) {
            double d = MovableWallsModule.this.verticalWall.getMinHeight();
            double d2 = MovableWallsModule.this.getBox().getMaxY() - MovableWallsModule.this.leftFloor.getBounds().getMinY();
            double d3 = MovableWallsModule.this.getBox().getMaxY() - MovableWallsModule.this.rightFloor.getBounds().getMinY();
            double d4 = Math.max(d2, d3);
            MovableWallsModule.this.verticalWall.setMinHeight(d4);
        }
    }
}

