/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.SphereHollowSphereExpert;
import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.HollowSphereControlPanel;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.command.AddModelElementCmd;
import edu.colorado.phet.idealgas.controller.command.PumpMoleculeCmd;
import edu.colorado.phet.idealgas.instrumentation.Thermometer;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.HollowSphere;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.HollowSphereGraphic;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class RigidHollowSphereModule
extends IdealGasModule
implements GasSource {
    private HollowSphere sphere;
    private Class gasSpecies = HeavySpecies.class;
    private LinkedList moleculesInSphere = new LinkedList();
    private double defaultGravity = 10.0;

    public RigidHollowSphereModule(IdealGasClock idealGasClock) {
        super(idealGasClock, IdealGasResources.getString("ModuleTitle.RigidHollowSphere"));
        double d = 200.0;
        double d2 = 250.0;
        double d3 = 434.0;
        double d4 = 397.0;
        this.getIdealGasModel().addCollisionExpert(new SphereHollowSphereExpert());
        PressureSensingBox pressureSensingBox = this.getIdealGasModel().getBox();
        this.sphere = new HollowSphere(new Point2D.Double(pressureSensingBox.getMinX() + pressureSensingBox.getWidth() / 2.0, pressureSensingBox.getMinY() + pressureSensingBox.getHeight() / 2.0), new MutableVector2D(0.0, 0.0), new MutableVector2D(0.0, 0.0), 100.0, 50.0);
        pressureSensingBox.setMinimumWidth(this.sphere.getRadius() * 3.0);
        int n = 100;
        Thermometer thermometer = this.getThermometer();
        thermometer.setLocation(new Point2D.Double(pressureSensingBox.getMaxX() - 30.0, pressureSensingBox.getMinY() - (double)n));
        new AddModelElementCmd(this.getIdealGasModel(), this.sphere).doIt();
        this.getIdealGasModel().getBox().addContainedBody(this.sphere);
        this.addGraphic(new HollowSphereGraphic(this.getApparatusPanel(), this.sphere), 20.0);
        this.addGas(d3, d, d4, d2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(IdealGasResources.getString("RigidHollowSphereControlPanel.controlsTitle")));
        GridBagConstraints gridBagConstraints = null;
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0);
        HollowSphereControlPanel hollowSphereControlPanel = new HollowSphereControlPanel(this, this, this.sphere);
        jPanel.add((Component)hollowSphereControlPanel, gridBagConstraints);
        this.addResetListener(hollowSphereControlPanel);
        this.getIdealGasControlPanel().addParticleControl(jPanel);
        this.setGravity(this.defaultGravity);
    }

    private void addGas(double d, double d2, double d3, double d4) {
        for (int i = 0; i < 0; ++i) {
            double d5 = Math.random() * (d - d2 - 20.0) + d2 + 50.0;
            double d6 = Math.random() * (d3 - d4 - 20.0) + d4 + 10.0;
            double d7 = Math.random() * Math.PI * 2.0;
            double d8 = Math.cos(d7) * 35.0;
            double d9 = Math.sin(d7) * 35.0;
            HeavySpecies heavySpecies = new HeavySpecies(new Point2D.Double(d5, d6), new MutableVector2D(d8, d9), new MutableVector2D(0.0, 0.0));
            new PumpMoleculeCmd(this.getIdealGasModel(), heavySpecies, this).doIt();
        }
        GasMolecule gasMolecule = null;
        int n = 0;
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d10 = 35.0;
                double d11 = Math.random() * Math.PI * 2.0;
                double d12 = Math.cos(d11) * d10;
                double d13 = Math.sin(d11) * d10;
                if (HeavySpecies.class.isAssignableFrom(this.gasSpecies)) {
                    gasMolecule = new HeavySpecies(new Point2D.Double(350 + i * 10, 230 + j * 10), new MutableVector2D(d12, d13), new MutableVector2D(0.0, 0.0));
                    new PumpMoleculeCmd(this.getIdealGasModel(), gasMolecule, this).doIt();
                }
                if (LightSpecies.class.isAssignableFrom(this.gasSpecies)) {
                    gasMolecule = new LightSpecies(new Point2D.Double(350 + i * 10, 230 + j * 10), new MutableVector2D(d12, d13), new MutableVector2D(0.0, 0.0));
                    new PumpMoleculeCmd(this.getIdealGasModel(), gasMolecule, this).doIt();
                }
                this.sphere.addContainedBody(gasMolecule);
            }
        }
    }

    protected Pump.PumpingEnergyStrategy getPumpingEnergyStrategy() {
        return new Pump.FixedEnergyStrategy();
    }

    public void setCurrentGasSpecies(Class clazz) {
        this.gasSpecies = clazz;
    }

    public void removeGasMoleculeFromSphere(Class clazz) {
        boolean bl = false;
        GasMolecule gasMolecule = null;
        for (int i = 0; !bl && i < this.moleculesInSphere.size(); ++i) {
            gasMolecule = (GasMolecule)this.moleculesInSphere.get(i);
            if (!clazz.isInstance(gasMolecule)) continue;
            bl = true;
            this.moleculesInSphere.remove(gasMolecule);
            this.sphere.removeContainedBody(gasMolecule);
        }
        if (bl) {
            this.getIdealGasModel().removeModelElement(gasMolecule);
        }
    }

    public void addMoleculeToSphere(Class clazz) {
        Point2D point2D = this.sphere.getNewMoleculeLocation();
        MutableVector2D mutableVector2D = this.sphere.getNewMoleculeVelocity(clazz, this.getIdealGasModel());
        GasMolecule gasMolecule = null;
        if (clazz == HeavySpecies.class) {
            gasMolecule = new HeavySpecies(point2D, mutableVector2D, new MutableVector2D());
        }
        if (clazz == LightSpecies.class) {
            gasMolecule = new LightSpecies(point2D, mutableVector2D, new MutableVector2D());
        }
        this.moleculesInSphere.add(gasMolecule);
        PumpMoleculeCmd pumpMoleculeCmd = new PumpMoleculeCmd(this.getIdealGasModel(), gasMolecule, this);
        pumpMoleculeCmd.doIt();
        this.sphere.addContainedBody(gasMolecule);
    }

    public void removeGasMolecule(Class clazz) {
        List list = this.getIdealGasModel().getBodies();
        Object var3_3 = null;
        while (var3_3 == null) {
            int n;
            boolean bl = new Random().nextBoolean();
            if (bl) {
                for (n = 0; n < list.size() && (!clazz.isInstance(var3_3 = list.get(n)) || this.sphere.containsBody(var3_3)); ++n) {
                }
                continue;
            }
            for (n = list.size() - 1; n >= 0 && (!clazz.isInstance(var3_3 = list.get(n)) || this.sphere.containsBody(var3_3)); --n) {
            }
        }
        if (var3_3 instanceof GasMolecule && !this.sphere.containsBody(var3_3)) {
            GasMolecule gasMolecule = var3_3;
            this.getIdealGasModel().removeModelElement(gasMolecule);
        }
    }

    public int getHeavySpeciesCnt() {
        return super.getHeavySpeciesCnt() - this.sphere.getHeavySpeciesCnt();
    }

    public int getLightSpeciesCnt() {
        return super.getLightSpeciesCnt() - this.sphere.getLightSpeciesCnt();
    }
}

