/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.instrumentation;

import edu.colorado.phet.idealgas.instrumentation.AbstractGauge;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BarGauge
extends AbstractGauge {
    private Rectangle2D.Double bar;
    private Rectangle2D.Double frame;
    private Color color;
    private boolean isVertical;
    private double offset;
    private double scale;
    private Point2D location;
    private double maxScreenLevel;
    private Color outlineColor = Color.black;

    public BarGauge(Point2D.Double double_, double d, Color color, double d2, boolean bl, double d3, double d4) {
        this.location = double_;
        this.maxScreenLevel = d;
        this.color = color;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        this.scale = d / (d4 - d3);
        this.offset = d3 * this.scale;
        this.isVertical = bl;
        if (bl) {
            d5 = d2;
            d7 = d2;
            d8 = d;
        } else {
            d6 = d2;
            d7 = d;
            d8 = d2;
        }
        this.bar = new Rectangle2D.Double(double_.getX(), double_.getY(), d5, d6);
        this.frame = new Rectangle2D.Double(double_.getX(), double_.getY(), d7, d8);
    }

    public Rectangle getBounds() {
        return this.frame.getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.color);
        graphics2D.draw(this.bar);
        graphics2D.fill(this.bar);
        graphics2D.setColor(this.outlineColor);
        graphics2D.draw(this.frame);
        graphics2D.setColor(color);
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setLevel(double d) {
        double d2 = Math.min(Math.max(this.offset + this.scale * d, 0.0), this.maxScreenLevel);
        if (this.isVertical) {
            this.bar.setRect(this.location.getX(), this.location.getY() + this.maxScreenLevel - d2, this.bar.getWidth(), d2);
        } else {
            double d3 = this.bar.getMaxX() - d / 1000.0;
            this.bar.setRect(this.bar.getMinX(), this.bar.getMaxY(), d3, this.bar.getMaxY());
        }
    }

    public void setLocation(Point2D.Double double_) {
        this.location.setLocation(double_);
    }
}

