/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.instrumentation;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.idealgas.coreadditions.ScalarObservable;
import edu.colorado.phet.idealgas.coreadditions.ScalarObserver;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DialGauge
extends CompositePhetGraphic
implements ScalarObserver {
    private static Font s_defaultFont = new PhetFont(1, 8);
    private static NumberFormat s_defaultFormatter = new DecimalFormat("#0.0");
    private ScalarObservable dataSource;
    private String title;
    private String units;
    private Component component;
    private double x;
    private double y;
    private double diam;
    private double min;
    private double max;
    private NeedleGraphic needleGraphic;
    private FaceGraphic faceGraphic;
    private Font font;
    private NumberFormat numberFormat;
    private double needleLength = 0.5;
    private double datum = Double.NaN;
    private Color backgroundColor = new Color(245, 255, 250);

    public DialGauge(ScalarObservable scalarObservable, Component component, double d, double d2, double d3, double d4, double d5, String string, String string2, Font font, NumberFormat numberFormat) {
        this.dataSource = scalarObservable;
        this.title = string;
        this.units = string2;
        this.font = font;
        this.numberFormat = numberFormat;
        scalarObservable.addObserver(this);
        this.component = component;
        this.x = d;
        this.y = d2;
        this.diam = d3;
        this.min = d4;
        this.max = d5;
        this.faceGraphic = new FaceGraphic();
        this.addGraphic(this.faceGraphic);
        this.needleGraphic = new NeedleGraphic();
        this.addGraphic(this.needleGraphic);
        this.update();
    }

    public void update() {
        double d = this.dataSource.getValue();
        if (this.datum != d) {
            this.datum = d;
            double d2 = Math.max(Math.min(this.datum, this.max), this.min);
            double d3 = (this.max - d2) / (this.max - this.min);
            double d4 = -(3.9269908169872414 + 4.71238898038469 * d3) - 1.5707963267948966;
            this.needleGraphic.update(d4);
            this.faceGraphic.repaint();
        }
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    private class FaceGraphic
    extends PhetShapeGraphic {
        private Rectangle2D.Double tickMark;

        FaceGraphic() {
            super(DialGauge.this.component, null, DialGauge.this.backgroundColor, new BasicStroke(5.0f), new Color(80, 80, 40));
            Ellipse2D.Double double_ = new Ellipse2D.Double(DialGauge.this.x - DialGauge.this.diam / 2.0, DialGauge.this.y - DialGauge.this.diam / 2.0, DialGauge.this.diam, DialGauge.this.diam);
            super.setShape(double_);
            this.tickMark = new Rectangle2D.Double(DialGauge.this.x + DialGauge.this.diam * 3.0 / 8.0, DialGauge.this.y - 1.0, DialGauge.this.diam / 16.0, 2.0);
        }

        public void paint(Graphics2D graphics2D) {
            Cloneable cloneable;
            this.saveGraphicsState(graphics2D);
            DialGauge.this.setBackground(DialGauge.this.backgroundColor);
            GraphicsUtil.setAntiAliasingOn(graphics2D);
            super.paint(graphics2D);
            int n = 19;
            graphics2D.setColor(Color.black);
            double d = 4.71238898038469 / (double)(n - 1);
            for (double d2 = 2.356194490192345; d2 <= 7.0685834705770345 + d / 2.0; d2 += d) {
                cloneable = graphics2D.getTransform();
                graphics2D.transform(AffineTransform.getRotateInstance(d2, DialGauge.this.x, DialGauge.this.y));
                graphics2D.fill(this.tickMark);
                graphics2D.setTransform((AffineTransform)cloneable);
            }
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            String string = Double.toString(DialGauge.this.min);
            cloneable = DialGauge.this.font.getStringBounds(string, fontRenderContext);
            graphics2D.setFont(DialGauge.this.font);
            double d3 = 0.6;
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, 0.0, 0.0, 3.0, 3.0);
            double_.setFrameFromCenter(DialGauge.this.x, DialGauge.this.y + 10.0, DialGauge.this.x + 30.0, DialGauge.this.y + 17.0);
            graphics2D.setColor(Color.white);
            graphics2D.fill(double_);
            graphics2D.setColor(Color.yellow);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(double_);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(new BasicStroke(0.5f));
            graphics2D.draw(double_);
            String string2 = DialGauge.this.numberFormat.format(DialGauge.this.datum) + " " + DialGauge.this.units;
            cloneable = DialGauge.this.font.getStringBounds(string2, fontRenderContext);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string2, (float)DialGauge.this.x - (float)((RectangularShape)cloneable).getWidth() / 2.0f, (float)(DialGauge.this.y + DialGauge.this.diam / 4.0 * d3));
            cloneable = DialGauge.this.font.getStringBounds(DialGauge.this.title, fontRenderContext);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(DialGauge.this.title, (float)DialGauge.this.x - (float)((RectangularShape)cloneable).getWidth() / 2.0f, (float)(DialGauge.this.y - DialGauge.this.diam / 4.0 * d3));
            this.restoreGraphicsState();
        }
    }

    private class NeedleGraphic
    extends PhetShapeGraphic {
        private Rectangle2D.Double needle;
        private double r;
        private double l;
        private AffineTransform needleTx;
        private Ellipse2D.Double pivot;

        NeedleGraphic() {
            super(DialGauge.this.component, null, Color.red);
            this.r = 0.2;
            this.pivot = new Ellipse2D.Double();
            this.needle = new Rectangle2D.Double();
            this.l = DialGauge.this.diam * DialGauge.this.needleLength;
            this.needle.setRect(DialGauge.this.x - this.l * this.r, DialGauge.this.y - 1.0, this.l, 2.0);
            super.setShape(this.needle);
        }

        public void paint(Graphics2D graphics2D) {
            this.saveGraphicsState(graphics2D);
            GraphicsUtil.setAntiAliasingOn(graphics2D);
            graphics2D.transform(this.needleTx);
            super.paint(graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.pivot);
            this.restoreGraphicsState();
        }

        void update(double d) {
            this.needleTx = AffineTransform.getRotateInstance(d, DialGauge.this.x, DialGauge.this.y);
            this.pivot.setFrameFromCenter(DialGauge.this.x, DialGauge.this.y, DialGauge.this.x + 2.0, DialGauge.this.y + 2.0);
            this.repaint();
        }
    }
}

