/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class Gravity
implements ModelElement {
    private MutableVector2D acceleration = new MutableVector2D();
    private IdealGasModel model;
    private EventChannel channel = new EventChannel(ChangeListener.class);
    private ChangeListener listenerProxy = (ChangeListener)this.channel.getListenerProxy();

    public Gravity(IdealGasModel idealGasModel) {
        this.model = idealGasModel;
        this.setAmt(0.0);
    }

    public void stepInTime(double d) {
        List list = this.model.getBodies();
        for (int i = 0; i < list.size(); ++i) {
            Body body = (Body)list.get(i);
            body.setAcceleration(body.getAcceleration().add(this.acceleration));
        }
    }

    public double getAmt() {
        return this.acceleration.getY();
    }

    public void setAmt(double d) {
        double d2 = this.acceleration.magnitude();
        this.acceleration = new MutableVector2D(0.0, d);
        double d3 = this.acceleration.magnitude() - d2;
        try {
            this.listenerProxy.gravityChanged(new ChangeEvent(this, d3));
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            System.out.println("e = " + undeclaredThrowableException);
        }
    }

    public void addListener(ChangeListener changeListener) {
        this.channel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        private double change;

        public ChangeEvent(Object object, double d) {
            super(object);
            this.change = d;
        }

        public double getChange() {
            return this.change;
        }

        public Gravity getGravity() {
            return (Gravity)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void gravityChanged(ChangeEvent var1);
    }
}

