/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class PChemModel
extends IdealGasModel
implements Wall.ChangeListener {
    double centerlineLoc;
    private EventChannel listenerChannel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.listenerChannel.getListenerProxy();

    public PChemModel(double d) {
        super(d);
    }

    public void setCenterlineLoc(double d) {
        this.centerlineLoc = d;
    }

    public void setVerticalWall(Wall wall) {
        wall.addChangeListener(this);
        Rectangle2D rectangle2D = wall.getBounds();
        this.setCenterlineLoc(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        List list = super.getBodies();
        for (int i = 0; i < list.size(); ++i) {
            MutableVector2D mutableVector2D;
            MutableVector2D mutableVector2D2;
            GasMolecule gasMolecule;
            Object e = list.get(i);
            if (!(e instanceof GasMolecule)) continue;
            GasMolecule gasMolecule2 = (GasMolecule)e;
            if (gasMolecule2.getPosition().getX() > this.centerlineLoc && gasMolecule2 instanceof HeavySpecies) {
                gasMolecule = new LightSpecies(gasMolecule2.getPosition(), gasMolecule2.getVelocity(), gasMolecule2.getAcceleration());
                mutableVector2D2 = gasMolecule2.getVelocity();
                mutableVector2D = mutableVector2D2.scale(Math.sqrt(gasMolecule2.getMass() / gasMolecule.getMass()));
                gasMolecule.setVelocity(mutableVector2D);
                this.addModelElement(gasMolecule);
                this.removeModelElement(gasMolecule2);
                this.listenerProxy.moleculeCreated(new MoleculeCreationEvent(this, gasMolecule));
            }
            if (!(gasMolecule2.getPosition().getX() < this.centerlineLoc) || !(gasMolecule2 instanceof LightSpecies)) continue;
            gasMolecule = new HeavySpecies(gasMolecule2.getPosition(), gasMolecule2.getVelocity(), gasMolecule2.getAcceleration());
            mutableVector2D2 = gasMolecule2.getVelocity();
            mutableVector2D = mutableVector2D2.scale(Math.sqrt(gasMolecule2.getMass() / gasMolecule.getMass()));
            gasMolecule.setVelocity(mutableVector2D);
            this.addModelElement(gasMolecule);
            this.removeModelElement(gasMolecule2);
            this.listenerProxy.moleculeCreated(new MoleculeCreationEvent(this, gasMolecule));
        }
    }

    public void wallChanged(Wall.ChangeEvent changeEvent) {
        Rectangle2D rectangle2D = changeEvent.getWall().getBounds();
        this.setCenterlineLoc(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
    }

    public void addListener(Listener listener) {
        this.listenerChannel.addListener(listener);
    }

    public static interface Listener
    extends EventListener {
        public void moleculeCreated(MoleculeCreationEvent var1);
    }

    public class MoleculeCreationEvent
    extends EventObject {
        private GasMolecule molecule;

        public MoleculeCreationEvent(Object object, GasMolecule gasMolecule) {
            super(object);
            this.molecule = gasMolecule;
        }

        public GasMolecule getMolecule() {
            return this.molecule;
        }
    }
}

