/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class CmLines
extends PhetGraphic
implements SimpleObserver {
    private Point2D heavyCm;
    private Point2D lightCm;
    private Box2D box;
    private double boxLeftEdge;
    private double boxLowerEdge;
    private Stroke cmStroke = new BasicStroke(3.0f);
    private Rectangle2D.Double heavyCmYLocLine = new Rectangle2D.Double();
    private Rectangle2D.Double heavyCmXLocLine = new Rectangle2D.Double();
    private Rectangle2D.Double lightCmYLocLine = new Rectangle2D.Double();
    private Rectangle2D.Double lightCmXLocLine = new Rectangle2D.Double();
    private Rectangle bounds = new Rectangle();
    private double lineLength = 30.0;
    private int lineThickness = 4;

    public CmLines(Component component, IdealGasModel idealGasModel) {
        super(component);
        this.box = idealGasModel.getBox();
        idealGasModel.addObserver(this);
        this.update();
        super.setIgnoreMouse(true);
    }

    protected Rectangle determineBounds() {
        double d = this.boxLeftEdge - this.lineLength / 2.0;
        double d2 = this.boxLowerEdge + this.lineLength / 2.0;
        double d3 = Math.min(this.lightCmYLocLine.getMinY(), this.lightCmYLocLine.getMinY());
        double d4 = Math.max(this.lightCmYLocLine.getMaxX(), this.lightCmYLocLine.getMaxX());
        double d5 = Math.min(this.heavyCmYLocLine.getMinY(), this.heavyCmYLocLine.getMinY());
        double d6 = Math.max(this.heavyCmYLocLine.getMaxX(), this.heavyCmYLocLine.getMaxX());
        double d7 = Math.min(d3, d5);
        double d8 = Math.max(d4, d6);
        this.bounds.setRect(d, d7, d8 - d, d2 - d7);
        return this.bounds;
    }

    public void update() {
        this.heavyCm = HeavySpecies.getCm();
        this.lightCm = LightSpecies.getCm();
        this.boxLeftEdge = this.box.getMinX();
        this.boxLowerEdge = this.box.getMaxY();
        this.lightCmYLocLine.setFrameFromCenter(this.boxLeftEdge, this.lightCm.getY(), this.boxLeftEdge + this.lineLength / 2.0, this.lightCm.getY() + (double)(this.lineThickness / 2));
        this.lightCmXLocLine.setFrameFromCenter(this.lightCm.getX(), this.boxLowerEdge, this.lightCm.getX() + (double)(this.lineThickness / 2), this.boxLowerEdge + this.lineLength / 2.0);
        this.heavyCmYLocLine.setFrameFromCenter(this.boxLeftEdge, this.heavyCm.getY(), this.boxLeftEdge + this.lineLength / 2.0, this.heavyCm.getY() + (double)(this.lineThickness / 2));
        this.heavyCmXLocLine.setFrameFromCenter(this.heavyCm.getX(), this.boxLowerEdge, this.heavyCm.getX() + (double)(this.lineThickness / 2), this.boxLowerEdge + this.lineLength / 2.0);
        this.setBoundsDirty();
        this.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        Color color;
        this.saveGraphicsState(graphics2D);
        graphics2D.setStroke(this.cmStroke);
        if (this.lightCm.getY() != 0.0) {
            color = graphics2D.getColor();
            graphics2D.setColor(Color.red);
            graphics2D.fill(this.lightCmYLocLine);
            graphics2D.fill(this.lightCmXLocLine);
            graphics2D.setColor(color);
        }
        if (this.heavyCm.getY() != 0.0) {
            color = graphics2D.getColor();
            graphics2D.setColor(Color.blue);
            graphics2D.fill(this.heavyCmYLocLine);
            graphics2D.fill(this.heavyCmXLocLine);
            graphics2D.setColor(color);
        }
        this.restoreGraphicsState();
    }
}

