class QuadroHorario:
    
    def __init__(self):
        self.horarios = ["0730", "0820", "0910", "1010", "1100",
                         "1330", "1420", "1510", "1620", "1710",
                         "1830", "1920", "2020", "2120"]
        self.dias_semana = ["Seg", "Ter", "Qua", "Qui", "Sex", "Sáb"]
        self.grade = [[None] * 6 for _ in range(len(self.horarios))]
        
    def anota_horarios(self, codigo_disciplina, horarios):
        for horario in horarios:
            coluna = int(horario[0]) - 2
            linha = self.horarios.index(horario[1:5])
            num_aulas = int(horario[-1])
            for offset in range(num_aulas):
                self.grade[linha+offset][coluna] = codigo_disciplina

    def tem_choque_horario(self, horarios):
        for horario in horarios:
            coluna = int(horario[0]) - 2
            linha = self.horarios.index(horario[1:5])
            num_aulas = int(horario[-1])
            for offset in range(num_aulas):
                if self.grade[linha+offset][coluna] != None:
                    return True
        return False
    
    def mostra(self):
        print("     ", end='')
        for ds in self.dias_semana:
            print(f"{ds:8}", end='')
        print()
        for lin in range(len(self.horarios)):
            print(self.horarios[lin], end= '')
            for item in self.grade[lin]:
                texto = "       " if item == None else item
                print(" "+texto, end='')
            print()
    
                
        
        
            
            