from xadrez import *

'''
tabuleiro = Tabuleiro()

#  https://en-m-wikipedia-org.translate.goog/wiki/Game_of_the_Century_(chess)?_x_tr_sl=en&_x_tr_tl=pt&_x_tr_hl=pt&_x_tr_pto=wa
# Algumas ações
tabuleiro.posicao_inicial()
tabuleiro.move_peca('g1', 'f3') # Nf3 br - 01
tabuleiro.move_peca('g8', 'f6') # Nf6
tabuleiro.move_peca('c2', 'c4') # c4 br
tabuleiro.move_peca('g7', 'g6') # g6
tabuleiro.move_peca('b1', 'c3') # Nc3 br
tabuleiro.move_peca('f8', 'g7') # Bg7
tabuleiro.move_peca('d2', 'd4') # d4 br
tabuleiro.roque('e8', 'g8', 'h8', 'f8') # 0-0
tabuleiro.move_peca('c1', 'f4') # Bf4 br
tabuleiro.move_peca('d7', 'd5') # d5
tabuleiro.move_peca('d1', 'b3') # Qb3 br
tabuleiro.move_peca('d5', 'c4') # dxc4
tabuleiro.move_peca('b3', 'c4') # Qxc4 br
tabuleiro.move_peca('c7', 'c6') # c6
tabuleiro.move_peca('e2', 'e4') # e4 br
tabuleiro.move_peca('b8', 'd7') # Nbd7
tabuleiro.move_peca('a1', 'd1') # Rd1 br
tabuleiro.move_peca('d7', 'b6') # Nb6
tabuleiro.move_peca('c4', 'c5') # Qc5 br
tabuleiro.move_peca('c8', 'g4') # Bg4

tabuleiro.move_peca('f4', 'g5') # Bg5 br - 11
tabuleiro.move_peca('b6', 'a4') # Na4
tabuleiro.move_peca('c5', 'a3') # Qa3 br
tabuleiro.move_peca('a4', 'c3') # Nxc3
tabuleiro.move_peca('b2', 'c3') # bxc3 br
tabuleiro.move_peca('f6', 'e4') # Nxe4
tabuleiro.move_peca('g5', 'e7') # Bxe7 br
tabuleiro.move_peca('d8', 'b6') # Qb6
tabuleiro.move_peca('f1', 'c4') # Bc4 br
tabuleiro.move_peca('e4', 'c3') # Nxc3
tabuleiro.move_peca('e7', 'c5') # Bc5 br
tabuleiro.move_peca('f8', 'e8') # Rfe8+
tabuleiro.move_peca('e1', 'f1') # Kf1  br
tabuleiro.move_peca('g4', 'e6') # Be6!!
tabuleiro.move_peca('c5', 'b6') # Bxb6? br
tabuleiro.move_peca('e6', 'c4') # Bxc4+
tabuleiro.move_peca('f1', 'g1') # Kg1 br
tabuleiro.move_peca('c3', 'e2') # Ne2+
tabuleiro.move_peca('g1', 'f1') # Kf1 br
tabuleiro.move_peca('e2', 'd4') # Nxd4+

tabuleiro.move_peca('f1', 'g1') # Kg1 br - 21
tabuleiro.move_peca('d4', 'e2') # Ne2+
tabuleiro.move_peca('g1', 'f1') # Kf1 br
tabuleiro.move_peca('e2', 'c3') # Nc3+
tabuleiro.move_peca('f1', 'g1') # Kg1 br
tabuleiro.move_peca('a7', 'b6') # axb6
tabuleiro.move_peca('a3', 'b4') # Qb4 br
tabuleiro.move_peca('a8', 'a4') # Ra4!
tabuleiro.move_peca('b4', 'b6') # Qxb6 br
tabuleiro.move_peca('c3', 'd1') # Nxd1
tabuleiro.move_peca('h2', 'h3') # h3 br
tabuleiro.move_peca('a4', 'a2') # Rxa2
tabuleiro.move_peca('g1', 'h2') # Kh2 br
tabuleiro.move_peca('a2', 'f2') # Nxf2
tabuleiro.move_peca('h1', 'e1') # Re1 br
tabuleiro.move_peca('e8', 'e1') # Rxe1
tabuleiro.move_peca('b6', 'd8') # Qd8+ br
tabuleiro.move_peca('g7', 'f8') # Bf8
tabuleiro.move_peca('f3', 'e1') # Nxe1 br
tabuleiro.move_peca('c4', 'd5') # Bd5

tabuleiro.mostra()
'''

# ------------------------------------------------------------
# Desafio de São Petersburgo de Xadrez

try:
    while True:
        tabuleiro = Tabuleiro()
        
        n = int(input())
        pecas_pretas = input().split()  # A exemplo de 'Tc2 Pe5 Wf4 Rf7'
        rei_branco = input()            # A exemplo de 'Wd6'

        tabuleiro.insere_pecas(pecas_pretas, 'branca')
        tabuleiro.insere_peca(rei_branco, 'preta')

        tabuleiro.calcula_dominancia('branca')
        tabuleiro.mostra_dominancia()
        print('Sim' if tabuleiro.esta_cheque_mate('preta') else 'Nao')
except EOFError:
    pass